/**
 * Copyright(c) 2015 by LG Electronics. Confidential and Proprietary
 * All Rights Reserved.
 *
 * Filename :$File:$
 *
 * Revision :$Revision:$
 *
 * Description : Example
 *
 * Date                Author                        Change
 * ----------       ----------------    ------------------------------------------
 *
 */

#ifndef _CRT_SECURE_NO_DEPRECATE
#define _CRT_SECURE_NO_DEPRECATE 1
#endif

//#include <stdlib.h>
#include <string.h>
//#include <stdio.h>

#include    "lge_fota_std.h"

#include "rsa_core.h"
#include "rsa_sha1.h"
#include    "bio.h"
#include    "rsa.h"
#include    "evp.h"
#include    "objects.h"
#include    "x509.h"

//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
typedef struct
{
    unsigned char        modulus[128];    /* 128 Byte */
    unsigned char        pub_key[128];    /* 128 Byte */
    unsigned char        pri_key[128];    /* 128 Byte */
    unsigned char        P[64];    /* 64 Byte */
    unsigned char        Q[64];    /* 64 Byte */
    unsigned char        DP[64];    /* 64 Byte */
    unsigned char        DQ[64];    /* 64 Byte */
    unsigned char        QP[64];    /* 64 Byte */
}rsa_key_type;


//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
typedef struct st_RSAFileSystem {
    ua_u8         *pData;
    ua_u32        uiSize;
    ua_u32        uiCurrent;
} sRSAFileSys;


//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
LOCAL ua_u32    RSAFileSys_Read(sRSAFileSys *pFile, void *pData, ua_u32 uiSize);
LOCAL void      ReadMpi(sRSAFileSys *spKey, mpi *pMpi);
LOCAL void      LoadPublicKey(rsa_context *rsa);
LOCAL void      GetDigest(int obj_len, unsigned char *DigestValue);

//---------------------------------------------------------------------------------------------------------------
//
//---------------------------------------------------------------------------------------------------------------
ua_s32             (*pfSeek)(ua_s32);
ua_s32             (*pfRead)(ua_u8 *, ua_s32);
sRSAFileSys        *m_spKey;

ua_bool       RSA1024_CheckSign(ua_u32 obj_len, ua_u32 *SIG_LENGTH, ua_s32 (*Seek)(ua_u32), ua_u32 (*Read)(ua_u8 *, ua_u32))
{
    unsigned char                DigestValue[DSA_SHA1_DIGEST_VALUELEN];
    unsigned char                rsa_ciphertext[128];
    ua_s32                       iSignLen;
    rsa_context                 *rsa;
    sUtilFileSys                *spKey;


    spKey = UtilDataFile_Open("public.key");

    //test case
    iSignLen = 128;

    m_spKey = spKey;

    pfSeek = Seek;
    pfRead = Read;



    pfSeek(0);
    pfRead(rsa_ciphertext, iSignLen);


    (*SIG_LENGTH) = iSignLen;
    obj_len -= (*SIG_LENGTH);


    GetDigest(obj_len, DigestValue);

    rsa = (rsa_context *)FOTA_HEAP_ALLOC(sizeof(rsa_context));
    if (rsa == ua_null) {
        return ua_false;
    }
    LoadPublicKey(rsa);


    if( rsa_check_pubkey(rsa) != 0)
    {
        rsa_free(rsa);

        FOTA_HEAP_FREE(rsa);

        FOTALOG_PRINT("rsa_check_pubkey : fail");

        return ua_false;
    }


    if( rsa_pkcs1_verify( rsa, RSA_RAW, DigestValue, 20,
        rsa_ciphertext, iSignLen ) != 0 )
    {
        rsa_free(rsa);

        FOTA_HEAP_FREE(rsa);

        FOTALOG_PRINT("RSA_CheckSign : fail");

        return ua_false;
    }

    rsa_free(rsa);

    FOTA_HEAP_FREE(rsa);

    FOTALOG_PRINT("RSA_CheckSign : Sucsess");

    return ua_true;
}



LOCAL ua_u32    RSAFileSys_Read(sRSAFileSys *pFile, void *pData, ua_u32 uiSize)
{
    if (pFile->uiSize < pFile->uiCurrent + uiSize)
    {
        uiSize = pFile->uiSize - pFile->uiCurrent;
    }

    memcpy(pData, (ua_u8 *)(pFile->pData + pFile->uiCurrent), uiSize);

    pFile->uiCurrent += uiSize;

    return uiSize;
}


LOCAL void ReadMpi(sRSAFileSys *spKey, mpi *pMpi)
{
    RSAFileSys_Read(spKey, &pMpi->s, 4);
    RSAFileSys_Read(spKey, &pMpi->n, 4);

    if (pMpi->n > 0)
    {
        pMpi->p = (t_int *)FOTA_HEAP_ALLOC(4 * pMpi->n);
        RSAFileSys_Read(spKey, pMpi->p, 4 * pMpi->n);
    }
}

LOCAL void LoadPublicKey(rsa_context *rsa)
{

    FOTALOG_PRINT("LoadPublicKey");

    memset(rsa, 0, sizeof(rsa_context));



    if (!m_spKey)
    {
        FOTALOG_PRINT("LoadPublicKey : error");

        return;
    }


    RSAFileSys_Read(m_spKey, &rsa->ver, 4);
    RSAFileSys_Read(m_spKey, &rsa->len, 4);

    FOTALOG_PRINT("rsa->ver : %d", rsa->ver);
    FOTALOG_PRINT("rsa->len : %d", rsa->len);



//    fread(&rsa->ver, 4, 1, fp);
//    fread(&rsa->len, 4, 1, fp);

    ReadMpi(m_spKey, &rsa->N);
    ReadMpi(m_spKey, &rsa->E);
    ReadMpi(m_spKey, &rsa->D);

//    fclose(fp);
}

LOCAL void GetDigest(int obj_len, unsigned char *DigestValue)
{
    BYTE                SrcData[1024+32];
    DSA_SHA1_ALG_INFO    AlgInfo;
    DWORD                SrcLen = 128;


    FOTALOG_PRINT("GetDigest len : %d", obj_len);

    DSA_SHA1_Init(&AlgInfo);

    for(;;)
    {
        if(obj_len < 1024 )
        {
            pfSeek(SrcLen);
            pfRead(SrcData, obj_len);

            DSA_SHA1_Update(&AlgInfo, SrcData,obj_len);
            break;
        }
        else
        {
            pfSeek(SrcLen);
            pfRead(SrcData, 1024);

            DSA_SHA1_Update(&AlgInfo, SrcData,1024);
            obj_len-=1024;
            SrcLen+=1024;
        }
    }


    DSA_SHA1_Final(&AlgInfo, DigestValue);
}
