/*****************************************************************************
	Copyright(c) 2013 FCI Inc. All Rights Reserved

	File name : fc8300b_tun_table.c

	Description : source of FC8300B tuner driver

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

	History :
	----------------------------------------------------------------------
******************************************************************************/
#include "fci_types.h"

u32 b_ch_mode_0[7][57][3] = {
	{
		{473143, 0x6e, 0x00},
		{479143, 0x75, 0x70},
		{485143, 0x75, 0x40},
		{491143, 0x75, 0x40},
		{497143, 0x75, 0x60},
		{503143, 0x75, 0x00},
		{509143, 0x76, 0x40},
		{515143, 0x76, 0x40},
		{521143, 0x76, 0x70},
		{527143, 0x77, 0x00},
		{533143, 0x77, 0x00},
		{539143, 0x76, 0x50},
		{545143, 0x76, 0x70},
		{551143, 0x76, 0x00},
		{557143, 0x76, 0x70},
		{563143, 0x76, 0x00},
		{569143, 0x77, 0x00},
		{575143, 0x77, 0x70},
		{581143, 0x77, 0x00},
		{587143, 0x77, 0x60},
		{593143, 0x78, 0x00},
		{599143, 0x78, 0x60},
		{605143, 0x79, 0x60},
		{611143, 0x78, 0x60},
		{617143, 0x79, 0x40},
		{623143, 0x79, 0x00},
		{629143, 0x79, 0x00},
		{635143, 0x79, 0x00},
		{641143, 0x79, 0x00},
		{647143, 0x79, 0x00},
		{653143, 0x79, 0x00},
		{659143, 0x79, 0x00},
		{665143, 0x78, 0x00},
		{671143, 0x78, 0x00},
		{677143, 0x78, 0x00},
		{683143, 0x78, 0x00},
		{689143, 0x77, 0x00},
		{695143, 0x77, 0x00},
		{701143, 0x77, 0x00},
		{707143, 0x77, 0x00},
		{713143, 0x77, 0x20},
		{719143, 0x76, 0x20},
		{725143, 0x76, 0x20},
		{731143, 0x76, 0x20},
		{737143, 0x76, 0x20},
		{743143, 0x76, 0x20},
		{749143, 0x75, 0x20},
		{755143, 0x75, 0x20},
		{761143, 0x75, 0x20},
		{767143, 0x75, 0x20},
		{773143, 0x74, 0x20},
		{779143, 0x74, 0x20},
		{785143, 0x74, 0x20},
		{791143, 0x74, 0x20},
		{797143, 0x73, 0x20},
		{803143, 0x73, 0x70},
		{809143, 0x72, 0x40},
	},
	{
		{473143, 0x6e, 0x40},
		{479143, 0x75, 0x40},
		{485143, 0x75, 0x40},
		{491143, 0x75, 0x40},
		{497143, 0x75, 0x40},
		{503143, 0x75, 0x40},
		{509143, 0x76, 0x40},
		{515143, 0x76, 0x00},
		{521143, 0x76, 0x00},
		{527143, 0x77, 0x00},
		{533143, 0x77, 0x70},
		{539143, 0x76, 0x70},
		{545143, 0x76, 0x70},
		{551143, 0x76, 0x70},
		{557143, 0x76, 0x00},
		{563143, 0x76, 0x00},
		{569143, 0x77, 0x30},
		{575143, 0x77, 0x00},
		{581143, 0x77, 0x30},
		{587143, 0x77, 0x60},
		{593143, 0x78, 0x60},
		{599143, 0x78, 0x60},
		{605143, 0x79, 0x60},
		{611143, 0x78, 0x00},
		{617143, 0x79, 0x00},
		{623143, 0x79, 0x60},
		{629143, 0x79, 0x00},
		{635143, 0x79, 0x00},
		{641143, 0x79, 0x00},
		{647143, 0x79, 0x50},
		{653143, 0x79, 0x00},
		{659143, 0x79, 0x00},
		{665143, 0x78, 0x00},
		{671143, 0x78, 0x50},
		{677143, 0x78, 0x00},
		{683143, 0x78, 0x20},
		{689143, 0x77, 0x20},
		{695143, 0x77, 0x50},
		{701143, 0x77, 0x20},
		{707143, 0x77, 0x20},
		{713143, 0x77, 0x20},
		{719143, 0x76, 0x20},
		{725143, 0x76, 0x20},
		{731143, 0x76, 0x20},
		{737143, 0x76, 0x20},
		{743143, 0x76, 0x20},
		{749143, 0x75, 0x20},
		{755143, 0x75, 0x20},
		{761143, 0x75, 0x20},
		{767143, 0x75, 0x20},
		{773143, 0x74, 0x20},
		{779143, 0x74, 0x20},
		{785143, 0x74, 0x20},
		{791143, 0x74, 0x20},
		{797143, 0x73, 0x20},
		{803143, 0x73, 0x20},
		{809143, 0x72, 0x20},
	},
	{
		{473143, 0x6e, 0x40},
		{479143, 0x75, 0x00},
		{485143, 0x75, 0x00},
		{491143, 0x75, 0x00},
		{497143, 0x75, 0x00},
		{503143, 0x75, 0x00},
		{509143, 0x76, 0x00},
		{515143, 0x76, 0x00},
		{521143, 0x76, 0x40},
		{527143, 0x77, 0x00},
		{533143, 0x77, 0x00},
		{539143, 0x76, 0x00},
		{545143, 0x76, 0x70},
		{551143, 0x76, 0x30},
		{557143, 0x76, 0x00},
		{563143, 0x76, 0x00},
		{569143, 0x77, 0x30},
		{575143, 0x77, 0x30},
		{581143, 0x77, 0x00},
		{587143, 0x77, 0x00},
		{593143, 0x78, 0x30},
		{599143, 0x78, 0x30},
		{605143, 0x79, 0x30},
		{611143, 0x78, 0x30},
		{617143, 0x79, 0x00},
		{623143, 0x79, 0x20},
		{629143, 0x79, 0x30},
		{635143, 0x79, 0x00},
		{641143, 0x79, 0x00},
		{647143, 0x79, 0x30},
		{653143, 0x79, 0x50},
		{659143, 0x79, 0x00},
		{665143, 0x78, 0x00},
		{671143, 0x78, 0x70},
		{677143, 0x78, 0x40},
		{683143, 0x78, 0x00},
		{689143, 0x77, 0x00},
		{695143, 0x77, 0x00},
		{701143, 0x77, 0x40},
		{707143, 0x77, 0x50},
		{713143, 0x77, 0x50},
		{719143, 0x76, 0x50},
		{725143, 0x76, 0x50},
		{731143, 0x76, 0x20},
		{737143, 0x76, 0x50},
		{743143, 0x76, 0x50},
		{749143, 0x75, 0x40},
		{755143, 0x75, 0x30},
		{761143, 0x75, 0x70},
		{767143, 0x75, 0x20},
		{773143, 0x74, 0x20},
		{779143, 0x74, 0x10},
		{785143, 0x74, 0x40},
		{791143, 0x74, 0x70},
		{797143, 0x73, 0x20},
		{803143, 0x73, 0x30},
		{809143, 0x72, 0x50},
	},
	{
		{473143, 0x6e, 0x00},
		{479143, 0x75, 0x00},
		{485143, 0x75, 0x00},
		{491143, 0x75, 0x00},
		{497143, 0x75, 0x00},
		{503143, 0x75, 0x00},
		{509143, 0x76, 0x00},
		{515143, 0x76, 0x40},
		{521143, 0x76, 0x40},
		{527143, 0x77, 0x00},
		{533143, 0x77, 0x40},
		{539143, 0x76, 0x30},
		{545143, 0x76, 0x00},
		{551143, 0x76, 0x00},
		{557143, 0x76, 0x00},
		{563143, 0x76, 0x70},
		{569143, 0x77, 0x70},
		{575143, 0x77, 0x30},
		{581143, 0x77, 0x00},
		{587143, 0x77, 0x30},
		{593143, 0x78, 0x00},
		{599143, 0x78, 0x70},
		{605143, 0x79, 0x00},
		{611143, 0x78, 0x00},
		{617143, 0x79, 0x00},
		{623143, 0x79, 0x30},
		{629143, 0x79, 0x30},
		{635143, 0x79, 0x00},
		{641143, 0x79, 0x00},
		{647143, 0x79, 0x60},
		{653143, 0x79, 0x00},
		{659143, 0x79, 0x00},
		{665143, 0x78, 0x00},
		{671143, 0x78, 0x00},
		{677143, 0x78, 0x00},
		{683143, 0x78, 0x00},
		{689143, 0x77, 0x00},
		{695143, 0x77, 0x00},
		{701143, 0x77, 0x00},
		{707143, 0x77, 0x00},
		{713143, 0x77, 0x00},
		{719143, 0x76, 0x00},
		{725143, 0x76, 0x20},
		{731143, 0x76, 0x20},
		{737143, 0x76, 0x20},
		{743143, 0x76, 0x20},
		{749143, 0x75, 0x20},
		{755143, 0x75, 0x20},
		{761143, 0x75, 0x20},
		{767143, 0x75, 0x20},
		{773143, 0x74, 0x20},
		{779143, 0x74, 0x20},
		{785143, 0x74, 0x20},
		{791143, 0x74, 0x20},
		{797143, 0x73, 0x20},
		{803143, 0x73, 0x20},
		{809143, 0x72, 0x20},
	},
	{
		{473143, 0x6e, 0x40},
		{479143, 0x75, 0x40},
		{485143, 0x75, 0x00},
		{491143, 0x75, 0x00},
		{497143, 0x75, 0x00},
		{503143, 0x75, 0x00},
		{509143, 0x76, 0x00},
		{515143, 0x76, 0x00},
		{521143, 0x76, 0x00},
		{527143, 0x77, 0x00},
		{533143, 0x77, 0x00},
		{539143, 0x76, 0x00},
		{545143, 0x76, 0x30},
		{551143, 0x76, 0x30},
		{557143, 0x76, 0x00},
		{563143, 0x76, 0x00},
		{569143, 0x77, 0x00},
		{575143, 0x77, 0x00},
		{581143, 0x77, 0x30},
		{587143, 0x77, 0x30},
		{593143, 0x78, 0x30},
		{599143, 0x78, 0x30},
		{605143, 0x79, 0x00},
		{611143, 0x78, 0x00},
		{617143, 0x79, 0x00},
		{623143, 0x79, 0x00},
		{629143, 0x79, 0x00},
		{635143, 0x79, 0x00},
		{641143, 0x79, 0x30},
		{647143, 0x79, 0x00},
		{653143, 0x79, 0x00},
		{659143, 0x79, 0x00},
		{665143, 0x78, 0x00},
		{671143, 0x78, 0x20},
		{677143, 0x78, 0x00},
		{683143, 0x78, 0x00},
		{689143, 0x77, 0x00},
		{695143, 0x77, 0x20},
		{701143, 0x77, 0x00},
		{707143, 0x77, 0x20},
		{713143, 0x77, 0x00},
		{719143, 0x76, 0x20},
		{725143, 0x76, 0x20},
		{731143, 0x76, 0x00},
		{737143, 0x76, 0x50},
		{743143, 0x76, 0x20},
		{749143, 0x75, 0x20},
		{755143, 0x75, 0x20},
		{761143, 0x75, 0x00},
		{767143, 0x75, 0x40},
		{773143, 0x74, 0x20},
		{779143, 0x74, 0x40},
		{785143, 0x74, 0x40},
		{791143, 0x74, 0x00},
		{797143, 0x73, 0x00},
		{803143, 0x73, 0x40},
		{809143, 0x72, 0x00},
	},
	{
		{473143, 0x6e, 0x40},
		{479143, 0x75, 0x40},
		{485143, 0x75, 0x40},
		{491143, 0x75, 0x40},
		{497143, 0x75, 0x40},
		{503143, 0x75, 0x00},
		{509143, 0x76, 0x00},
		{515143, 0x76, 0x70},
		{521143, 0x76, 0x70},
		{527143, 0x77, 0x70},
		{533143, 0x77, 0x70},
		{539143, 0x76, 0x70},
		{545143, 0x76, 0x70},
		{551143, 0x76, 0x30},
		{557143, 0x76, 0x30},
		{563143, 0x76, 0x30},
		{569143, 0x77, 0x60},
		{575143, 0x77, 0x60},
		{581143, 0x77, 0x30},
		{587143, 0x77, 0x30},
		{593143, 0x78, 0x30},
		{599143, 0x78, 0x30},
		{605143, 0x79, 0x30},
		{611143, 0x78, 0x50},
		{617143, 0x79, 0x50},
		{623143, 0x79, 0x50},
		{629143, 0x79, 0x20},
		{635143, 0x79, 0x30},
		{641143, 0x79, 0x30},
		{647143, 0x79, 0x00},
		{653143, 0x79, 0x00},
		{659143, 0x79, 0x50},
		{665143, 0x78, 0x50},
		{671143, 0x78, 0x50},
		{677143, 0x78, 0x50},
		{683143, 0x78, 0x50},
		{689143, 0x77, 0x50},
		{695143, 0x77, 0x50},
		{701143, 0x77, 0x50},
		{707143, 0x77, 0x50},
		{713143, 0x77, 0x20},
		{719143, 0x76, 0x20},
		{725143, 0x76, 0x20},
		{731143, 0x76, 0x70},
		{737143, 0x76, 0x70},
		{743143, 0x76, 0x70},
		{749143, 0x75, 0x70},
		{755143, 0x75, 0x70},
		{761143, 0x75, 0x70},
		{767143, 0x75, 0x50},
		{773143, 0x74, 0x50},
		{779143, 0x74, 0x10},
		{785143, 0x74, 0x10},
		{791143, 0x74, 0x10},
		{797143, 0x73, 0x10},
		{803143, 0x73, 0x10},
		{809143, 0x72, 0x10},
	},
	{
		{473143, 0x6e, 0x40},
		{479143, 0x75, 0x40},
		{485143, 0x75, 0x40},
		{491143, 0x75, 0x40},
		{497143, 0x75, 0x40},
		{503143, 0x75, 0x40},
		{509143, 0x76, 0x30},
		{515143, 0x76, 0x30},
		{521143, 0x76, 0x00},
		{527143, 0x77, 0x00},
		{533143, 0x77, 0x30},
		{539143, 0x76, 0x30},
		{545143, 0x76, 0x30},
		{551143, 0x76, 0x30},
		{557143, 0x76, 0x10},
		{563143, 0x76, 0x30},
		{569143, 0x77, 0x30},
		{575143, 0x77, 0x30},
		{581143, 0x77, 0x30},
		{587143, 0x77, 0x30},
		{593143, 0x78, 0x30},
		{599143, 0x78, 0x00},
		{605143, 0x79, 0x30},
		{611143, 0x78, 0x30},
		{617143, 0x79, 0x20},
		{623143, 0x79, 0x20},
		{629143, 0x79, 0x20},
		{635143, 0x79, 0x10},
		{641143, 0x79, 0x00},
		{647143, 0x79, 0x20},
		{653143, 0x79, 0x20},
		{659143, 0x79, 0x20},
		{665143, 0x78, 0x20},
		{671143, 0x78, 0x30},
		{677143, 0x78, 0x20},
		{683143, 0x78, 0x20},
		{689143, 0x77, 0x20},
		{695143, 0x77, 0x20},
		{701143, 0x77, 0x20},
		{707143, 0x77, 0x50},
		{713143, 0x77, 0x20},
		{719143, 0x76, 0x10},
		{725143, 0x76, 0x10},
		{731143, 0x76, 0x20},
		{737143, 0x76, 0x40},
		{743143, 0x76, 0x20},
		{749143, 0x75, 0x10},
		{755143, 0x75, 0x40},
		{761143, 0x75, 0x40},
		{767143, 0x75, 0x40},
		{773143, 0x74, 0x40},
		{779143, 0x74, 0x70},
		{785143, 0x74, 0x40},
		{791143, 0x74, 0x10},
		{797143, 0x73, 0x10},
		{803143, 0x73, 0x10},
		{809143, 0x72, 0x30}
	}
};

u32 b_ch_mode_1[7][9][3] = {
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	},
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	},
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	},
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	},
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	},
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	},
	{
		{210429, 0x72, 0x20},
		{216000, 0x72, 0x20},
		{219000, 0x71, 0x20},
		{219429, 0x71, 0x20},
		{219857, 0x71, 0x20},
		{220286, 0x70, 0x20},
		{220714, 0x70, 0x20},
		{221143, 0x70, 0x20},
		{221571, 0x6f, 0x20}
	}
};

u32 b_ch_mode_4[7][88][3] = {
	{
		{473143, 0x70, 0x00},
		{479143, 0x70, 0x70},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x60},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x40},
		{515143, 0x6f, 0x40},
		{521143, 0x6f, 0x70},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x00},
		{539143, 0x6f, 0x50},
		{545143, 0x6f, 0x70},
		{551143, 0x6f, 0x00},
		{557143, 0x6f, 0x70},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x00},
		{575143, 0x70, 0x70},
		{581143, 0x70, 0x00},
		{587143, 0x71, 0x60},
		{593143, 0x72, 0x00},
		{599143, 0x72, 0x60},
		{605143, 0x72, 0x60},
		{611143, 0x73, 0x60},
		{617143, 0x73, 0x40},
		{623143, 0x74, 0x00},
		{629143, 0x74, 0x00},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x00},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x00},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x00},
		{701143, 0x73, 0x00},
		{707143, 0x72, 0x00},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x20},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x20},
		{767143, 0x6f, 0x20},
		{773143, 0x6e, 0x20},
		{779143, 0x6e, 0x20},
		{785143, 0x6e, 0x20},
		{791143, 0x6e, 0x20},
		{797143, 0x6d, 0x20},
		{803143, 0x6d, 0x70},
		{809143, 0x6c, 0x40}
	},
	{
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x40},
		{503143, 0x6f, 0x40},
		{509143, 0x6f, 0x40},
		{515143, 0x6f, 0x00},
		{521143, 0x6f, 0x00},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x70},
		{539143, 0x6f, 0x70},
		{545143, 0x6f, 0x70},
		{551143, 0x6f, 0x70},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x30},
		{575143, 0x70, 0x00},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x60},
		{593143, 0x72, 0x60},
		{599143, 0x72, 0x60},
		{605143, 0x72, 0x60},
		{611143, 0x73, 0x00},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x60},
		{629143, 0x74, 0x00},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x50},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x50},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x20},
		{689143, 0x73, 0x20},
		{695143, 0x73, 0x50},
		{701143, 0x73, 0x20},
		{707143, 0x72, 0x20},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x20},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x20},
		{767143, 0x6f, 0x20},
		{773143, 0x6e, 0x20},
		{779143, 0x6e, 0x20},
		{785143, 0x6e, 0x20},
		{791143, 0x6e, 0x20},
		{797143, 0x6d, 0x20},
		{803143, 0x6d, 0x20},
		{809143, 0x6c, 0x20}
	},
	{
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x00},
		{485143, 0x70, 0x00},
		{491143, 0x70, 0x00},
		{497143, 0x70, 0x00},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x00},
		{521143, 0x6f, 0x40},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x00},
		{539143, 0x6f, 0x00},
		{545143, 0x6f, 0x70},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x30},
		{575143, 0x70, 0x30},
		{581143, 0x70, 0x00},
		{587143, 0x71, 0x00},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x30},
		{605143, 0x72, 0x30},
		{611143, 0x73, 0x30},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x20},
		{629143, 0x74, 0x30},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x30},
		{653143, 0x74, 0x50},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x70},
		{677143, 0x74, 0x40},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x00},
		{701143, 0x73, 0x40},
		{707143, 0x72, 0x50},
		{713143, 0x71, 0x50},
		{719143, 0x71, 0x50},
		{725143, 0x71, 0x50},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x50},
		{743143, 0x70, 0x50},
		{749143, 0x6f, 0x40},
		{755143, 0x6f, 0x30},
		{761143, 0x6f, 0x70},
		{767143, 0x6f, 0x20},
		{773143, 0x6e, 0x20},
		{779143, 0x6e, 0x10},
		{785143, 0x6e, 0x40},
		{791143, 0x6e, 0x70},
		{797143, 0x6d, 0x20},
		{803143, 0x6d, 0x30},
		{809143, 0x6c, 0x50}
	},
	{
		{473143, 0x70, 0x00},
		{479143, 0x70, 0x00},
		{485143, 0x70, 0x00},
		{491143, 0x70, 0x00},
		{497143, 0x70, 0x00},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x40},
		{521143, 0x6f, 0x40},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x40},
		{539143, 0x6f, 0x30},
		{545143, 0x6f, 0x00},
		{551143, 0x6f, 0x00},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x70},
		{569143, 0x70, 0x70},
		{575143, 0x70, 0x30},
		{581143, 0x70, 0x00},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x00},
		{599143, 0x72, 0x70},
		{605143, 0x72, 0x00},
		{611143, 0x73, 0x00},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x30},
		{629143, 0x74, 0x30},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x60},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x00},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x00},
		{701143, 0x73, 0x00},
		{707143, 0x72, 0x00},
		{713143, 0x71, 0x00},
		{719143, 0x71, 0x00},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x20},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x20},
		{767143, 0x6f, 0x20},
		{773143, 0x6e, 0x20},
		{779143, 0x6e, 0x20},
		{785143, 0x6e, 0x20},
		{791143, 0x6e, 0x20},
		{797143, 0x6d, 0x20},
		{803143, 0x6d, 0x20},
		{809143, 0x6c, 0x20}
	},
	{
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x00},
		{491143, 0x70, 0x00},
		{497143, 0x70, 0x00},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x00},
		{521143, 0x6f, 0x00},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x00},
		{539143, 0x6f, 0x00},
		{545143, 0x6f, 0x30},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x00},
		{575143, 0x70, 0x00},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x30},
		{605143, 0x72, 0x00},
		{611143, 0x73, 0x00},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x00},
		{629143, 0x74, 0x00},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x30},
		{647143, 0x74, 0x00},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x20},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x20},
		{701143, 0x73, 0x00},
		{707143, 0x72, 0x20},
		{713143, 0x71, 0x00},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x00},
		{737143, 0x70, 0x50},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x00},
		{767143, 0x6f, 0x40},
		{773143, 0x6e, 0x20},
		{779143, 0x6e, 0x40},
		{785143, 0x6e, 0x40},
		{791143, 0x6e, 0x00},
		{797143, 0x6d, 0x00},
		{803143, 0x6d, 0x40},
		{809143, 0x6c, 0x00}
	},
	{
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x40},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x70},
		{521143, 0x6f, 0x70},
		{527143, 0x6f, 0x70},
		{533143, 0x6f, 0x70},
		{539143, 0x6f, 0x70},
		{545143, 0x6f, 0x40},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x30},
		{563143, 0x70, 0x30},
		{569143, 0x70, 0x60},
		{575143, 0x70, 0x60},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x30},
		{605143, 0x72, 0x30},
		{611143, 0x73, 0x50},
		{617143, 0x73, 0x50},
		{623143, 0x74, 0x50},
		{629143, 0x74, 0x20},
		{635143, 0x73, 0x30},
		{641143, 0x74, 0x30},
		{647143, 0x74, 0x00},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x50},
		{665143, 0x74, 0x50},
		{671143, 0x74, 0x50},
		{677143, 0x74, 0x50},
		{683143, 0x73, 0x50},
		{689143, 0x73, 0x50},
		{695143, 0x73, 0x50},
		{701143, 0x73, 0x50},
		{707143, 0x72, 0x50},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x70},
		{737143, 0x70, 0x70},
		{743143, 0x70, 0x70},
		{749143, 0x6f, 0x70},
		{755143, 0x6f, 0x70},
		{761143, 0x6f, 0x70},
		{767143, 0x6f, 0x50},
		{773143, 0x6e, 0x50},
		{779143, 0x6e, 0x10},
		{785143, 0x6e, 0x10},
		{791143, 0x6e, 0x10},
		{797143, 0x6d, 0x10},
		{803143, 0x6d, 0x10},
		{809143, 0x6c, 0x10}
	},
	{
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x40},
		{503143, 0x6f, 0x40},
		{509143, 0x6f, 0x30},
		{515143, 0x6f, 0x30},
		{521143, 0x6f, 0x00},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x30},
		{539143, 0x6f, 0x30},
		{545143, 0x6f, 0x30},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x10},
		{563143, 0x70, 0x30},
		{569143, 0x70, 0x30},
		{575143, 0x70, 0x30},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x00},
		{605143, 0x72, 0x30},
		{611143, 0x73, 0x30},
		{617143, 0x73, 0x20},
		{623143, 0x74, 0x20},
		{629143, 0x74, 0x20},
		{635143, 0x73, 0x10},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x20},
		{653143, 0x74, 0x20},
		{659143, 0x73, 0x20},
		{665143, 0x74, 0x20},
		{671143, 0x74, 0x30},
		{677143, 0x74, 0x20},
		{683143, 0x73, 0x20},
		{689143, 0x73, 0x20},
		{695143, 0x73, 0x20},
		{701143, 0x73, 0x20},
		{707143, 0x72, 0x50},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x10},
		{725143, 0x71, 0x10},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x40},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x10},
		{755143, 0x6f, 0x40},
		{761143, 0x6f, 0x40},
		{767143, 0x6f, 0x40},
		{773143, 0x6e, 0x40},
		{779143, 0x6e, 0x70},
		{785143, 0x6e, 0x40},
		{791143, 0x6e, 0x10},
		{797143, 0x6d, 0x10},
		{803143, 0x6d, 0x10},
		{809143, 0x6c, 0x30}
	}
};

u32 b_ch_mode_5[7][2][3] = {
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	},
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	},
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	},
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	},
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	},
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	},
	{
		{210429, 0x6b, 0x30},
		{216000, 0x6b, 0x30}
	}
};

u32 b_ch_mode_6[7][113][3] = {
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x00},
		{479143, 0x70, 0x70},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x60},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x40},
		{515143, 0x6f, 0x40},
		{521143, 0x6f, 0x70},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x00},
		{539143, 0x6f, 0x50},
		{545143, 0x6f, 0x70},
		{551143, 0x6f, 0x00},
		{557143, 0x6f, 0x70},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x00},
		{575143, 0x70, 0x70},
		{581143, 0x70, 0x00},
		{587143, 0x71, 0x60},
		{593143, 0x72, 0x00},
		{599143, 0x72, 0x60},
		{605143, 0x72, 0x60},
		{611143, 0x73, 0x60},
		{617143, 0x73, 0x40},
		{623143, 0x74, 0x00},
		{629143, 0x74, 0x00},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x00},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x00},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x00},
		{701143, 0x73, 0x00},
		{707143, 0x72, 0x00},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x20},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x20},
		{767143, 0x6f, 0x20}
	},
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x40},
		{503143, 0x6f, 0x40},
		{509143, 0x6f, 0x40},
		{515143, 0x6f, 0x00},
		{521143, 0x6f, 0x00},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x70},
		{539143, 0x6f, 0x70},
		{545143, 0x6f, 0x70},
		{551143, 0x6f, 0x70},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x30},
		{575143, 0x70, 0x00},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x60},
		{593143, 0x72, 0x60},
		{599143, 0x72, 0x60},
		{605143, 0x72, 0x60},
		{611143, 0x73, 0x00},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x60},
		{629143, 0x74, 0x00},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x50},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x50},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x20},
		{689143, 0x73, 0x20},
		{695143, 0x73, 0x50},
		{701143, 0x73, 0x20},
		{707143, 0x72, 0x20},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x20},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x20},
		{767143, 0x6f, 0x20}
	},
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x00},
		{485143, 0x70, 0x00},
		{491143, 0x70, 0x00},
		{497143, 0x70, 0x00},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x00},
		{521143, 0x6f, 0x40},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x00},
		{539143, 0x6f, 0x00},
		{545143, 0x6f, 0x70},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x30},
		{575143, 0x70, 0x30},
		{581143, 0x70, 0x00},
		{587143, 0x71, 0x00},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x30},
		{605143, 0x72, 0x30},
		{611143, 0x73, 0x30},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x20},
		{629143, 0x74, 0x30},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x30},
		{653143, 0x74, 0x50},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x70},
		{677143, 0x74, 0x40},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x00},
		{701143, 0x73, 0x40},
		{707143, 0x72, 0x50},
		{713143, 0x71, 0x50},
		{719143, 0x71, 0x50},
		{725143, 0x71, 0x50},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x50},
		{743143, 0x70, 0x50},
		{749143, 0x6f, 0x40},
		{755143, 0x6f, 0x30},
		{761143, 0x6f, 0x70},
		{767143, 0x6f, 0x20}
	},
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x00},
		{479143, 0x70, 0x00},
		{485143, 0x70, 0x00},
		{491143, 0x70, 0x00},
		{497143, 0x70, 0x00},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x40},
		{521143, 0x6f, 0x40},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x40},
		{539143, 0x6f, 0x30},
		{545143, 0x6f, 0x00},
		{551143, 0x6f, 0x00},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x70},
		{569143, 0x70, 0x70},
		{575143, 0x70, 0x30},
		{581143, 0x70, 0x00},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x00},
		{599143, 0x72, 0x70},
		{605143, 0x72, 0x00},
		{611143, 0x73, 0x00},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x30},
		{629143, 0x74, 0x30},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x60},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x00},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x00},
		{701143, 0x73, 0x00},
		{707143, 0x72, 0x00},
		{713143, 0x71, 0x00},
		{719143, 0x71, 0x00},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x20},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x20},
		{767143, 0x6f, 0x20}
	},
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x00},
		{491143, 0x70, 0x00},
		{497143, 0x70, 0x00},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x00},
		{521143, 0x6f, 0x00},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x00},
		{539143, 0x6f, 0x00},
		{545143, 0x6f, 0x30},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x00},
		{563143, 0x70, 0x00},
		{569143, 0x70, 0x00},
		{575143, 0x70, 0x00},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x30},
		{605143, 0x72, 0x00},
		{611143, 0x73, 0x00},
		{617143, 0x73, 0x00},
		{623143, 0x74, 0x00},
		{629143, 0x74, 0x00},
		{635143, 0x73, 0x00},
		{641143, 0x74, 0x30},
		{647143, 0x74, 0x00},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x00},
		{665143, 0x74, 0x00},
		{671143, 0x74, 0x20},
		{677143, 0x74, 0x00},
		{683143, 0x73, 0x00},
		{689143, 0x73, 0x00},
		{695143, 0x73, 0x20},
		{701143, 0x73, 0x00},
		{707143, 0x72, 0x20},
		{713143, 0x71, 0x00},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x00},
		{737143, 0x70, 0x50},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x20},
		{755143, 0x6f, 0x20},
		{761143, 0x6f, 0x00},
		{767143, 0x6f, 0x40}
	},
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x40},
		{503143, 0x6f, 0x00},
		{509143, 0x6f, 0x00},
		{515143, 0x6f, 0x70},
		{521143, 0x6f, 0x70},
		{527143, 0x6f, 0x70},
		{533143, 0x6f, 0x70},
		{539143, 0x6f, 0x70},
		{545143, 0x6f, 0x40},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x30},
		{563143, 0x70, 0x30},
		{569143, 0x70, 0x60},
		{575143, 0x70, 0x60},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x30},
		{605143, 0x72, 0x30},
		{611143, 0x73, 0x50},
		{617143, 0x73, 0x50},
		{623143, 0x74, 0x50},
		{629143, 0x74, 0x20},
		{635143, 0x73, 0x30},
		{641143, 0x74, 0x30},
		{647143, 0x74, 0x00},
		{653143, 0x74, 0x00},
		{659143, 0x73, 0x50},
		{665143, 0x74, 0x50},
		{671143, 0x74, 0x50},
		{677143, 0x74, 0x50},
		{683143, 0x73, 0x50},
		{689143, 0x73, 0x50},
		{695143, 0x73, 0x50},
		{701143, 0x73, 0x50},
		{707143, 0x72, 0x50},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x20},
		{725143, 0x71, 0x20},
		{731143, 0x70, 0x70},
		{737143, 0x70, 0x70},
		{743143, 0x70, 0x70},
		{749143, 0x6f, 0x70},
		{755143, 0x6f, 0x70},
		{761143, 0x6f, 0x70},
		{767143, 0x6f, 0x50}
	},
	{
		{93143, 0x6b, 0x30},
		{99143, 0x6b, 0x30},
		{105143, 0x6b, 0x30},
		{111143, 0x6b, 0x30},
		{117143, 0x6b, 0x30},
		{123143, 0x6b, 0x30},
		{129143, 0x6b, 0x30},
		{135143, 0x6b, 0x30},
		{141143, 0x6b, 0x30},
		{147143, 0x6b, 0x30},
		{153143, 0x6b, 0x30},
		{159143, 0x6b, 0x30},
		{167143, 0x6b, 0x30},
		{173143, 0x6b, 0x30},
		{179143, 0x6b, 0x30},
		{185143, 0x6b, 0x30},
		{191143, 0x6b, 0x30},
		{195143, 0x6b, 0x30},
		{201143, 0x6b, 0x30},
		{207143, 0x6b, 0x30},
		{213143, 0x6b, 0x30},
		{219143, 0x6b, 0x30},
		{225143, 0x6b, 0x30},
		{231143, 0x6b, 0x30},
		{237143, 0x6b, 0x30},
		{243143, 0x6b, 0x30},
		{249143, 0x6b, 0x30},
		{255143, 0x6b, 0x30},
		{261143, 0x6b, 0x30},
		{267143, 0x6b, 0x30},
		{273143, 0x6b, 0x30},
		{279143, 0x6b, 0x30},
		{285143, 0x70, 0x30},
		{291143, 0x70, 0x30},
		{297143, 0x70, 0x30},
		{303143, 0x70, 0x30},
		{309143, 0x70, 0x30},
		{315143, 0x70, 0x30},
		{321143, 0x70, 0x30},
		{327143, 0x70, 0x30},
		{333143, 0x70, 0x30},
		{339143, 0x70, 0x30},
		{345143, 0x70, 0x30},
		{351143, 0x70, 0x30},
		{357143, 0x70, 0x30},
		{363143, 0x70, 0x30},
		{369143, 0x70, 0x30},
		{375143, 0x70, 0x30},
		{381143, 0x70, 0x30},
		{387143, 0x70, 0x30},
		{393143, 0x70, 0x30},
		{399143, 0x70, 0x30},
		{405143, 0x70, 0x30},
		{411143, 0x70, 0x30},
		{417143, 0x70, 0x30},
		{423143, 0x70, 0x30},
		{429143, 0x70, 0x30},
		{435143, 0x70, 0x30},
		{441143, 0x70, 0x30},
		{447143, 0x70, 0x30},
		{453143, 0x70, 0x30},
		{459143, 0x70, 0x30},
		{465143, 0x70, 0x30},
		{473143, 0x70, 0x40},
		{479143, 0x70, 0x40},
		{485143, 0x70, 0x40},
		{491143, 0x70, 0x40},
		{497143, 0x70, 0x40},
		{503143, 0x6f, 0x40},
		{509143, 0x6f, 0x30},
		{515143, 0x6f, 0x30},
		{521143, 0x6f, 0x00},
		{527143, 0x6f, 0x00},
		{533143, 0x6f, 0x30},
		{539143, 0x6f, 0x30},
		{545143, 0x6f, 0x30},
		{551143, 0x6f, 0x30},
		{557143, 0x6f, 0x10},
		{563143, 0x70, 0x30},
		{569143, 0x70, 0x30},
		{575143, 0x70, 0x30},
		{581143, 0x70, 0x30},
		{587143, 0x71, 0x30},
		{593143, 0x72, 0x30},
		{599143, 0x72, 0x00},
		{605143, 0x72, 0x30},
		{611143, 0x73, 0x30},
		{617143, 0x73, 0x20},
		{623143, 0x74, 0x20},
		{629143, 0x74, 0x20},
		{635143, 0x73, 0x10},
		{641143, 0x74, 0x00},
		{647143, 0x74, 0x20},
		{653143, 0x74, 0x20},
		{659143, 0x73, 0x20},
		{665143, 0x74, 0x20},
		{671143, 0x74, 0x30},
		{677143, 0x74, 0x20},
		{683143, 0x73, 0x20},
		{689143, 0x73, 0x20},
		{695143, 0x73, 0x20},
		{701143, 0x73, 0x20},
		{707143, 0x72, 0x50},
		{713143, 0x71, 0x20},
		{719143, 0x71, 0x10},
		{725143, 0x71, 0x10},
		{731143, 0x70, 0x20},
		{737143, 0x70, 0x40},
		{743143, 0x70, 0x20},
		{749143, 0x6f, 0x10},
		{755143, 0x6f, 0x40},
		{761143, 0x6f, 0x40},
		{767143, 0x6f, 0x40}
	}
};

