/*
 * Copyright (C) 2011 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*

                Motion-JPEG SW decoder for stagefright plugin

GENERAL DESCRIPTION
  This module provides Motion-JPEG video decoder for stagefright plugin.


Copyright(c) 2014 by LG Electronics. All Rights Reserved.
*====*====*====*====*====*====*====*====*====*====*====*====*====*====*====*/

/*===========================================================================

                      EDIT HISTORY FOR FILE

  This section contains comments describing changes made to this file.
  Notice that changes are listed in reverse chronological order.

when         who         what, where, why
--------     -------    -------------------------------------------------------
12/31/2014   KHLEE      Added LGE Copyright & Updated NOTICE file
xx/xx/2013   KHLee      Created file

============================================================================*/

#ifndef SOFT_MJPG_H_

#define SOFT_MJPG_H_

#include <utils/threads.h>
#include "SimpleSoftOMXComponent.h"

extern "C" {
    #include "jpeglib.h"
    #include "jerror.h"
}

namespace android {

struct codec_jpeg_error_mgr {
    struct jpeg_error_mgr jerr;
    jmp_buf longjmp_buffer;
};

struct SoftMJPG : public SimpleSoftOMXComponent {
    SoftMJPG(const char *name,
            const OMX_CALLBACKTYPE *callbacks,
            OMX_PTR appData,
            OMX_COMPONENTTYPE **component);

protected:
    virtual ~SoftMJPG();

    virtual OMX_ERRORTYPE internalGetParameter(
            OMX_INDEXTYPE index, OMX_PTR params);

    virtual OMX_ERRORTYPE internalSetParameter(
            OMX_INDEXTYPE index, const OMX_PTR params);
    virtual OMX_ERRORTYPE getExtensionIndex(const char *name, OMX_INDEXTYPE *index);

    virtual void onQueueFilled(OMX_U32 portIndex);
    virtual void onPortFlushCompleted(OMX_U32 portIndex);
    virtual void onPortEnableCompleted(OMX_U32 portIndex, bool enabled);

private:
    enum {
        kInputPortIndex   = 0,
        kOutputPortIndex  = 1,
        kNumInputBuffers  = 4,
        kNumOutputBuffers = 4,
    };

    bool mSignalledError;

    bool mIsDownScale;
    bool mIsSpecOut;
    int32_t mFrameRate;

    int32_t mSkipRate;
    uint32_t mWidth, mHeight;
    uint32_t mCropLeft, mCropTop;
    uint32_t mCropWidth, mCropHeight;

    Mutex mLockProcess;
    Mutex mLockThread;
    Condition mCondition;
    Condition mConditionThread;

    enum {
        NONE,
        AWAITING_DISABLED,
        AWAITING_ENABLED
    } mOutputPortSettingsChange;

    enum {
        OMX_IndexParamMJPEGGetAndroidNativeBufferUsage = 0x07FFF000,
        OMX_IndexParamMJPEGStoreMetaDataInBuffers,
        OMX_IndexParamMJPEGEnableAndroidNativeBuffers,
        OMX_IndexParamMJPEGUseAndroidNativeBuffer2
    };

    uint8_t* inBuffInfoBackup;
    uint8_t* outBuffInfoBackup;
    uint8_t* inBuffInfoBackupThread;
    uint8_t* outBuffInfoBackupThread;

    struct codec_jpeg_error_mgr c_err;
    struct jpeg_decompress_struct cinfo;
    struct jpeg_decompress_struct dinfo;

    bool mThreadKill;
    bool mThreadWork;
    bool mThreadDecoding;
    bool mIsThreadCreated;
    bool mIsEOSSignaled;

    static int threadStrat(void* self);
    void threadWork();
    void threadKill();
    void onJPEGDecodingProcess();
    void onJPEGDecodingThread();
    void initPorts();
    void initHandle();
    void updatePortDefinitions();
    bool isValidFrame(uint8_t *src, uint32_t length);
    void NeonConvertor(uint8_t * __restrict dest1, uint8_t * __restrict dest2, uint8_t * __restrict dest3, uint8_t * __restrict src1, uint8_t * __restrict src2, uint32_t n);
    DISALLOW_EVIL_CONSTRUCTORS(SoftMJPG);
};

}  // namespace android

#endif  // SOFT_MJPG_H_
