#ifndef _AAT_KEYPRESS_
#define _AAT_KEYPRESS_
#include "minios_string_list.h"
#include <AatCommon.h>

void change_KeyButton_Color();
void init_ButtonWigets();

#define _KEY_W_    (SCREEN_WIDTH*18/100)
#define _KEY_H_    (_KEY_W_*40/100)
#define _KEY_Y_  (SCREEN_HEIGHT-_KEY_H_)

typedef enum {
#if HAS_KEY_OPTIONAL
    LIST_KEY_OPTIONAL_0,
    LIST_KEY_OPTIONAL_1,
#endif
#if HAS_KEY_VOLUME
    LIST_KEY_UP_1,
    LIST_KEY_UP_2,
    LIST_KEY_DOWN_1_0,
    LIST_KEY_DOWN_1_1,
    LIST_KEY_DOWN_2_0,
    LIST_KEY_DOWN_2_1,
#endif
    LIST_KEY_END,
#if TYPE_KEY_SOFTKEY
   LIST_KEY_HOME,
#else
    LIST_KEY_BACK,
    LIST_KEY_HOME,
    LIST_KEY_MENU,
    LIST_KEY_FOURTH,
#endif
#if HAS_HEADSET
    LIST_KEY_HOOK,
#endif
    LIST_KEY_MAX,
} ui_enum_type;


#if (PERFORM_INVERSE_KEY_UI == 0)
static SKIA_UiList_t ui_text_box_key_enum_t[LIST_KEY_MAX] = {
#if (HAS_KEY_OPTIONAL==1)
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,SCREEN_HEIGHT*10/100+10,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,(SCREEN_HEIGHT*10/100)+_KEY_H_+20,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#elif (HAS_KEY_OPTIONAL==2)  // for hot key - located below volume up/down key
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,SCREEN_HEIGHT*15/100+(3*_KEY_W_)+30,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,SCREEN_HEIGHT*15/100+(3*_KEY_W_)+40+_KEY_H_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#endif
#if HAS_KEY_VOLUME
    {1, {ST_UP_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,SCREEN_HEIGHT*15/100+_KEY_W_,_KEY_H_,_KEY_W_,_TDA_COLOR_WHITE}},
    {1, {ST_UP_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {_KEY_H_+10,SCREEN_HEIGHT*15/100+_KEY_W_,_KEY_H_,_KEY_W_,_TDA_COLOR_WHITE}},

    {1, {ST_DOWN_KEY_0,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10,_KEY_H_,(_KEY_W_/2) + (_KEY_H_ * 10/100),_TDA_COLOR_WHITE}},
    {1, {ST_DOWN_KEY_1,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,(SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10) + (_KEY_W_/2),_KEY_H_,(_KEY_W_/2),_TDA_COLOR_WHITE}},
    {1, {ST_DOWN_KEY_0,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {_KEY_H_+10,SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10,_KEY_H_,(_KEY_W_/2) + (_KEY_H_ * 10/100),_TDA_COLOR_WHITE}},
    {1, {ST_DOWN_KEY_1,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {_KEY_H_+10,(SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10) + (_KEY_W_/2),_KEY_H_,(_KEY_W_/2),_TDA_COLOR_WHITE}},
#endif
#if TYPE_DISPLAY_CIRCLE
    {1, {ST_END_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_ - 15,0,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#else
    {1, {ST_END_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_,0,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#endif
#if TYPE_KEY_SOFTKEY
    {1, {ST_HOME_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#else
    {1, {ST_BACK_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_HOME_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_MENU_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_DUAL_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#endif
};

#else
static SKIA_UiList_t ui_text_box_key_enum_t[LIST_KEY_MAX] = {
#if (HAS_KEY_OPTIONAL==1)
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_,SCREEN_HEIGHT*10/100+10,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_,(SCREEN_HEIGHT*10/100)+_KEY_H_+20,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#elif (HAS_KEY_OPTIONAL==2)  // for hot key - located below volume up/down key
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_,SCREEN_HEIGHT*15/100+(3*_KEY_W_)+30,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_ETC_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_,SCREEN_HEIGHT*15/100+(3*_KEY_W_)+40+_KEY_H_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#endif
#if HAS_KEY_VOLUME
    {1, {ST_UP_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH - _KEY_H_ , SCREEN_HEIGHT*15/100+_KEY_W_,_KEY_H_,_KEY_W_,_TDA_COLOR_WHITE}},
    {1, {ST_UP_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH- (2.1*_KEY_H_), SCREEN_HEIGHT*15/100+_KEY_W_,_KEY_H_,_KEY_W_,_TDA_COLOR_WHITE}},

    {1, {ST_DOWN_KEY_0,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH - _KEY_H_,SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10,_KEY_H_,(_KEY_W_/2) + (_KEY_H_ * 10/100),_TDA_COLOR_WHITE}},
    {1, {ST_DOWN_KEY_1,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH - _KEY_H_,(SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10) + (_KEY_W_/2),_KEY_H_,(_KEY_W_/2),_TDA_COLOR_WHITE}},
    {1, {ST_DOWN_KEY_0,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH- (2.1*_KEY_H_),SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10,_KEY_H_,(_KEY_W_/2) + (_KEY_H_ * 10/100),_TDA_COLOR_WHITE}},
    {1, {ST_DOWN_KEY_1,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH- (2.1*_KEY_H_),(SCREEN_HEIGHT*15/100+_KEY_W_+_KEY_W_+10) + (_KEY_W_/2),_KEY_H_,(_KEY_W_/2),_TDA_COLOR_WHITE}},
#endif
    {1, {ST_END_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {SCREEN_WIDTH-_KEY_W_,0,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#if TYPE_KEY_SOFTKEY
    {1, {ST_HOME_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#else
    {1, {ST_BACK_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_HOME_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_MENU_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
    {1, {ST_DUAL_KEY,          0, _TDA_COLOR_BLACK,  SKIAW_CENTER, FSIZE_KEY_KP}, {0,_KEY_Y_,_KEY_W_,_KEY_H_,_TDA_COLOR_WHITE}},
#endif
};

#endif

#endif
