/*
 * Copyright(c) 2015 by LG Electronics. Confidential and Proprietary
 * All Rights Reserved.
 */

#include "../../../allautotest_skia/include/AatCommon.h"
#include "../../../allautotest_skia/SelfDiagnosis/include/SelfDiagnosis.h"
#if PERFORM_H2_PRJ
#include "SelfDExt.h"
#endif

#if PERFORM_AIO
#include "T_Common.h"
#endif

typedef struct
{
  char pid[LGFTM_PID_SIZE];
  char selfd_result[SELFD_MISC_SIZE + 1];
} QRCODE_SELFD_RESULT;

typedef struct
{
  char pid[LGFTM_PID_SIZE];
  char aat_qr_result[256/*LGFTM_SELFD_E_RESULT_SIZE*/];
} QRCODE_AAT_QR_RESULT;

#if (IS_TABLET || IS_WATCH_PHONE)
typedef struct
{
  char aat_result[NUM_LIST_MAX];
} QRCODE_AAT;
#endif

typedef struct string_table{
    int  index;
    char string[4];
};

#if PERFORM_AIO
typedef struct string_table_taio{
    int  index;
    char string[4];
};
#endif

typedef struct
{
  char pid[LGFTM_PID_SIZE];
  char taio_qr_result[256/*LGFTM_TAIO_RESULT_SIZE*/];
  char ws_result[128];
} QRCODE_TAIO_QR_RESULT;

static struct string_table mAatQrResult[NUM_AAT_QR_RESULT_MAX]={
    {NUM_AAT_QR_RESULT_SIM1, "SM6"},
    {NUM_AAT_QR_RESULT_SIM2, "SM7"},
    {NUM_AAT_QR_RESULT_SIM3, "SM8"},
    {NUM_AAT_QR_RESULT_SIM4, "SM9"},
    {NUM_AAT_QR_RESULT_SIM5, "SMA"},
    {NUM_AAT_QR_RESULT_SDCARD, "SD2"},
    {NUM_AAT_QR_RESULT_EARPHONEWRONG, "EP2"},
    {NUM_AAT_QR_RESULT_BAROMETER, "BM2"},
    {NUM_AAT_QR_RESULT_BATTERYTEMPERATURE, "TE2"},
    {NUM_AAT_QR_RESULT_HUMIDITY, "HU2"},
    {NUM_AAT_QR_RESULT_TAWRONG, "TA2"},
    {NUM_AAT_QR_RESULT_BATTERYLEVEL, "BA2"},
    {NUM_AAT_QR_RESULT_HALLICWRONG, "HA2"},
    {NUM_AAT_QR_RESULT_BATTERYID, "BI2"},
    {NUM_AAT_QR_RESULT_KEYPRESS, "KP2"},
    {NUM_AAT_QR_RESULT_PROXIMITY, "PR2"},
    {NUM_AAT_QR_RESULT_LIGHT, "LI2"},
    {NUM_AAT_QR_RESULT_CAP, "CP1"},
    {NUM_AAT_QR_RESULT_QWERTYKEY, "QK1"},
    {NUM_AAT_QR_RESULT_CAMERA1, "CA6"},
    {NUM_AAT_QR_RESULT_CAMERA2, "CA7"},
    {NUM_AAT_QR_RESULT_CAMERA3, "CA8"},
    {NUM_AAT_QR_RESULT_CAMERA4, "CA9"},
    {NUM_AAT_QR_RESULT_CAMERA5, "CAA"},
    {NUM_AAT_QR_RESULT_CAMCORDER, "CC1"},
    {NUM_AAT_QR_RESULT_VTCAMERA, "VT2"},
    {NUM_AAT_QR_RESULT_3DCAMERA, "TD1"},
    {NUM_AAT_QR_RESULT_LED, "LE1"},
    {NUM_AAT_QR_RESULT_LCD, "LC1"},
    {NUM_AAT_QR_RESULT_SPEAKER, "SP1"},
    {NUM_AAT_QR_RESULT_MIC1, "MI6"},
    {NUM_AAT_QR_RESULT_MIC2, "MI7"},
    {NUM_AAT_QR_RESULT_MIC3, "MI8"},
    {NUM_AAT_QR_RESULT_MIC4, "MI9"},
    {NUM_AAT_QR_RESULT_MIC5, "MIA"},
    {NUM_AAT_QR_RESULT_RECEIVER, "RC1"},
    {NUM_AAT_QR_RESULT_VIBRATOR1, "VI3"},
    {NUM_AAT_QR_RESULT_VIBRATOR2, "VI4"},
    {NUM_AAT_QR_RESULT_IRRC, "IR1"},
    {NUM_AAT_QR_RESULT_IRDA, "ID1"},
    {NUM_AAT_QR_RESULT_TOUCH, "TO2"},
    {NUM_AAT_QR_RESULT_MAGNETIC, "MA2"},
    {NUM_AAT_QR_RESULT_ACCEL, "AC2"},
    {NUM_AAT_QR_RESULT_GYRO, "GY1"},
    {NUM_AAT_QR_RESULT_GPS, "GP3"},
    {NUM_AAT_QR_RESULT_GNSS, "GN1"},
    {NUM_AAT_QR_RESULT_BT, "BT2"},
    {NUM_AAT_QR_RESULT_WIFI, "WI2"},
    {NUM_AAT_QR_RESULT_BD, "BD1"},
    {NUM_AAT_QR_RESULT_EU, "EU1"},
    {NUM_AAT_QR_RESULT_DMB, "DM1"},
    {NUM_AAT_QR_RESULT_HDMI, "HD1"},
    {NUM_AAT_QR_RESULT_SLIDEONOFF, "SL1"},
    {NUM_AAT_QR_RESULT_NFCREADER, "NR1"},
    {NUM_AAT_QR_RESULT_NFCSWP, "NS1"},
    {NUM_AAT_QR_RESULT_FELICA, "FE2"},
    {NUM_AAT_QR_RESULT_WIRELESSCHARGING, "WC2"},
    {NUM_AAT_QR_RESULT_BATTERYCOVER, "BC1"},
    {NUM_AAT_QR_RESULT_CHARGING, "CH1"},
    {NUM_AAT_QR_RESULT_FMR, "FM1"},
    {NUM_AAT_QR_RESULT_LOOPBACK, "LB1"},
    {NUM_AAT_QR_RESULT_3DLCD, "TL1"},
    {NUM_AAT_QR_RESULT_CAMERAOIS, "OI2"},
    {NUM_AAT_QR_RESULT_EARMP3, "EM1"},
    {NUM_AAT_QR_RESULT_PPG, "PP1"},
    {NUM_AAT_QR_RESULT_OTG, "OT2"},
    {NUM_AAT_QR_RESULT_ANTENNA1, "DCR"},
    {NUM_AAT_QR_RESULT_ANTENNA2, "DCV"},
    {NUM_AAT_QR_RESULT_ANTENNA3, "R01"},
    {NUM_AAT_QR_RESULT_ANTENNA4, "R02"},
    {NUM_AAT_QR_RESULT_ANTENNA5, "R03"},
    {NUM_AAT_QR_RESULT_ANTENNA6, "R04"},
    {NUM_AAT_QR_RESULT_ANTENNA7, "R05"},
    {NUM_AAT_QR_RESULT_ANTENNA8, "R06"},
    {NUM_AAT_QR_RESULT_ANTENNA9, "R07"},
    {NUM_AAT_QR_RESULT_ANTENNA10, "R08"},
    {NUM_AAT_QR_RESULT_ANTENNA11, "DCC"},
    {NUM_AAT_QR_RESULT_ANTENNA12, "DCT"},
    {NUM_AAT_QR_RESULT_ANTENNA13, "V01"},
    {NUM_AAT_QR_RESULT_ANTENNA14, "V02"},
    {NUM_AAT_QR_RESULT_ANTENNA15, "V03"},
    {NUM_AAT_QR_RESULT_ANTENNA16, "V04"},
    {NUM_AAT_QR_RESULT_ANTENNA17, "V05"},
    {NUM_AAT_QR_RESULT_ANTENNA18, "V06"},
    {NUM_AAT_QR_RESULT_ANTENNA19, "V07"},
    {NUM_AAT_QR_RESULT_ANTENNA20, "V08"},
    {NUM_AAT_QR_RESULT_ANTENNA21, "V09"},
    {NUM_AAT_QR_RESULT_ANTENNA22, "V10"},
    {NUM_AAT_QR_RESULT_ANTENNA23, "V11"},
    {NUM_AAT_QR_RESULT_ANTENNA24, "V12"},
    {NUM_AAT_QR_RESULT_ANTENNA25, "V13"},
    {NUM_AAT_QR_RESULT_ANTENNA26, "V14"},
    {NUM_AAT_QR_RESULT_ANTENNA27, "V15"},
    {NUM_AAT_QR_RESULT_ANTENNA28, "V16"},
    {NUM_AAT_QR_RESULT_ANTENNA29, "RE1"},
    {NUM_AAT_QR_RESULT_ANTENNA30, "RE2"},
    {NUM_AAT_QR_RESULT_ANTENNA31, "RE3"},
    {NUM_AAT_QR_RESULT_ANTENNA32, "RE4"},
    {NUM_AAT_QR_RESULT_ANTENNA33, "RE5"},
    {NUM_AAT_QR_RESULT_ANTENNA34, "RE6"},
    {NUM_AAT_QR_RESULT_ANTENNA35, "RE7"},
    {NUM_AAT_QR_RESULT_ANTENNA36, "RE8"},
    {NUM_AAT_QR_RESULT_ANTENNA37, "X01"},
    {NUM_AAT_QR_RESULT_ANTENNA38, "X02"},
    {NUM_AAT_QR_RESULT_ANTENNA39, "X03"},
    {NUM_AAT_QR_RESULT_ANTENNA40, "X04"},
    {NUM_AAT_QR_RESULT_ANTENNA41, "X05"},
    {NUM_AAT_QR_RESULT_ANTENNA42, "X06"},
    {NUM_AAT_QR_RESULT_ANTENNA43, "X07"},
    {NUM_AAT_QR_RESULT_ANTENNA44, "X08"},
    {NUM_AAT_QR_RESULT_ANTENNA45, "X09"},
    {NUM_AAT_QR_RESULT_ANTENNA46, "X10"},
    {NUM_AAT_QR_RESULT_ANTENNA47, "X11"},
    {NUM_AAT_QR_RESULT_ANTENNA48, "X12"},
    {NUM_AAT_QR_RESULT_ANTENNA49, "X13"},
    {NUM_AAT_QR_RESULT_ANTENNA50, "X14"},
    {NUM_AAT_QR_RESULT_PENDETECT, "PE2"}
};

static struct string_table mSelfdResult[NUM_SELFD_PROPERTY_MAX]={
    {NUM_SELFD_PROPERTY_1, "SM1"},
    {NUM_SELFD_PROPERTY_2, "SM2"},
    {NUM_SELFD_PROPERTY_3, "SM3"},
    {NUM_SELFD_PROPERTY_4, "SD1"},
    {NUM_SELFD_PROPERTY_5, "EP1"},
    {NUM_SELFD_PROPERTY_6, "BM1"},
    {NUM_SELFD_PROPERTY_7, "TE1"},
    {NUM_SELFD_PROPERTY_8, "HU1"},
    {NUM_SELFD_PROPERTY_9, "TA1"},
    {NUM_SELFD_PROPERTY_10, "BA1"},
    {NUM_SELFD_PROPERTY_11, "OT1"},
    {NUM_SELFD_PROPERTY_12, "HA1"},
    {NUM_SELFD_PROPERTY_13, "BI1"},
    {NUM_SELFD_PROPERTY_14, "GP1"},
    {NUM_SELFD_PROPERTY_15, "BT1"},
    {NUM_SELFD_PROPERTY_16, "WI1"},
    {NUM_SELFD_PROPERTY_17, "PR1"},
    {NUM_SELFD_PROPERTY_18, "LI1"},
    {NUM_SELFD_PROPERTY_19, "MA1"},
    {NUM_SELFD_PROPERTY_20, "NF1"},
    {NUM_SELFD_PROPERTY_21, "SW1"},
    {NUM_SELFD_PROPERTY_22, "FE1"},
    {NUM_SELFD_PROPERTY_23, "WC1"},
    {NUM_SELFD_PROPERTY_24, "CA1"},
    {NUM_SELFD_PROPERTY_25, "VT1"},
    {NUM_SELFD_PROPERTY_26, "AC1"},
    {NUM_SELFD_PROPERTY_27, "MI1"},
    {NUM_SELFD_PROPERTY_28, "OI1"},
    {NUM_SELFD_PROPERTY_29, "VI1"},
    {NUM_SELFD_PROPERTY_30, "TO1"},
    {NUM_SELFD_PROPERTY_31, "MI2"},
    {NUM_SELFD_PROPERTY_32, "MI3"},
    {NUM_SELFD_PROPERTY_33, "MI4"},
    {NUM_SELFD_PROPERTY_34, "MI5"},
    {NUM_SELFD_PROPERTY_35, "PP2"}, //ppg
    {NUM_SELFD_PROPERTY_36, "PE1"}, //pen
    {NUM_SELFD_PROPERTY_37, "VT3"}, //vt wide
    {NUM_SELFD_PROPERTY_38, "CA2"}, //main wide
    {NUM_SELFD_PROPERTY_39, "FI1"}  //finger print
};

#if PERFORM_AIO
static struct string_table_taio mTaioQrResult[NUM_LIST_TAIO_MAX]={
    {NUM_LIST_TAIO_CAP_SENSOR,"CP1"},
    {NUM_LIST_TAIO_KEY,"KP2"},
    {NUM_LIST_TAIO_LIGHT, "LI2"},
    {NUM_LIST_TAIO_IRRC,"IR1"},
    {NUM_LIST_TAIO_OTG,"OT2"},
    {NUM_LIST_TAIO_NFC,"NR1"},
    {NUM_LIST_TAIO_CAMERA,"CA6"},
    {NUM_LIST_TAIO_CAMERAVT,"VT2"},
    {NUM_LIST_TAIO_DISPLAY_VISION,"LC2"},
    {NUM_LIST_TAIO_AUDIO_MIC,"MI6"},  //    {NUM_LIST_TAIO_AUDIO_LOOPBACK,"LB1"},
    {NUM_LIST_TAIO_AUDIO_SPK,"SP1"},  //    {NUM_LIST_TAIO_AUDIO_RING,"SP1"},
    {NUM_LIST_TAIO_AUDIO_MP3,"EM1"},
    {NUM_LIST_TAIO_MAGNETIC,"MA2"},
    {NUM_LIST_TAIO_ACCEL,"AC2"},
    {NUM_LIST_TAIO_GYRO,"GY1"},
    {NUM_LIST_TAIO_VIBRATOR,"VI3"},
    {NUM_LIST_TAIO_GPS,"GP3"},
    {NUM_LIST_TAIO_HDMI,"HD1"},
    {NUM_LIST_TAIO_DISPLAY_MANUAL,"LC1"},
    {NUM_LIST_TAIO_TOUCHDRAW, "TO2"},
    {NUM_LIST_TAIO_WIFI, "WI2"},
    {NUM_LIST_TAIO_WS, "DCT"}
///  QR
};
#endif
