
//#include "StdAfx.h"
#include "../inc/INC_INCLUDES.h"

extern PLL_MODE			m_ucPLL_Mode;

INC_UINT32 g_uiKOREnsembleFullFreq[MAX_KOREABAND_FULL_CHANNEL] = 
{
	175280,177008,178736,
	181280,183008,184736,
	187280,189008,190736,
	193280,195008,196736,
	199280,201008,202736,
	205280,207008,208736,
	211280,213008,214736
};

static INC_UINT32 g_uiKOREnsembleNormalFreq[MAX_KOREABAND_NORMAL_CHANNEL] = 
{
	181280,183008,184736,
	205280,207008,208736
};


static INC_UINT8 g_acT3900KorI2CValue_19200[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//19200KHz 7AK.dat (175.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x41, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7BK.dat (177.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x44, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 7CK.dat (178.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x47, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8AK.dat (181.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x12, 0x4B, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8BK.dat (183.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x1C, 0x45, 
		0x4D, 0x0D, 0x9A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 8CK.dat (184.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x41, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9AK.dat (187.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x45, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9BK.dat (189.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x48, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 9CK.dat (190.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x4B, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10AK.dat (193.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x13, 0x4F, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10BK.dat (195.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x42, 
		0x4D, 0x09, 0x12, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 10CK.dat (196.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x45, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11AK.dat (199.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x49, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11BK.dat (201.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x1F, 0x42, 
		0x4D, 0x0D, 0x9A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 11CK.dat (202.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x14, 0x4F, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12AK.dat (205.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x43, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12BK.dat (207.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x2A, 0x4C, 
		0x4D, 0x12, 0x22, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 12CK.dat (208.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x49, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13AK.dat (211.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x15, 0x4D, 
		0x4D, 0x0C, 0xE8, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13BK.dat (213.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x16, 0x40, 
		0x4D, 0x09, 0x11, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//19200KHz 13CK.dat (214.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x5A, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x16, 0x43, 
		0x4D, 0x05, 0x3A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},
};


static INC_UINT8 g_acT3900KorI2CValue_24576[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//24576KHz 7AK.dat (175.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x04, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7BK.dat (177.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x10, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 7CK.dat (178.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x1C, 0x9F, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8AK.dat (181.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x4E, 
		0x4D, 0x1B, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8BK.dat (183.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x42, 
		0x4D, 0x07, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 8CK.dat (184.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x45, 
		0x4D, 0x13, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9AK.dat (187.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x4A, 
		0x4D, 0x12, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9BK.dat (189.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x0F, 0x43, 
		0x4D, 0x1F, 0x15, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 9CK.dat (190.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x41, 
		0x4D, 0x0A, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10AK.dat (193.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x46, 
		0x4D, 0x09, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10BK.dat (195.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x49, 
		0x4D, 0x15, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 10CK.dat (196.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1F, 0x4C, 
		0x4D, 0x02, 0x2A, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11AK.dat (199.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x42, 
		0x4D, 0x00, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11BK.dat (201.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x45, 
		0x4D, 0x0C, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 11CK.dat (202.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x18, 0x48, 
		0x4D, 0x18, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12AK.dat (205.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x10, 0x49, 
		0x4D, 0x05, 0x15, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12BK.dat (207.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x41, 
		0x4D, 0x03, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 12CK.dat (208.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x44, 
		0x4D, 0x0F, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13AK.dat (211.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x19, 0x49, 
		0x4D, 0x0E, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13BK.dat (213.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x02, 0x00, 0x11, 0x43, 
		0x4D, 0x07, 0x15, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//24576KHz 13CK.dat (214.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x73, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x1A, 0x40, 
		0x4D, 0x06, 0xA0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},


};

static INC_UINT8 g_acT3900KorI2CValue_27000[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{	//27000KHz 7AK.dat (175.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x13, 0x43, 
		0x4D, 0x0A, 0x97, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7BK.dat (177.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x13, 0x46, 
		0x4D, 0x0C, 0x75, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 7CK.dat (178.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x13, 0x49, 
		0x4D, 0x0E, 0x54, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8AK.dat (181.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1A, 0x47, 
		0x4D, 0x1D, 0xE2, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8BK.dat (183.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x41, 
		0x4D, 0x00, 0x48, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 8CK.dat (184.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x44, 
		0x4D, 0x02, 0x26, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9AK.dat (187.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x48, 
		0x4D, 0x12, 0x3C, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9BK.dat (189.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x4B, 
		0x4D, 0x14, 0x1B, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 9CK.dat (190.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x4E, 
		0x4D, 0x15, 0xF9, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10AK.dat (193.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x06, 0x0F, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10BK.dat (195.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x07, 0xEE, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 10CK.dat (196.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x09, 0xCC, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11AK.dat (199.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1D, 0x42, 
		0x4D, 0x0D, 0x2D, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11BK.dat (201.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x40, 
		0x4D, 0x1B, 0xC0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 11CK.dat (202.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x43, 
		0x4D, 0x1D, 0x9F, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12AK.dat (205.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x48, 
		0x4D, 0x0D, 0xB4, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12BK.dat (207.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1E, 0x44, 
		0x4D, 0x14, 0xC4, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 12CK.dat (208.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x4E, 
		0x4D, 0x11, 0x71, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13AK.dat (211.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x43, 
		0x4D, 0x01, 0x87, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13BK.dat (213.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x46, 
		0x4D, 0x03, 0x65, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{	//27000KHz 13CK.dat (214.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x49, 
		0x4D, 0x05, 0x44, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xE0, 0x00, 0x10, 0x00, 
		0x0F, 0x0C, 0x00, 0xF3, 0x00, 0x00, 0x80, 0x00, 0x78, 0x00, 0x07, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0xF8, 0x00, 0x04, 0x00, 0x02, 0x00, 0x01, 0x00, 0x00, 0xF0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x80, 0x10, 0xC0, 0x10, 0x00, 0x08, 0x1C, 0xC0, 0x22, 0x96, 0xA5, 0xE0, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},


};


static INC_UINT8 g_acT3900KorI2CValue_27120[MAX_KOREABAND_FULL_CHANNEL][RF500_REG_CTRL] = 
{
	{ //27120KHz 7AK.dat (175.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x13, 0x43, 
		0x4D, 0x0A, 0x97, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 7BK.dat (177.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x13, 0x46, 
		0x4D, 0x0C, 0x75, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x70, 0x70, 0x80, 0x10, 0x00, 
		0xEE, 0xE0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xFF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 7CK.dat (178.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x13, 0x49, 
		0x4D, 0x0E, 0x54, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x80, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 8AK.dat (181.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1A, 0x47, 
		0x4D, 0x1D, 0xE2, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xCC, 0xC0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 8BK.dat (183.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x41, 
		0x4D, 0x00, 0x48, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xBB, 0xB0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 8CK.dat (184.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x44, 
		0x4D, 0x02, 0x26, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 9AK.dat (187.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x48, 
		0x4D, 0x12, 0x3C, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x60, 0x60, 0x80, 0x10, 0x00, 
		0xAA, 0xA0, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 9BK.dat (189.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x4B, 
		0x4D, 0x14, 0x1B, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 9CK.dat (190.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x14, 0x4E, 
		0x4D, 0x15, 0xF9, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 10AK.dat (193.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x43, 
		0x4D, 0x06, 0x0F, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x50, 0x50, 0x80, 0x10, 0x00, 
		0x99, 0x90, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 10BK.dat (195.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x46, 
		0x4D, 0x07, 0xEE, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 10CK.dat (196.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x15, 0x49, 
		0x4D, 0x09, 0xCC, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xFF, 0xC0, 0x50, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 11AK.dat (199.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1D, 0x42, 
		0x4D, 0x0D, 0x2D, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x88, 0x80, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 11BK.dat (201.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x40, 
		0x4D, 0x1B, 0xC0, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x77, 0x70, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 11CK.dat (202.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x43, 
		0x4D, 0x1D, 0x9F, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 12AK.dat (205.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x48, 
		0x4D, 0x0D, 0xB4, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x40, 0x40, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 12BK.dat (207.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x04, 0x00, 0x1E, 0x44, 
		0x4D, 0x14, 0xC4, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 12CK.dat (208.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x16, 0x4E, 
		0x4D, 0x11, 0x71, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 13AK.dat (211.280Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x4C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x43, 
		0x4D, 0x01, 0x87, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 13BK.dat (213.008Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x46, 
		0x4D, 0x03, 0x65, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},

	{ //27120KHz 13CK.dat (214.736Mhz)
		0x55, 0x9F, 0xF1, 0xF8, 0x02, 0x41, 0xFC, 0x00, 0x00, 0xC0, 0x00, 0x0C, 0xC3, 0x00, 0xC0, 0x40, 
		0x7F, 0x80, 0x03, 0xE8, 0x0C, 0xC0, 0x88, 0x33, 0x08, 0xF0, 0xF0, 0xD0, 0x03, 0x00, 0x17, 0x49, 
		0x4D, 0x05, 0x44, 0x03, 0xE8, 0xC1, 0x88, 0x08, 0xE0, 0x10, 0x40, 0xFC, 0x00, 0x00, 0x00, 0x00, 
		0x0F, 0x01, 0x00, 0x70, 0x4C, 0xF0, 0x8C, 0xF0, 0x80, 0xC0, 0xC0, 0x20, 0x20, 0x80, 0x10, 0x00, 
		0x66, 0x60, 0x33, 0x44, 0x48, 0x33, 0x6E, 0x68, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x0B, 0x2B, 
		0x00, 0x80, 0x60, 0x00, 0x00, 0x00, 0x94, 0x44, 0x00, 0x15, 0x0F, 0x18, 0x18, 0x0E, 0x04, 0x00, 
		0x00, 0x00, 0xFB, 0xB0, 0x68, 0x20, 0x00, 0x08, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xC0, 0x00, 0x20, 0x00, 
		0x10, 0x54, 0x0F, 0xAB, 0x00, 0x00, 0xF8, 0x00, 0x04, 0x00, 0x03, 0x80, 0x00, 0x60, 0x00, 0x00, 
		0x80, 0x00, 0x78, 0x00, 0x06, 0x00, 0x01, 0x00, 0x00, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 
		0x80, 0x00, 0xF8, 0x18, 0x07, 0x80, 0x04, 0x00, 0xF8, 0xFE, 0xFE, 0x00, 0xF0, 0xBF, 0xC0, 0x80, 
		0x03, 0x00, 0x05, 0xDC, 0x00, 0x05, 0xDC, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
		0x01, 0x01, 0x00, 0xE0, 0x00, 0x00, 0x00, 0x00, 
	},
};



INC_UINT32 INC_GET_KOREABAND_FULL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_FULL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleFullFreq[uiIndex];
}

INC_UINT32 INC_GET_KOREABAND_NORMAL_TABLE(INC_UINT16 uiIndex)
{
	if(uiIndex >= MAX_KOREABAND_NORMAL_CHANNEL) return 0xFFFF;
	return g_uiKOREnsembleNormalFreq[uiIndex];
}

INC_UINT16 INC_FIND_KOR_FREQ(INC_UINT32 ulFreq)
{
	INC_UINT16 uiLoop;
	for(uiLoop = 0 ; uiLoop < MAX_KOREABAND_FULL_CHANNEL; uiLoop++){
		if(g_uiKOREnsembleFullFreq[uiLoop] == ulFreq)
			return uiLoop;
	}
	return 0xFFFF;
}

INC_UINT8 INC_RF500_I2C_WRITE(INC_UINT8 ucI2CID, INC_UINT8 *pucData, INC_UINT32 uLength)
{
	INC_INT16 nLoop;
	for(nLoop = 0 ;nLoop < (INC_INT16)uLength; nLoop++){
		INC_CMD_WRITE(ucI2CID, APB_RF_BASE+nLoop, (INC_UINT16)pucData[nLoop]);
	}
	return INC_SUCCESS;
}

INC_UINT8 INC_RF500_START(INC_UINT8 ucI2CID, INC_UINT32 ulRFChannel, ENSEMBLE_BAND ucBand)
{
	INC_UINT16 uiPos;
	INC_UINT8* pDataBuff = INC_NULL;

	if(ucBand == KOREA_BAND_ENABLE){
		uiPos = INC_FIND_KOR_FREQ(ulRFChannel);
		if(uiPos == 0xFFFF) return INC_ERROR;

		switch(m_ucPLL_Mode){
		case INPUT_CLOCK_19200KHZ : pDataBuff = g_acT3900KorI2CValue_19200[uiPos]; break;
		case INPUT_CLOCK_24576KHZ : pDataBuff = g_acT3900KorI2CValue_24576[uiPos]; break;
		case INPUT_CLOCK_27000KHZ : pDataBuff = g_acT3900KorI2CValue_27000[uiPos]; break;
		case INPUT_CLOCK_27120KHZ : pDataBuff = g_acT3900KorI2CValue_27120[uiPos]; break;
		default : pDataBuff = g_acT3900KorI2CValue_19200[uiPos]; break;
		}
	}
	else if(ucBand == EXTERNAL_ENABLE) 
		return INC_SUCCESS;
	else 
		return INC_ERROR;

	if(pDataBuff == INC_NULL) return INC_ERROR;
	if(INC_RF500_I2C_WRITE(ucI2CID, pDataBuff, RF500_REG_CTRL) == INC_ERROR)
		return INC_ERROR;

	return INC_SUCCESS;
}


