/****************************************************************************
 *   FileName    : tcc353x_dpll_38400osc.c
 *   Description : dpll table for 38400 osc
 ****************************************************************************
 *
 *   TCC Version 1.0
 *   Copyright (c) Telechips Inc.
 *   All rights reserved 
 
This source code contains confidential information of Telechips.
Any unauthorized use without a written permission of Telechips including not limited to re-
distribution in source or binary form is strictly prohibited.
This source code is provided "AS IS" and nothing contained in this source code shall 
constitute any express or implied warranty of any kind, including without limitation, any warranty 
of merchantability, fitness for a particular purpose or non-infringement of any patent, copyright 
or other third party intellectual property right. No warranty is made, express or implied, 
regarding the information's accuracy, completeness, or performance. 
In no event shall Telechips be liable for any claim, damages or other liability arising from, out of 
or in connection with this source code or the use in the source code. 
This source code is provided subject to the terms of a Mutual Non-Disclosure Agreement 
between Telechips and Company.
*
****************************************************************************/

#include "tcpal_os.h"
#include "tcpal_i2c.h"
#include "tcpal_spi.h"
#include "tcc353x_dpll_38400osc.h"
#include "tcc353x_defines.h"
#include "tcc353x_common.h"

I32U DpllTable_TSB_1SEG [_MAX_TSB_1SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */
	/* isdb-tsb 1-seg */
	91857,  PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	95285,  PLL_ISDB_TSB_1_SEG_408,	0x01, 0x0929ABB3, 0x0A, 
	99142,  PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	188143, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	188713, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	189143, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	189713, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	190143, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	190713, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	191143, PLL_ISDB_TSB_1_SEG_384,	0x27, 0x47C9D1F2, 0x08, 
	191573, PLL_ISDB_TSB_1_SEG_408,	0x01, 0x0929ABB3, 0x0A, 
	0, PLL_ISDB_TSB_1_SEG_384,	0x00, 0x00000000, 0x00
};

I32U DpllTable_TSB_3SEG [_MAX_TSB_3SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */
	/* isdb-tsb 3-seg */
	91857,  PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	95285,  PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	99142,  PLL_ISDB_TSB_3_SEG_464,	0x1F, 0xCEAD7815, 0x05, 
	188143, PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	188713, PLL_ISDB_TSB_3_SEG_456,	0x1B, 0xDFC6F7F1, 0x05, 
	189143, PLL_ISDB_TSB_3_SEG_456,	0x1B, 0xDFC6F7F1, 0x05, 
	189713, PLL_ISDB_TSB_3_SEG_456,	0x1B, 0xDFC6F7F1, 0x05, 
	190143, PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	190713, PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	191143, PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	191573, PLL_ISDB_TSB_3_SEG_432,	0x0F, 0x335205B8, 0x05, 
	0, PLL_ISDB_TSB_3_SEG_432,	0x00, 0x00000000, 0x00,
};

I32U DpllTable_TMM_1SEG [_MAX_TMM_1SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */
	/* Pattern-A */
	207857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	208286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	208714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	209143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	209571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,

	/* Pattern-B */
	213429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	213857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	214286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	214714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	215143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	215571, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	216000, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,

	/* Pattern-C */
	219000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	220286, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	220714, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	221143, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	221571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,

	0, PLL_ISDB_TMM_PARTIAL_1_SEG, 0x00, 0x00000000, 0x00
};

I32U DpllTable_TMM_13SEG [_MAX_TMM_13SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */
	/* Pattern A/B/C */
	210429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	213429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	216000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	219000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	0, PLL_ISDB_TMM_FULLSEG, 0x00, 0x00000000, 0x00
};

I32U DpllTable_TMM_USER_1SEG [_MAX_TMM_USER_1SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */
	207857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	208286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	208714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	209143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	209571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210857, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	211286, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	211714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	212143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	212571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	213000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	213429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	213857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	214286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	214714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	215143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	215571, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	216000, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	216429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	216857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	217286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	217714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	218143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	218571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	220286, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	220714, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	221143, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	221571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	0, PLL_ISDB_TMM_PARTIAL_1_SEG, 0x00, 0x00000000, 0x00
};

I32U DpllTable_TMM_USER_13SEG [_MAX_TMM_USER_13SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */
	207857, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	208286, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	208714, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	209143, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	209571, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	210000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	210429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	210857, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	211286, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	211714, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	212143, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	212571, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	213000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	213429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	213857, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	214286, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	214714, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	215143, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	215571, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	216000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	216429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	216857, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	217286, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	217714, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	218143, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	218571, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	219000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	219429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	219857, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	220286, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	220714, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	221143, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	221571, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	0, PLL_ISDB_TMM_FULLSEG, 0x00, 0x00000000, 0x00
};

I32U DpllTable_Partial1Seg [_MAX_PARTIAL_1SEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */

	/* isdb-tmm 1seg */
	207857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	208286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	208714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	209143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	209571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	210429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	213429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	213857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	214286, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	214714, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	215143, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	215571, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	216000, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	219000, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219429, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219857, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	220286, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	220714, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	221143, PLL_ISDB_TMM_PARTIAL_1_SEG_456, 0x1B, 0xDFC6F7F1, 0x0A,
	221571, PLL_ISDB_TMM_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	/* ISDB-T 1-seg, VHF japan only */
	93143,  PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	99143,  PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	105143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	173143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	179143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	185143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	191143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	/* ISDB-T 1-seg, VHF brazil only */
	57143,	PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A, 
	63143,	PLL_ISDB_T_PARTIAL_1_SEG_432, 0x0F, 0x335205B8, 0x0A, 
	69143,	PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A, 
	75143,	PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A, 
	81143,	PLL_ISDB_T_PARTIAL_1_SEG_432, 0x0F, 0x335205B8, 0x0A, 
	87143,	PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A, 
	177143, PLL_ISDB_T_PARTIAL_1_SEG_496, 0x2E, 0x4578FCB9, 0x0A,
	183143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	189143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	/* ISDB-T 1-seg, VHF */
	195143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	201143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	207143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	213143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	219143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	/* ISDB-T 1-seg, UHF */
	473143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	479143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	485143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	491143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	497143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	503143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	509143, PLL_ISDB_T_PARTIAL_1_SEG_496, 0x2E, 0x4578FCB9, 0x0A,
	515143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	521143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	527143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	533143, PLL_ISDB_T_PARTIAL_1_SEG_432, 0x0F, 0x335205B8, 0x0A,
	539143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	545143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	551143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	557143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	563143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	569143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	575143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	581143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	587143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	593143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	599143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	605143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	611143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	617143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	623143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	629143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	635143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	641143, PLL_ISDB_T_PARTIAL_1_SEG_512, 0x34, 0xD34D34D3, 0x0A,
	647143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	653143, PLL_ISDB_T_PARTIAL_1_SEG_496, 0x2E, 0x4578FCB9, 0x0A,
	659143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	665143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	671143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	677143, PLL_ISDB_T_PARTIAL_1_SEG_496, 0x2E, 0x4578FCB9, 0x0A,
	683143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	689143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	695143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	701143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	707143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	713143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	719143, PLL_ISDB_T_PARTIAL_1_SEG_432, 0x0F, 0x335205B8, 0x0A,
	725143, PLL_ISDB_T_PARTIAL_1_SEG_416, 0x05, 0xF05F05F0, 0x0A,
	731143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	737143, PLL_ISDB_T_PARTIAL_1_SEG_496, 0x2E, 0x4578FCB9, 0x0A,
	743143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	749143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	755143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	761143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	767143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	773143, PLL_ISDB_T_PARTIAL_1_SEG_464, 0x1F, 0xCEAD7815, 0x0A,
	779143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	785143, PLL_ISDB_T_PARTIAL_1_SEG_408, 0x01, 0x0929ABB3, 0x0A,
	791143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	797143, PLL_ISDB_T_PARTIAL_1_SEG_432, 0x0F, 0x335205B8, 0x0A,
	803143, PLL_ISDB_T_PARTIAL_1_SEG_384, 0x27, 0x47C9D1F2, 0x28,
	0, PLL_ISDB_T_PARTIAL_1_SEG, 0x00, 0x00000000, 0x00
};

I32U DpllTable_FullSeg [_MAX_FULLSEG_FREQ_NUM_ * 5] = {
	/* please align low frequency to high frequency */
	/* start frequency, Pll, RC STEP_H, RC_STEP_L, ADC Clk */

	/* isdb-tmm */
	210429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	213429, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	216000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,
	219000, PLL_ISDB_TMM_FULLSEG, 0x0E, 0x1499D87F, 0x02,

	/* isdbt full seg - VHF - Japan only */
	93143,  PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	99143,  PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	105143, PLL_ISDB_T_FULLSEG_31, 0x27, 0x47C9D1F2, 0x21,
	173143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	179143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	185143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	191143, PLL_ISDB_T_FULLSEG_31, 0x2F, 0xF2FF2FF2, 0x03,
	/* isdbt full seg - VHF - Brazil only */
	57143,	PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03, 
	63143,	PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03, 
	69143,	PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03, 
	75143,	PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03, 
	81143,	PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03, 
	87143,	PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03, 
	177143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	183143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	189143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	/* isdbt full seg - VHF */
	195143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	201143, PLL_ISDB_T_FULLSEG_31, 0x27, 0x47C9D1F2, 0x21,
	207143, PLL_ISDB_T_FULLSEG_31, 0x27, 0x47C9D1F2, 0x21,
	213143, PLL_ISDB_T_FULLSEG_31, 0x2F, 0xF2FF2FF2, 0x03,
	219143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	/* JAPAN_BAND_MID_TABLE */
	111143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x03,
	117143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	123143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	129143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x21,
	135143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	141143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	147143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	153143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	159143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	167143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	/* JAPAN_BAND_SHB_TABLE */
	225143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	231143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	237143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	243143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x21,
	249143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	255143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	261143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	267143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	273143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	279143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	285143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	291143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	297143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x21,
	303143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	309143, PLL_ISDB_T_FULLSEG_31, 0x2F, 0xF2FF2FF2, 0x03,
	315143, PLL_ISDB_T_FULLSEG_2E, 0x27, 0x47C9D1F2, 0x21,
	321143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x03,
	327143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	333143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	339143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	345143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	351143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	357143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	363143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	369143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	375143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	381143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	387143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	393143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	399143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	405143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	411143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x21,
	417143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x03,
	423143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	429143, PLL_ISDB_T_FULLSEG_31, 0x27, 0x47C9D1F2, 0x21,
	435143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	441143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	447143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	453143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	459143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	465143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	/* isdbt full seg - UHF */
	473143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	479143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	485143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	491143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	497143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	503143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	509143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	515143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	521143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	527143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	533143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x21,
	539143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	545143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	551143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	557143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	563143, PLL_ISDB_T_FULLSEG_2A, 0x0E, 0x1499D87F, 0x03,
	569143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	575143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	581143, PLL_ISDB_T_FULLSEG_31, 0x27, 0x47C9D1F2, 0x21,
	587143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	593143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	599143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	605143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	611143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	617143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	623143, PLL_ISDB_T_FULLSEG_2F, 0x27, 0x47C9D1F2, 0x03,
	629143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	635143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	641143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	647143, PLL_ISDB_T_FULLSEG_2B, 0x27, 0x47C9D1F2, 0x21,
	653143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	659143, PLL_ISDB_T_FULLSEG_2E, 0x27, 0x47C9D1F2, 0x21,
	665143, PLL_ISDB_T_FULLSEG_30, 0x27, 0x47C9D1F2, 0x21,
	671143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	677143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	683143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	689143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	695143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	701143, PLL_ISDB_T_FULLSEG_2E, 0x27, 0x47C9D1F2, 0x21,
	707143, PLL_ISDB_T_FULLSEG_2D, 0x1D, 0xDB9AF156, 0x03,
	713143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	719143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	725143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	731143, PLL_ISDB_T_FULLSEG_30, 0x2B, 0xB4099EA4, 0x03,
	737143, PLL_ISDB_T_FULLSEG_2E, 0x27, 0x47C9D1F2, 0x21,
	743143, PLL_ISDB_T_FULLSEG_2E, 0x22, 0xAB5BBB2E, 0x03,
	749143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	755143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	761143, PLL_ISDB_T_FULLSEG_2A, 0x27, 0x47C9D1F2, 0x21,
	767143, PLL_ISDB_T_FULLSEG_2C, 0x18, 0xD51B8A9C, 0x03,
	773143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	779143, PLL_ISDB_T_FULLSEG_2C, 0x27, 0x47C9D1F2, 0x21,
	785143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	791143, PLL_ISDB_T_FULLSEG_2D, 0x27, 0x47C9D1F2, 0x21,
	797143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	803143, PLL_ISDB_T_FULLSEG_2B, 0x13, 0x9421FC4E, 0x03,
	     0, PLL_ISDB_T_FULLSEG, 0x00, 0x00000000, 0x00
};
