#ifndef SHTSC_IOCTL_H
#define SHTSC_IOCTL_H

#define SHTSC_SIGNAL (SIGRTMIN+0)

struct reg {
  unsigned char addr;
  unsigned char data;
};

#define SHTSC_IOCTL_MAGIC 'k'
#define SHTSC_IOCTL_DEBUG _IO(SHTSC_IOCTL_MAGIC, 0)

#define SHTSC_IOCTL_SET_PAGE _IO(SHTSC_IOCTL_MAGIC, 1)
#define SHTSC_IOCTL_ERASE _IO(SHTSC_IOCTL_MAGIC, 2)
#define SHTSC_IOCTL_WRITE _IO(SHTSC_IOCTL_MAGIC, 3)
#define SHTSC_IOCTL_VERIFY _IO(SHTSC_IOCTL_MAGIC, 4)
#define SHTSC_IOCTL_FLASH_ACCESS_START _IO(SHTSC_IOCTL_MAGIC, 5)
#define SHTSC_IOCTL_FLASH_ACCESS_END _IO(SHTSC_IOCTL_MAGIC, 6)
#define SHTSC_IOCTL_ERASE_ALL _IO(SHTSC_IOCTL_MAGIC, 7)

#define SHTSC_IOCTL_REG_1WRITE _IO(SHTSC_IOCTL_MAGIC, 8)
#define SHTSC_IOCTL_REG_1READ _IOR(SHTSC_IOCTL_MAGIC, 9, struct reg)
#define SHTSC_IOCTL_REG_N_RW_SET_ADDR _IO(SHTSC_IOCTL_MAGIC, 10)
#define SHTSC_IOCTL_REG_N_WRITE_1ADDR_GO _IO(SHTSC_IOCTL_MAGIC, 11)
#define SHTSC_IOCTL_REG_N_READ_1ADDR_GO _IO(SHTSC_IOCTL_MAGIC, 12)

//#define SHTSC_IOCTL_ERASE_ALL_BUT_CALIB _IO(SHTSC_IOCTL_MAGIC, 13)
#define SHTSC_IOCTL_RESET _IO(SHTSC_IOCTL_MAGIC, 14)
#define SHTSC_IOCTL_SETIRQMASK _IO(SHTSC_IOCTL_MAGIC, 15)
#define SHTSC_IOCTL_CMD_ISSUE_RESULT _IO(SHTSC_IOCTL_MAGIC, 16)
#define SHTSC_IOCTL_DRIVER_VERSION_READ _IO(SHTSC_IOCTL_MAGIC, 17)
#define SHTSC_IOCTL_DCMAP _IO(SHTSC_IOCTL_MAGIC, 18) // new method. not for fread()
#define SHTSC_IOCTL_FLASH_READ _IO(SHTSC_IOCTL_MAGIC, 19)

#define SHTSC_IOCTL_NOTIFY_PID _IO(SHTSC_IOCTL_MAGIC, 20)
#define SHTSC_IOCTL_GET_INTERRUPT_STATUS _IO(SHTSC_IOCTL_MAGIC, 21)

#define SHTSC_IOCTL_GET_REPORT _IO(SHTSC_IOCTL_MAGIC, 22)

#endif /* SHTSC_IOCTL_H */
