/*
 * Copyright (c) 2013-2014, Linux Foundation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */

#ifndef UFS_QCOM_PHY_QMP_28NM_H_
#define UFS_QCOM_PHY_QMP_28NM_H_

#include <linux/phy/phy-qcom-ufs.h>

/* QCOM UFS PHY control registers */

#define COM_OFF(x)     (0x000 + x)
#define PHY_OFF(x)     (0x700 + x)
#define TX_OFF(n, x)   (0x100 + (0x400 * n) + x)
#define RX_OFF(n, x)   (0x200 + (0x400 * n) + x)

/* UFS PHY PLL block registers */
#define QSERDES_COM_SYS_CLK_CTRL                            COM_OFF(0x00)
#define QSERDES_COM_PLL_VCOTAIL_EN                          COM_OFF(0x04)
#define QSERDES_COM_CMN_MODE                                COM_OFF(0x08)
#define QSERDES_COM_IE_TRIM                                 COM_OFF(0x0C)
#define QSERDES_COM_IP_TRIM                                 COM_OFF(0x10)
#define QSERDES_COM_PLL_CNTRL                               COM_OFF(0x14)
#define QSERDES_COM_PLL_IP_SETI                             COM_OFF(0x18)
#define QSERDES_COM_CORE_CLK_IN_SYNC_SEL                    COM_OFF(0x1C)
#define QSERDES_COM_BIAS_EN_CLKBUFLR_EN                     COM_OFF(0x20)
#define QSERDES_COM_PLL_CP_SETI                             COM_OFF(0x24)
#define QSERDES_COM_PLL_IP_SETP                             COM_OFF(0x28)
#define QSERDES_COM_PLL_CP_SETP                             COM_OFF(0x2C)
#define QSERDES_COM_ATB_SEL1                                COM_OFF(0x30)
#define QSERDES_COM_ATB_SEL2                                COM_OFF(0x34)
#define QSERDES_COM_SYSCLK_EN_SEL                           COM_OFF(0x38)
#define QSERDES_COM_RES_CODE_TXBAND                         COM_OFF(0x3C)
#define QSERDES_COM_RESETSM_CNTRL                           COM_OFF(0x40)
#define QSERDES_COM_PLLLOCK_CMP1                            COM_OFF(0x44)
#define QSERDES_COM_PLLLOCK_CMP2                            COM_OFF(0x48)
#define QSERDES_COM_PLLLOCK_CMP3                            COM_OFF(0x4C)
#define QSERDES_COM_PLLLOCK_CMP_EN                          COM_OFF(0x50)
#define QSERDES_COM_RES_TRIM_OFFSET                         COM_OFF(0x54)
#define QSERDES_COM_BGTC                                    COM_OFF(0x58)
#define QSERDES_COM_PLL_TEST_UPDN_RESTRIMSTEP               COM_OFF(0x5C)
#define QSERDES_COM_PLL_VCO_TUNE                            COM_OFF(0x60)
#define QSERDES_COM_DEC_START1                              COM_OFF(0x64)
#define QSERDES_COM_PLL_AMP_OS                              COM_OFF(0x68)
#define QSERDES_COM_SSC_EN_CENTER                           COM_OFF(0x6C)
#define QSERDES_COM_SSC_ADJ_PER1                            COM_OFF(0x70)
#define QSERDES_COM_SSC_ADJ_PER2                            COM_OFF(0x74)
#define QSERDES_COM_SSC_PER1                                COM_OFF(0x78)
#define QSERDES_COM_SSC_PER2                                COM_OFF(0x7C)
#define QSERDES_COM_SSC_STEP_SIZE1                          COM_OFF(0x80)
#define QSERDES_COM_SSC_STEP_SIZE2                          COM_OFF(0x84)
#define QSERDES_COM_RES_TRIM_SEARCH                         COM_OFF(0x88)
#define QSERDES_COM_RES_TRIM_FREEZE                         COM_OFF(0x8C)
#define QSERDES_COM_RES_TRIM_EN_VCOCALDONE                  COM_OFF(0x90)
#define QSERDES_COM_FAUX_EN                                 COM_OFF(0x94)
#define QSERDES_COM_DIV_FRAC_START1                         COM_OFF(0x98)
#define QSERDES_COM_DIV_FRAC_START2                         COM_OFF(0x9C)
#define QSERDES_COM_DIV_FRAC_START3                         COM_OFF(0xA0)
#define QSERDES_COM_DEC_START2                              COM_OFF(0xA4)
#define QSERDES_COM_PLL_RXTXEPCLK_EN                        COM_OFF(0xA8)
#define QSERDES_COM_PLL_CRCTRL                              COM_OFF(0xAC)
#define QSERDES_COM_PLL_CLKEPDIV                            COM_OFF(0xB0)
#define QSERDES_COM_PLL_FREQUPDATE                          COM_OFF(0xB4)
#define QSERDES_COM_PLL_VCO_HIGH                            COM_OFF(0xB8)
#define QSERDES_COM_RESET_SM                                COM_OFF(0xBC)

/* UFS PHY registers */
#define UFS_PHY_PHY_START                                   PHY_OFF(0x00)
#define UFS_PHY_POWER_DOWN_CONTROL                          PHY_OFF(0x04)
#define UFS_PHY_PWM_G1_CLK_DIVIDER                          PHY_OFF(0x08)
#define UFS_PHY_PWM_G2_CLK_DIVIDER                          PHY_OFF(0x0C)
#define UFS_PHY_PWM_G3_CLK_DIVIDER                          PHY_OFF(0x10)
#define UFS_PHY_PWM_G4_CLK_DIVIDER                          PHY_OFF(0x14)
#define UFS_PHY_TIMER_100US_SYSCLK_STEPS_MSB                PHY_OFF(0x18)
#define UFS_PHY_TIMER_100US_SYSCLK_STEPS_LSB                PHY_OFF(0x1C)
#define UFS_PHY_TIMER_20US_CORECLK_STEPS_MSB                PHY_OFF(0x20)
#define UFS_PHY_TIMER_20US_CORECLK_STEPS_LSB                PHY_OFF(0x24)
#define UFS_PHY_LINE_RESET_TIME                             PHY_OFF(0x28)
#define UFS_PHY_LINE_RESET_GRANULARITY                      PHY_OFF(0x2C)
#define UFS_PHY_CONTROLSYM_ONE_HOT_DISABLE                  PHY_OFF(0x30)
#define UFS_PHY_CORECLK_PWM_G1_CLK_DIVIDER                  PHY_OFF(0x34)
#define UFS_PHY_CORECLK_PWM_G2_CLK_DIVIDER                  PHY_OFF(0x38)
#define UFS_PHY_CORECLK_PWM_G3_CLK_DIVIDER                  PHY_OFF(0x3C)
#define UFS_PHY_CORECLK_PWM_G4_CLK_DIVIDER                  PHY_OFF(0x40)
#define UFS_PHY_TX_LANE_ENABLE                              PHY_OFF(0x44)
#define UFS_PHY_TSYNC_RSYNC_CNTL                            PHY_OFF(0x48)
#define UFS_PHY_RETIME_BUFFER_EN                            PHY_OFF(0x4C)
#define UFS_PHY_PLL_CNTL                                    PHY_OFF(0x50)
#define UFS_PHY_TX_LARGE_AMP_DRV_LVL                        PHY_OFF(0x54)
#define UFS_PHY_TX_LARGE_AMP_POST_EMP_LVL                   PHY_OFF(0x58)
#define UFS_PHY_TX_SMALL_AMP_DRV_LVL                        PHY_OFF(0x5C)
#define UFS_PHY_TX_SMALL_AMP_POST_EMP_LVL                   PHY_OFF(0x60)
#define UFS_PHY_CFG_CHANGE_CNT_VAL                          PHY_OFF(0x64)
#define UFS_PHY_OMC_STATUS_RDVAL                            PHY_OFF(0x68)
#define UFS_PHY_RX_SYNC_WAIT_TIME                           PHY_OFF(0x6C)
#define UFS_PHY_L0_BIST_CTRL                                PHY_OFF(0x70)
#define UFS_PHY_L1_BIST_CTRL                                PHY_OFF(0x74)
#define UFS_PHY_BIST_PRBS_POLY0                             PHY_OFF(0x78)
#define UFS_PHY_BIST_PRBS_POLY1                             PHY_OFF(0x7C)
#define UFS_PHY_BIST_PRBS_SEED0                             PHY_OFF(0x80)
#define UFS_PHY_BIST_PRBS_SEED1                             PHY_OFF(0x84)
#define UFS_PHY_BIST_FIXED_PAT_CTRL                         PHY_OFF(0x88)
#define UFS_PHY_BIST_FIXED_PAT0_DATA                        PHY_OFF(0x8C)
#define UFS_PHY_BIST_FIXED_PAT1_DATA                        PHY_OFF(0x90)
#define UFS_PHY_BIST_FIXED_PAT2_DATA                        PHY_OFF(0x94)
#define UFS_PHY_BIST_FIXED_PAT3_DATA                        PHY_OFF(0x98)
#define UFS_PHY_TX_HSGEAR_CAPABILITY                        PHY_OFF(0x9C)
#define UFS_PHY_TX_PWMGEAR_CAPABILITY                       PHY_OFF(0xA0)
#define UFS_PHY_TX_AMPLITUDE_CAPABILITY                     PHY_OFF(0xA4)
#define UFS_PHY_TX_EXTERNALSYNC_CAPABILITY                  PHY_OFF(0xA8)
#define UFS_PHY_TX_HS_UNTERMINATED_LINE_DRIVE_CAPABILITY    PHY_OFF(0xAC)
#define UFS_PHY_TX_LS_TERMINATED_LINE_DRIVE_CAPABILITY      PHY_OFF(0xB0)
#define UFS_PHY_TX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY       PHY_OFF(0xB4)
#define UFS_PHY_TX_MIN_STALL_NOCONFIG_TIME_CAPABILITY       PHY_OFF(0xB8)
#define UFS_PHY_TX_MIN_SAVE_CONFIG_TIME_CAPABILITY          PHY_OFF(0xBC)
#define UFS_PHY_TX_REF_CLOCK_SHARED_CAPABILITY              PHY_OFF(0xC0)
#define UFS_PHY_TX_PHY_MAJORMINOR_RELEASE_CAPABILITY        PHY_OFF(0xC4)
#define UFS_PHY_TX_PHY_EDITORIAL_RELEASE_CAPABILITY         PHY_OFF(0xC8)
#define UFS_PHY_TX_HIBERN8TIME_CAPABILITY                   PHY_OFF(0xCC)
#define UFS_PHY_RX_HSGEAR_CAPABILITY                        PHY_OFF(0xD0)
#define UFS_PHY_RX_PWMGEAR_CAPABILITY                       PHY_OFF(0xD4)
#define UFS_PHY_RX_HS_UNTERMINATED_CAPABILITY               PHY_OFF(0xD8)
#define UFS_PHY_RX_LS_TERMINATED_CAPABILITY                 PHY_OFF(0xDC)
#define UFS_PHY_RX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY       PHY_OFF(0xE0)
#define UFS_PHY_RX_MIN_STALL_NOCONFIG_TIME_CAPABILITY       PHY_OFF(0xE4)
#define UFS_PHY_RX_MIN_SAVE_CONFIG_TIME_CAPABILITY          PHY_OFF(0xE8)
#define UFS_PHY_RX_REF_CLOCK_SHARED_CAPABILITY              PHY_OFF(0xEC)
#define UFS_PHY_RX_HS_G1_SYNC_LENGTH_CAPABILITY             PHY_OFF(0xF0)
#define UFS_PHY_RX_HS_G1_PREPARE_LENGTH_CAPABILITY          PHY_OFF(0xF4)
#define UFS_PHY_RX_LS_PREPARE_LENGTH_CAPABILITY             PHY_OFF(0xF8)
#define UFS_PHY_RX_PWM_BURST_CLOSURE_LENGTH_CAPABILITY      PHY_OFF(0xFC)
#define UFS_PHY_RX_MIN_ACTIVATETIME_CAPABILITY              PHY_OFF(0x100)
#define UFS_PHY_RX_PHY_MAJORMINOR_RELEASE_CAPABILITY        PHY_OFF(0x104)
#define UFS_PHY_RX_PHY_EDITORIAL_RELEASE_CAPABILITY         PHY_OFF(0x108)
#define UFS_PHY_RX_HIBERN8TIME_CAPABILITY                   PHY_OFF(0x10C)
#define UFS_PHY_RX_HS_G2_SYNC_LENGTH_CAPABILITY             PHY_OFF(0x110)
#define UFS_PHY_RX_HS_G3_SYNC_LENGTH_CAPABILITY             PHY_OFF(0x114)
#define UFS_PHY_RX_HS_G2_PREPARE_LENGTH_CAPABILITY          PHY_OFF(0x118)
#define UFS_PHY_RX_HS_G3_PREPARE_LENGTH_CAPABILITY          PHY_OFF(0x11C)
#define UFS_PHY_DEBUG_BUS_SEL                               PHY_OFF(0x120)
#define UFS_PHY_DEBUG_BUS_0_STATUS_CHK                      PHY_OFF(0x124)
#define UFS_PHY_DEBUG_BUS_1_STATUS_CHK                      PHY_OFF(0x128)
#define UFS_PHY_DEBUG_BUS_2_STATUS_CHK                      PHY_OFF(0x12C)
#define UFS_PHY_DEBUG_BUS_3_STATUS_CHK                      PHY_OFF(0x130)
#define UFS_PHY_PCS_READY_STATUS                            PHY_OFF(0x134)
#define UFS_PHY_L0_BIST_CHK_ERR_CNT_L_STATUS                PHY_OFF(0x138)
#define UFS_PHY_L0_BIST_CHK_ERR_CNT_H_STATUS                PHY_OFF(0x13C)
#define UFS_PHY_L1_BIST_CHK_ERR_CNT_L_STATUS                PHY_OFF(0x140)
#define UFS_PHY_L1_BIST_CHK_ERR_CNT_H_STATUS                PHY_OFF(0x144)
#define UFS_PHY_L0_BIST_CHK_STATUS                          PHY_OFF(0x148)
#define UFS_PHY_L1_BIST_CHK_STATUS                          PHY_OFF(0x14C)
#define UFS_PHY_DEBUG_BUS_0_STATUS                          PHY_OFF(0x150)
#define UFS_PHY_DEBUG_BUS_1_STATUS                          PHY_OFF(0x154)
#define UFS_PHY_DEBUG_BUS_2_STATUS                          PHY_OFF(0x158)
#define UFS_PHY_DEBUG_BUS_3_STATUS                          PHY_OFF(0x15C)
#define UFS_PHY_RMMI_ATTR_CTRL                              PHY_OFF(0x16C)
#define UFS_PHY_RMMI_RX_CFGUPDT_L1	(1 << 7)
#define UFS_PHY_RMMI_TX_CFGUPDT_L1	(1 << 6)
#define UFS_PHY_RMMI_CFGWR_L1		(1 << 5)
#define UFS_PHY_RMMI_CFGRD_L1		(1 << 4)
#define UFS_PHY_RMMI_RX_CFGUPDT_L0	(1 << 3)
#define UFS_PHY_RMMI_TX_CFGUPDT_L0	(1 << 2)
#define UFS_PHY_RMMI_CFGWR_L0		(1 << 1)
#define UFS_PHY_RMMI_CFGRD_L0		(1 << 0)
#define UFS_PHY_RMMI_ATTRID				    PHY_OFF(0x170)
#define UFS_PHY_RMMI_ATTRWRVAL				    PHY_OFF(0x174)
#define UFS_PHY_RMMI_ATTRRDVAL_L0_STATUS		    PHY_OFF(0x178)
#define UFS_PHY_RMMI_ATTRRDVAL_L1_STATUS		    PHY_OFF(0x17C)

/* TX LANE n (0, 1) registers */
#define QSERDES_TX_BIST_MODE_LANENO(n)                      TX_OFF(n, 0x00)
#define QSERDES_TX_CLKBUF_ENABLE(n)                         TX_OFF(n, 0x04)
#define QSERDES_TX_TX_EMP_POST1_LVL(n)                      TX_OFF(n, 0x08)
#define QSERDES_TX_TX_DRV_LVL(n)                            TX_OFF(n, 0x0C)
#define QSERDES_TX_RESET_TSYNC_EN(n)                        TX_OFF(n, 0x10)
#define QSERDES_TX_LPB_EN(n)                                TX_OFF(n, 0x14)
#define QSERDES_TX_RES_CODE(n)                              TX_OFF(n, 0x18)
#define QSERDES_TX_PERL_LENGTH1(n)                          TX_OFF(n, 0x1C)
#define QSERDES_TX_PERL_LENGTH2(n)                          TX_OFF(n, 0x20)
#define QSERDES_TX_SERDES_BYP_EN_OUT(n)                     TX_OFF(n, 0x24)
#define QSERDES_TX_HIGHZ_TRANSCEIVEREN_BIAS_EN(n)           TX_OFF(n, 0x28)
#define QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN(n)            TX_OFF(n, 0x2C)
#define QSERDES_TX_BIST_PATTERN1(n)                         TX_OFF(n, 0x30)
#define QSERDES_TX_BIST_PATTERN2(n)                         TX_OFF(n, 0x34)
#define QSERDES_TX_BIST_PATTERN3(n)                         TX_OFF(n, 0x38)
#define QSERDES_TX_BIST_PATTERN4(n)                         TX_OFF(n, 0x3C)
#define QSERDES_TX_BIST_PATTERN5(n)                         TX_OFF(n, 0x40)
#define QSERDES_TX_BIST_PATTERN6(n)                         TX_OFF(n, 0x44)
#define QSERDES_TX_BIST_PATTERN7(n)                         TX_OFF(n, 0x48)
#define QSERDES_TX_BIST_PATTERN8(n)                         TX_OFF(n, 0x4C)
#define QSERDES_TX_LANE_MODE(n)                             TX_OFF(n, 0x50)
#define QSERDES_TX_ATB_SEL(n)                               TX_OFF(n, 0x54)
#define QSERDES_TX_REC_DETECT_LVL(n)                        TX_OFF(n, 0x58)
#define QSERDES_TX_PRBS_SEED1(n)                            TX_OFF(n, 0x5C)
#define QSERDES_TX_PRBS_SEED2(n)                            TX_OFF(n, 0x60)
#define QSERDES_TX_PRBS_SEED3(n)                            TX_OFF(n, 0x64)
#define QSERDES_TX_PRBS_SEED4(n)                            TX_OFF(n, 0x68)
#define QSERDES_TX_RESET_GEN(n)                             TX_OFF(n, 0x6C)
#define QSERDES_TX_TRAN_DRVR_EMP_EN(n)                      TX_OFF(n, 0x70)
#define QSERDES_TX_TX_INTERFACE_MODE(n)                     TX_OFF(n, 0x74)
#define QSERDES_TX_BIST_STATUS(n)                           TX_OFF(n, 0x78)
#define QSERDES_TX_BIST_ERROR_COUNT1(n)                     TX_OFF(n, 0x7C)
#define QSERDES_TX_BIST_ERROR_COUNT2(n)                     TX_OFF(n, 0x80)

/* RX LANE n (0, 1) registers */
#define QSERDES_RX_CDR_CONTROL(n)                           RX_OFF(n, 0x00)
#define QSERDES_RX_AUX_CONTROL(n)                           RX_OFF(n, 0x04)
#define QSERDES_RX_AUX_DATA_TCODE(n)                        RX_OFF(n, 0x08)
#define QSERDES_RX_RCLK_AUXDATA_SEL(n)                      RX_OFF(n, 0x0C)
#define QSERDES_RX_EQ_CONTROL(n)                            RX_OFF(n, 0x10)
#define QSERDES_RX_RX_EQ_GAIN2(n)                           RX_OFF(n, 0x14)
#define QSERDES_RX_AC_JTAG_INIT(n)                          RX_OFF(n, 0x18)
#define QSERDES_RX_AC_JTAG_LVL_EN(n)                        RX_OFF(n, 0x1C)
#define QSERDES_RX_AC_JTAG_MODE(n)                          RX_OFF(n, 0x20)
#define QSERDES_RX_AC_JTAG_RESET(n)                         RX_OFF(n, 0x24)
#define QSERDES_RX_RX_IQ_RXDET_EN(n)                        RX_OFF(n, 0x28)
#define QSERDES_RX_RX_TERM_HIGHZ_CM_AC_COUPLE(n)            RX_OFF(n, 0x2C)
#define QSERDES_RX_RX_EQ_GAIN1(n)                           RX_OFF(n, 0x30)
#define QSERDES_RX_SIGDET_CNTRL(n)                          RX_OFF(n, 0x34)
#define QSERDES_RX_RX_BAND(n)                               RX_OFF(n, 0x38)
#define QSERDES_RX_CDR_FREEZE_UP_DN(n)                      RX_OFF(n, 0x3C)
#define QSERDES_RX_RX_INTERFACE_MODE(n)                     RX_OFF(n, 0x40)
#define QSERDES_RX_JITTER_GEN_MODE(n)                       RX_OFF(n, 0x44)
#define QSERDES_RX_BUJ_AMP(n)                               RX_OFF(n, 0x48)
#define QSERDES_RX_SJ_AMP1(n)                               RX_OFF(n, 0x4C)
#define QSERDES_RX_SJ_AMP2(n)                               RX_OFF(n, 0x50)
#define QSERDES_RX_SJ_PER1(n)                               RX_OFF(n, 0x54)
#define QSERDES_RX_SJ_PER2(n)                               RX_OFF(n, 0x58)
#define QSERDES_RX_BUJ_STEP_FREQ1(n)                        RX_OFF(n, 0x5C)
#define QSERDES_RX_BUJ_STEP_FREQ2(n)                        RX_OFF(n, 0x60)
#define QSERDES_RX_PPM_OFFSET1(n)                           RX_OFF(n, 0x64)
#define QSERDES_RX_PPM_OFFSET2(n)                           RX_OFF(n, 0x68)
#define QSERDES_RX_SIGN_PPM_PERIOD1(n)                      RX_OFF(n, 0x6C)
#define QSERDES_RX_SIGN_PPM_PERIOD2(n)                      RX_OFF(n, 0x70)
#define QSERDES_RX_SSC_CTRL(n)                              RX_OFF(n, 0x74)
#define QSERDES_RX_SSC_COUNT1(n)                            RX_OFF(n, 0x78)
#define QSERDES_RX_SSC_COUNT2(n)                            RX_OFF(n, 0x7C)
#define QSERDES_RX_PWM_CNTRL1(n)                            RX_OFF(n, 0x80)
#define QSERDES_RX_PWM_CNTRL2(n)                            RX_OFF(n, 0x84)
#define QSERDES_RX_PWM_NDIV(n)                              RX_OFF(n, 0x88)
#define QSERDES_RX_SIGDET_CNTRL2(n)                         RX_OFF(n, 0x8C)
#define QSERDES_RX_UFS_CNTRL(n)                             RX_OFF(n, 0x90)
#define QSERDES_RX_CDR_CONTROL3(n)                          RX_OFF(n, 0x94)
#define QSERDES_RX_CDR_CONTROL_HALF(n)                      RX_OFF(n, 0x98)
#define QSERDES_RX_CDR_CONTROL_QUARTER(n)                   RX_OFF(n, 0x9C)
#define QSERDES_RX_CDR_CONTROL_EIGHTH(n)                    RX_OFF(n, 0xA0)
#define QSERDES_RX_UCDR_FO_GAIN(n)                          RX_OFF(n, 0xA4)
#define QSERDES_RX_UCDR_SO_GAIN(n)                          RX_OFF(n, 0xA8)
#define QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE(n)         RX_OFF(n, 0xAC)
#define QSERDES_RX_UCDR_FO_TO_SO_DELAY(n)                   RX_OFF(n, 0xB0)
#define QSERDES_RX_PI_CTRL1(n)                              RX_OFF(n, 0xB4)
#define QSERDES_RX_PI_CTRL2(n)                              RX_OFF(n, 0xB8)
#define QSERDES_RX_PI_QUAD(n)                               RX_OFF(n, 0xBC)
#define QSERDES_RX_IDATA1(n)                                RX_OFF(n, 0xC0)
#define QSERDES_RX_IDATA2(n)                                RX_OFF(n, 0xC4)
#define QSERDES_RX_AUX_DATA1(n)                             RX_OFF(n, 0xC8)
#define QSERDES_RX_AUX_DATA2(n)                             RX_OFF(n, 0xCC)
#define QSERDES_RX_AC_JTAG_OUTP(n)                          RX_OFF(n, 0xD0)
#define QSERDES_RX_AC_JTAG_OUTN(n)                          RX_OFF(n, 0xD4)
#define QSERDES_RX_RX_SIGDET_PWMDECSTATUS(n)                RX_OFF(n, 0xD8)

#define UFS_PHY_TX_LANE_ENABLE_MASK		0x3

/*
 * This structure represents the 28nm specific phy.
 * common_cfg MUST remain the first field in this structure
 * in case extra fields are added. This way, when calling
 * get_ufs_qcom_phy() of generic phy, we can extract the
 * common phy structure (struct ufs_qcom_phy) out of it
 * regardless of the relevant specific phy.
 */
struct ufs_qcom_phy_qmp_28nm {
	struct ufs_qcom_phy common_cfg;
};

static struct ufs_qcom_phy_calibration phy_cal_table_ctrl_1_1_0_rate_A[] = {
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_POWER_DOWN_CONTROL, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CRCTRL, 0xFF),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CNTRL, 0x24),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_SYSCLK_EN_SEL, 0x08),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_SYS_CLK_CTRL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CLKEPDIV, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DEC_START1, 0x82),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DEC_START2, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START1, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START2, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START3, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP1, 0xff),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP2, 0x67),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP3, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP_EN, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_RESETSM_CNTRL, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_RXTXEPCLK_EN, 0x13),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_PWM_CNTRL1(0), 0x43),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_PWM_CNTRL1(1), 0x43),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL(0), 0x22),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_HALF(0), 0x12),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_QUARTER(0), 0x2a),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL(1), 0x22),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_HALF(1), 0x12),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_QUARTER(1), 0x2a),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL(0), 0xC0),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL(1), 0xC0),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL2(0), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL2(1), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G1_CLK_DIVIDER, 0x50),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G2_CLK_DIVIDER, 0x28),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G3_CLK_DIVIDER, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G4_CLK_DIVIDER, 0x08),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G1_CLK_DIVIDER, 0xa8),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G2_CLK_DIVIDER, 0x54),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G3_CLK_DIVIDER, 0x2a),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G4_CLK_DIVIDER, 0x15),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_OMC_STATUS_RDVAL, 0xff),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_LINE_RESET_TIME, 0x1f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_LINE_RESET_GRANULARITY, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TSYNC_RSYNC_CNTL, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PLL_CNTL, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_LARGE_AMP_DRV_LVL, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_SMALL_AMP_DRV_LVL, 0x1a),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_LARGE_AMP_POST_EMP_LVL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_SMALL_AMP_POST_EMP_LVL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CFG_CHANGE_CNT_VAL, 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_SYNC_WAIT_TIME, 0x30),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY, 0x08),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_MIN_STALL_NOCONFIG_TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_MIN_STALL_NOCONFIG_TIME_CAPABILITY, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_MIN_SAVE_CONFIG_TIME_CAPABILITY, 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_MIN_SAVE_CONFIG_TIME_CAPABILITY, 0xc8),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_PWM_BURST_CLOSURE_LENGTH_CAPABILITY, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_MIN_ACTIVATETIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN1(0), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN2(0), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN1(1), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN2(1), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL3(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL3(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_IP_SETI, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CP_SETI, 0x3f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_IP_SETP, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CP_SETP, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_RES_TRIM_OFFSET, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_BGTC, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_AMP_OS, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_DRV_LVL(0), 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_DRV_LVL(1), 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_BIST_MODE_LANENO(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_BIST_MODE_LANENO(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_EMP_POST1_LVL(0), 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_EMP_POST1_LVL(1), 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_HIGHZ_TRANSCEIVEREN_BIAS_EN(0), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_HIGHZ_TRANSCEIVEREN_BIAS_EN(1), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_100US_SYSCLK_STEPS_MSB, 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_100US_SYSCLK_STEPS_LSB, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_20US_CORECLK_STEPS_MSB, 0x27),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_20US_CORECLK_STEPS_LSB, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CONTROLSYM_ONE_HOT_DISABLE, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RETIME_BUFFER_EN, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_HSGEAR_CAPABILITY, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_PWMGEAR_CAPABILITY, 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_AMPLITUDE_CAPABILITY, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_EXTERNALSYNC_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_HS_UNTERMINATED_LINE_DRIVE_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_LS_TERMINATED_LINE_DRIVE_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_REF_CLOCK_SHARED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_HIBERN8TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HSGEAR_CAPABILITY, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_PWMGEAR_CAPABILITY, 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_UNTERMINATED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_LS_TERMINATED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_REF_CLOCK_SHARED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G1_SYNC_LENGTH_CAPABILITY, 0x48),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_HS_G1_PREPARE_LENGTH_CAPABILITY, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_LS_PREPARE_LENGTH_CAPABILITY, 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HIBERN8TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G2_SYNC_LENGTH_CAPABILITY, 0x48),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G3_SYNC_LENGTH_CAPABILITY, 0x48),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_HS_G2_PREPARE_LENGTH_CAPABILITY, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_HS_G3_PREPARE_LENGTH_CAPABILITY, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_CLKBUF_ENABLE(0), 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RESET_TSYNC_EN(0), 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RES_CODE(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_SERDES_BYP_EN_OUT(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_REC_DETECT_LVL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TRAN_DRVR_EMP_EN(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_CONTROL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_DATA_TCODE(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RCLK_AUXDATA_SEL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_EQ_CONTROL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_IQ_RXDET_EN(0), 0x73),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_TERM_HIGHZ_CM_AC_COUPLE(0), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_FREEZE_UP_DN(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UFS_CNTRL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_EIGHTH(0), 0x22),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_GAIN(0), 0x0a),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_SO_GAIN(0), 0x06),
	UFS_QCOM_PHY_CAL_ENTRY(
		QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE(0), 0x35),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_TO_SO_DELAY(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_CLKBUF_ENABLE(1), 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RESET_TSYNC_EN(1), 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RES_CODE(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_SERDES_BYP_EN_OUT(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_REC_DETECT_LVL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TRAN_DRVR_EMP_EN(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_CONTROL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_DATA_TCODE(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RCLK_AUXDATA_SEL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_EQ_CONTROL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_IQ_RXDET_EN(1), 0x73),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_TERM_HIGHZ_CM_AC_COUPLE(1), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_FREEZE_UP_DN(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UFS_CNTRL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_EIGHTH(1), 0x22),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_GAIN(1), 0x0a),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_SO_GAIN(1), 0x06),
	UFS_QCOM_PHY_CAL_ENTRY(
		QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE(1), 0x35),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_TO_SO_DELAY(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_CMN_MODE, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_IE_TRIM, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_IP_TRIM, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_CORE_CLK_IN_SYNC_SEL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_BIAS_EN_CLKBUFLR_EN, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_TEST_UPDN_RESTRIMSTEP, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_FAUX_EN, 0x00),
};

static struct ufs_qcom_phy_calibration phy_cal_table_ctrl_1_1_1_rate_A[] = {
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_POWER_DOWN_CONTROL, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CRCTRL, 0x43),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CNTRL, 0x24),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_SYSCLK_EN_SEL, 0x08),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_SYS_CLK_CTRL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CLKEPDIV, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DEC_START1, 0x82),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DEC_START2, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START1, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START2, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START3, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP1, 0xff),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP2, 0x19),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP3, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP_EN, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_RESETSM_CNTRL, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_RXTXEPCLK_EN, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_PWM_CNTRL1(0), 0x43),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_PWM_CNTRL1(1), 0x43),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL(0), 0x40),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_HALF(0), 0x0c),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_QUARTER(0), 0x12),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL(1), 0x40),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_HALF(1), 0x0c),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_QUARTER(1), 0x12),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL(0), 0xC0),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL(1), 0xC0),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL2(0), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_SIGDET_CNTRL2(1), 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G1_CLK_DIVIDER, 0x30),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G2_CLK_DIVIDER, 0x18),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G3_CLK_DIVIDER, 0x0c),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PWM_G4_CLK_DIVIDER, 0x06),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G1_CLK_DIVIDER, 0xa8),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G2_CLK_DIVIDER, 0x54),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G3_CLK_DIVIDER, 0x2a),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CORECLK_PWM_G4_CLK_DIVIDER, 0x15),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_OMC_STATUS_RDVAL, 0xff),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_LINE_RESET_TIME, 0x1f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_LINE_RESET_GRANULARITY, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TSYNC_RSYNC_CNTL, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_PLL_CNTL, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_LARGE_AMP_DRV_LVL, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_SMALL_AMP_DRV_LVL, 0x1a),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_LARGE_AMP_POST_EMP_LVL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_SMALL_AMP_POST_EMP_LVL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CFG_CHANGE_CNT_VAL, 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_SYNC_WAIT_TIME, 0x30),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY, 0x08),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_MIN_STALL_NOCONFIG_TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_MIN_STALL_NOCONFIG_TIME_CAPABILITY, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_MIN_SAVE_CONFIG_TIME_CAPABILITY, 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_MIN_SAVE_CONFIG_TIME_CAPABILITY, 0xc8),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_RX_PWM_BURST_CLOSURE_LENGTH_CAPABILITY, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_MIN_ACTIVATETIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN1(0), 0x1f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN2(0), 0x17),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN1(1), 0x1f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_EQ_GAIN2(1), 0x17),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL3(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL3(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_IP_SETI, 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CP_SETI, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_IP_SETP, 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CP_SETP, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_RES_TRIM_OFFSET, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_BGTC, 0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_AMP_OS, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_DRV_LVL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_DRV_LVL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_BIST_MODE_LANENO(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_BIST_MODE_LANENO(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_EMP_POST1_LVL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TX_EMP_POST1_LVL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_HIGHZ_TRANSCEIVEREN_BIAS_EN(0), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_HIGHZ_TRANSCEIVEREN_BIAS_EN(1), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_100US_SYSCLK_STEPS_MSB, 0x07),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_100US_SYSCLK_STEPS_LSB, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_20US_CORECLK_STEPS_MSB, 0x27),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TIMER_20US_CORECLK_STEPS_LSB, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_CONTROLSYM_ONE_HOT_DISABLE, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RETIME_BUFFER_EN, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_HSGEAR_CAPABILITY, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_PWMGEAR_CAPABILITY, 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_AMPLITUDE_CAPABILITY, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_EXTERNALSYNC_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_HS_UNTERMINATED_LINE_DRIVE_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(
		UFS_PHY_TX_LS_TERMINATED_LINE_DRIVE_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_REF_CLOCK_SHARED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_TX_HIBERN8TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HSGEAR_CAPABILITY, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_PWMGEAR_CAPABILITY, 0x04),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_UNTERMINATED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_LS_TERMINATED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_REF_CLOCK_SHARED_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G1_SYNC_LENGTH_CAPABILITY, 0x48),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G1_PREPARE_LENGTH_CAPABILITY,
									0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_LS_PREPARE_LENGTH_CAPABILITY, 0x0a),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HIBERN8TIME_CAPABILITY, 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G2_SYNC_LENGTH_CAPABILITY, 0x48),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G3_SYNC_LENGTH_CAPABILITY, 0x48),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G2_PREPARE_LENGTH_CAPABILITY,
									0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(UFS_PHY_RX_HS_G3_PREPARE_LENGTH_CAPABILITY,
									0x0f),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_CLKBUF_ENABLE(0), 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RESET_TSYNC_EN(0), 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RES_CODE(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_SERDES_BYP_EN_OUT(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_REC_DETECT_LVL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TRAN_DRVR_EMP_EN(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_CONTROL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_DATA_TCODE(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RCLK_AUXDATA_SEL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_EQ_CONTROL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_IQ_RXDET_EN(0), 0x51),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_TERM_HIGHZ_CM_AC_COUPLE(0), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_FREEZE_UP_DN(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UFS_CNTRL(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_EIGHTH(0), 0x22),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_GAIN(0), 0x0a),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_SO_GAIN(0), 0x06),
	UFS_QCOM_PHY_CAL_ENTRY(
		QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE(0), 0x35),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_TO_SO_DELAY(0), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_CLKBUF_ENABLE(1), 0x09),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RESET_TSYNC_EN(1), 0x01),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_RES_CODE(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_SERDES_BYP_EN_OUT(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_REC_DETECT_LVL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_PARRATE_REC_DETECT_IDLE_EN(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_TRAN_DRVR_EMP_EN(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_CONTROL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_AUX_DATA_TCODE(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RCLK_AUXDATA_SEL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_EQ_CONTROL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_IQ_RXDET_EN(1), 0x51),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_RX_TERM_HIGHZ_CM_AC_COUPLE(1), 0x05),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_FREEZE_UP_DN(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UFS_CNTRL(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_CDR_CONTROL_EIGHTH(1), 0x22),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_GAIN(1), 0x0a),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_SO_GAIN(1), 0x06),
	UFS_QCOM_PHY_CAL_ENTRY(
		QSERDES_RX_UCDR_SO_SATURATION_AND_ENABLE(1), 0x35),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_RX_UCDR_FO_TO_SO_DELAY(1), 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_CMN_MODE, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_IE_TRIM, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_IP_TRIM, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_CORE_CLK_IN_SYNC_SEL, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_BIAS_EN_CLKBUFLR_EN, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_TEST_UPDN_RESTRIMSTEP, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_FAUX_EN, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_LANE_MODE(0), 0x08),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_TX_LANE_MODE(1), 0x08),
};

static struct ufs_qcom_phy_calibration phy_cal_table_rate_B[] = {
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLL_CLKEPDIV, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DEC_START1, 0x98),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DEC_START2, 0x03),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START1, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START2, 0x80),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_DIV_FRAC_START3, 0x10),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP1, 0x65),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP2, 0x1E),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP3, 0x00),
	UFS_QCOM_PHY_CAL_ENTRY(QSERDES_COM_PLLLOCK_CMP_EN, 0x03),
};

static struct ufs_qcom_phy_calibration cached_phy_regs[] = {
	{QSERDES_COM_PLL_CRCTRL},
	{QSERDES_COM_PLL_CNTRL},
	{QSERDES_COM_SYSCLK_EN_SEL},
	{QSERDES_COM_SYS_CLK_CTRL},
	{QSERDES_COM_PLL_CLKEPDIV},
	{QSERDES_COM_DEC_START1},
	{QSERDES_COM_DEC_START2},
	{QSERDES_COM_DIV_FRAC_START1},
	{QSERDES_COM_DIV_FRAC_START2},
	{QSERDES_COM_DIV_FRAC_START3},
	{QSERDES_COM_PLLLOCK_CMP1},
	{QSERDES_COM_PLLLOCK_CMP2},
	{QSERDES_COM_PLLLOCK_CMP3},
	{QSERDES_COM_PLLLOCK_CMP_EN},
	{QSERDES_COM_RESETSM_CNTRL},
	{QSERDES_COM_PLL_RXTXEPCLK_EN},
	{QSERDES_RX_PWM_CNTRL1(0)},
	{QSERDES_RX_PWM_CNTRL1(1)},
	{QSERDES_RX_CDR_CONTROL(0)},
	{QSERDES_RX_CDR_CONTROL_HALF(0)},
	{QSERDES_RX_CDR_CONTROL_QUARTER(0)},
	{QSERDES_RX_CDR_CONTROL(1)},
	{QSERDES_RX_CDR_CONTROL_HALF(1)},
	{QSERDES_RX_CDR_CONTROL_QUARTER(1)},
	{QSERDES_RX_SIGDET_CNTRL(0)},
	{QSERDES_RX_SIGDET_CNTRL(1)},
	{QSERDES_RX_SIGDET_CNTRL2(0)},
	{QSERDES_RX_SIGDET_CNTRL2(1)},
	{QSERDES_RX_RX_EQ_GAIN1(0)},
	{QSERDES_RX_RX_EQ_GAIN2(0)},
	{QSERDES_RX_RX_EQ_GAIN1(1)},
	{QSERDES_RX_RX_EQ_GAIN2(1)},
	{QSERDES_COM_PLL_IP_SETI},
	{QSERDES_COM_PLL_CP_SETI},
	{QSERDES_COM_PLL_IP_SETP},
	{QSERDES_COM_PLL_CP_SETP},
	{UFS_PHY_PWM_G1_CLK_DIVIDER},
	{UFS_PHY_PWM_G2_CLK_DIVIDER},
	{UFS_PHY_PWM_G3_CLK_DIVIDER},
	{UFS_PHY_PWM_G4_CLK_DIVIDER},
	{UFS_PHY_CORECLK_PWM_G1_CLK_DIVIDER},
	{UFS_PHY_CORECLK_PWM_G2_CLK_DIVIDER},
	{UFS_PHY_CORECLK_PWM_G3_CLK_DIVIDER},
	{UFS_PHY_CORECLK_PWM_G4_CLK_DIVIDER},
	{UFS_PHY_OMC_STATUS_RDVAL},
	{UFS_PHY_LINE_RESET_TIME},
	{UFS_PHY_LINE_RESET_GRANULARITY},
	{UFS_PHY_TSYNC_RSYNC_CNTL},
	{UFS_PHY_PLL_CNTL},
	{UFS_PHY_TX_LARGE_AMP_DRV_LVL},
	{UFS_PHY_TX_SMALL_AMP_DRV_LVL},
	{UFS_PHY_TX_LARGE_AMP_POST_EMP_LVL},
	{UFS_PHY_TX_SMALL_AMP_POST_EMP_LVL},
	{UFS_PHY_CFG_CHANGE_CNT_VAL},
	{UFS_PHY_RX_SYNC_WAIT_TIME},
	{UFS_PHY_TX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY},
	{UFS_PHY_RX_MIN_SLEEP_NOCONFIG_TIME_CAPABILITY},
	{UFS_PHY_TX_MIN_STALL_NOCONFIG_TIME_CAPABILITY},
	{UFS_PHY_RX_MIN_STALL_NOCONFIG_TIME_CAPABILITY},
	{UFS_PHY_TX_MIN_SAVE_CONFIG_TIME_CAPABILITY},
	{UFS_PHY_RX_MIN_SAVE_CONFIG_TIME_CAPABILITY},
	{UFS_PHY_RX_PWM_BURST_CLOSURE_LENGTH_CAPABILITY},
	{UFS_PHY_RX_MIN_ACTIVATETIME_CAPABILITY},
	{QSERDES_RX_CDR_CONTROL3(0)},
	{QSERDES_RX_CDR_CONTROL3(1)},
	{QSERDES_COM_RES_TRIM_OFFSET},
	{QSERDES_COM_BGTC},
	{QSERDES_COM_PLL_AMP_OS},
};

static struct ufs_qcom_phy_stored_attributes cached_phy_attr[] = {
	{TX_MODE},
	{TX_HSRATE_SERIES},
	{TX_HSGEAR},
	{TX_PWMGEAR},
	{TX_AMPLITUDE},
	{TX_HS_SLEWRATE},
	{TX_SYNC_SOURCE},
	{TX_HS_PREPARE_LENGTH},
	{TX_LS_PREPARE_LENGTH},
	{TX_LCC_ENABLE},
	{TX_PWM_BURST_CLOSURE_EXTENSION},
	{TX_BYPASS_8B10B_ENABLE},
	{TX_DRIVER_POLARITY},
	{TX_HS_UNTERMINATED_LINE_DRIVE_ENABLE},
	{TX_LS_TERMINATED_LINE_DRIVE_ENABLE},
	{TX_LCC_SEQUENCER},
	{TX_MIN_ACTIVATETIME},
	{TX_PWM_G6_G7_SYNC_LENGTH},
	{RX_MODE},
	{RX_HSRATE_SERIES},
	{RX_HSGEAR},
	{RX_PWMGEAR},
	{RX_LS_TERMINATED_ENABLE},
	{RX_HS_UNTERMINATED_ENABLE},
	{RX_ENTER_HIBERN8},
	{RX_BYPASS_8B10B_ENABLE},
	{RX_TERMINATION_FORCE_ENABLE},
};

#endif
