/*
***************************************************************************
** SkFontHost_android_hy_fonthost.cpp
***************************************************************************
**
** 2012.07.17 Android JB
**
** Mobile Communication R&D Center, Hanyang
** Sangmin, Lee (TMSword) ( Mobile Communication R&D Center / Senior Researcher )
**
** This code is a program that changes the font.
**
***************************************************************************
*/
//                                                        
#ifdef CAPP_FONTS
static bool
isInitFontManager()
{
    if( !getInstance() )
    {
        HyLogif( "gFontManager is null" );
        return false;
    }
    return true;
}

void
SkFontHost::SelectDefaultTypeface( uint32_t fontIndex )
{
    if( isInitFontManager() )
        getInstance()->saveFontIndex( fontIndex );
}

SkTypeface *
SkFontHost::GetDefaultTypeface()
{
    return gDefaultNormal;
}

void
SkFontHost::UpdateDownloadFonts()
{
    if( isInitFontManager() )
        getInstance()->loadPreData( NULL, false );
}

void
SkFontHost::UpdateDefaulTypeface()
{
    if( isInitFontManager() )
        getInstance()->updateDefaultNormal();
}

//                                                                             
#if defined( CAPP_FONTS_JP )
void
SkFontHost::updateJapanFallbackFonts()
{
    if( isInitFontManager() )
        getInstance()->updateJapanFallbackFonts();
}
#endif
// CAPP_FONTS_HYFONTS_JP_END

uint32_t
SkFontHost::GetDefaultTypefaceIndex()
{
    if( isInitFontManager() )
        return getInstance()->getCurrentFontIndex();
    return 0;
}

uint32_t
SkFontHost::GetNumAllFonts()
{
    if( isInitFontManager() )
        return getInstance()->getFamilyCount();
    return 0;
}

uint32_t
SkFontHost::GetNumEmbeddedFonts()
{
    if( isInitFontManager() )
        return getInstance()->getEmbeddedFamilyCount();
    return 0;
}

const char *
SkFontHost::GetDownloadFontName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getDownloadFontName( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetFontWebFaceName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getFontWebFaceName( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetFontFullPath( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getFontFullPath( fontIndex );
    return NULL;
}

const char *
SkFontHost::GetDownloadFontSrcPath()
{
    return SYSTEM_DL_FONTAPP_SRC_DIR;
}

const char *
SkFontHost::GetDownloadFontDstPath()
{
    return SYSTEM_DL_FONTAPP_DST_DIR;
}

uint32_t
SkFontHost::GetSystemDefaultTypefaceIndex()
{
    return SYSTEM_DEFAULT_FAMILY_INDEX;
}

uint32_t
SkFontHost::GetNumNewFonts()
{
    if( isInitFontManager() )
        return getInstance()->getNumNewFonts();
    return 0;
}

const char *
SkFontHost::GetNewFontAppName( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getNewFontAppName( fontIndex );
    return NULL;
}

uint32_t
SkFontHost::GetCheckNewFont( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->getCheckNewFont( fontIndex );
    return 0;
}

bool
SkFontHost::AddNewFont( uint32_t fontIndex )
{
    if( isInitFontManager() )
        return getInstance()->addNewFont( fontIndex );
    return false;
}

void
SkFontHost::SaveNewFont()
{
    if( isInitFontManager() )
        getInstance()->saveNewFont();
}

uint32_t
SkFontHost::UpdateFontManager()
{
    if( isInitFontManager() )
    {
        LoadState state = getInstance()->updateFontManager();
        switch( state )
        {
        case load_restart: return ( uint32_t )STATE_DL_FONTAPP_RESTART;
        default: return ( uint32_t )getInstance()->searchFontApps();
        }
    }
    return STATE_DL_FONTAPP_KEEP;
}
#endif
// CAPP_FONTS_HYFONTS_END
