/*
***************************************************************************
** SkFontHost_android_hy_api.cpp
***************************************************************************
**
** 2013.10.08 Android KK
**
** Mobile Communication R&D Center, Hanyang
** Sangmin, Lee (TMSword) ( Mobile Communication R&D Center / Senior Researcher )
**
** This code is a program that changes the font.
**
***************************************************************************
*/
// CAPP_FONTS_HYFONTS Global Font Manager
#ifdef ON_CAPP_FONTS  // This added to disable CAPP_FONTS to  avoid crash for fonts added in system_fonts.xml without serif on TOP.

#ifdef CAPP_FONTS
#include <ft2build.h>
#include FT_FREETYPE_H
#include FT_TRUETYPE_TABLES_H

typedef uint32_t ulong;

#define NO_SUCH_FILE_OR_DIRECTORY 2
#define PERMISSION_DENIED 13

bool
no_such_file()
{
    if( errno == NO_SUCH_FILE_OR_DIRECTORY ) // No such file or directory.
        return true;
    return false;
}

bool
permission_denied()
{
    if( errno == PERMISSION_DENIED )
        return true;
    return false;
}

#define DEFAULT_SANS_NAMES_MAX 5
static const char *
DEFAULT_SANS_NAMES[] =
{
    "sans-serif",
    "arial",
    "helvetica",
    "tahoma",
    "verdana",
    NULL
};

typedef struct _skhycertified
{
    ulong key0;
    ulong key1;
    char * key1_str;
    ulong key2;
    char * key2_str;
    ulong key3;
    char * key3_str;
    ulong key4;
    ulong key5;
    ulong key6;
    ulong key7;
    char * key7_str;

} skhycertified;

static const ulong __key_ck_val = 0x68796374; // Warning : Do not change.
static const ulong __tag_ck_val = 0x34234291; // Warning : Do not change.

ulong
__gen1( char * _key_str )
{
    char * c = _key_str;
    ulong key = 5381;
    while( c && *c )
        key = ( ( key << 5 ) + key ) + *c++;
    return key;
}

ulong
__gen2( char * _key_str1, char * _key_str2, char * _key_str3 )
{
    ulong key;
    key = __gen1( _key_str1 );
    key += __gen1( _key_str2 );
    key += __gen1( _key_str3 );
    key += 1607;
    return key;
}

static ulong
__key()
{
    return ( __key_ck_val );
}

static ulong
__tag()
{
    return ( __tag_ck_val );
}

static bool
__certified_dat( skhycertified * _dat )
{
    if( _dat->key0 != __tag() )
        goto ERROR0;

    if( _dat->key5 != ( _dat->key4 + __key() ) )
        goto ERROR0;

    if( !_dat->key1_str || !_dat->key2_str || !_dat->key3_str )
        goto ERROR0;

    if( _dat->key6 != ( __gen2( _dat->key1_str, _dat->key2_str, _dat->key3_str ) + __key() ) )
        goto ERROR0;

    if( _dat->key7_str == NULL )
        goto ERROR0;

    return true;

ERROR0:
    return false;
}

static bool
__certified_cmp_fnt( skhycertified * _dat, const char * fullpath )
{
    FT_Library lfeng = NULL;
    FT_Face lface = NULL;
    FT_Error err = FT_Init_FreeType( &lfeng );
    TT_Header * ttHeader = NULL;

    if( err )
    {
        goto FAILED0;
    }

    if( ( err = FT_New_Face( lfeng, fullpath, 0, &lface ) ) != 0 )
    {
        goto FAILED0;
    }

    if( strcmp( _dat->key2_str, lface->family_name ) )
    {
        goto FAILED0;
    }

    if( strcmp( _dat->key3_str, lface->style_name ) )
    {
        goto FAILED0;
    }

    if( _dat->key6 != ( __gen2( _dat->key1_str, lface->family_name, lface->style_name ) + __key() ) )
    {
        goto FAILED0;
    }

    if( ( ttHeader = ( TT_Header * )FT_Get_Sfnt_Table( lface, ft_sfnt_head ) ) == NULL )
    {
        goto FAILED0;
    }

    if( _dat->key4 != ( ulong )ttHeader->CheckSum_Adjust )
    {
        goto FAILED0;
    }

    if( _dat->key5 != ( ulong )ttHeader->CheckSum_Adjust + __key() )
    {
        goto FAILED0;
    }

    if( lfeng )
        FT_Done_FreeType( lfeng );
    return true;

FAILED0:
    if( lfeng )
        FT_Done_FreeType( lfeng );
    return false;
}

static bool
__loading_dat( SkStream * dat, skhycertified * _dat )
{
    if( !dat || !_dat )
        return false;

    memset( _dat, 0x00, sizeof( skhycertified ) );

    _dat->key0 = dat->readU32();

    _dat->key1 = dat->readU32();
    if( ( _dat->key1_str = ( char * )calloc( 1, _dat->key1 + 1 ) ) == NULL )
        goto ERROR0;
    dat->read( _dat->key1_str, _dat->key1 );

    _dat->key2 = dat->readU32();
    if( ( _dat->key2_str = ( char * )calloc( 1, _dat->key2 + 1 ) ) == NULL )
        goto ERROR0;
    dat->read( _dat->key2_str, _dat->key2 );

    _dat->key3 = dat->readU32();
    if( ( _dat->key3_str = ( char * )calloc( 1, _dat->key3 + 1 ) ) == NULL )
        goto ERROR0;
    dat->read( _dat->key3_str, _dat->key3 );

    _dat->key4 = dat->readU32();
    _dat->key5 = dat->readU32();
    _dat->key6 = dat->readU32();

    _dat->key7 = dat->readU32();
    if( ( _dat->key7_str = ( char * )calloc( 1, _dat->key7 + 1 ) ) == NULL )
        goto ERROR0;
    dat->read( _dat->key7_str, _dat->key7 );
    return true;

ERROR0:
    return false;
}

static void
__done_dat( skhycertified * _dat )
{
    if( _dat->key1_str )
        free( _dat->key1_str );

    if( _dat->key2_str )
        free( _dat->key2_str );

    if( _dat->key3_str )
        free( _dat->key3_str );

    if( _dat->key7_str )
        free( _dat->key7_str );

    _dat->key1_str = NULL;
    _dat->key2_str = NULL;
    _dat->key3_str = NULL;
    _dat->key7_str = NULL;
}

static bool
__certified_check( skhycertified * _dat, SkStream * dat, const char * fullpath )
{
    if( __loading_dat( dat, _dat ) == false )
        goto ERROR0;

    if( __certified_dat( _dat ) == false )
        goto ERROR0;

    if( __certified_cmp_fnt( _dat, fullpath ) == false )
        goto ERROR0;

    return true;

ERROR0:
    __done_dat( _dat );
    return false;
}

bool
isDefaultSansSerifFamily( SkTDArray<const char*> names )
{
    if( names.count() < DEFAULT_SANS_NAMES_MAX )
        return false;

    for( int i = 0 ; i < DEFAULT_SANS_NAMES_MAX ; i++ )
    {
        for( int j = 0 ; j < names.count() ; j++ )
        {
            if( names[j] == NULL )
                continue;

            if( !strncmp( DEFAULT_SANS_NAMES[i], names[j], strlen( names[j] ) ) )
                goto FIND0;
        }

    NOT_EXIST:
        return false;

    FIND0:
        continue;
    }
    return true; // passed, SansSerif Family.
}

#if 0
static bool
getNameAndStyleDlFont( const char path[], SkString * name, SkTypeface::Style * style, bool * isFixedWidth, bool isExpected )
{
    SkMMAPStream stream( path );

    if( stream.getLength() > 0 )
        return find_name_and_attributes( &stream, name, style, isFixedWidth );
    else
    {
        SkFILEStream stream( path );

        if (stream.getLength() > 0)
            return find_name_and_attributes( &stream, name, style, isFixedWidth );
    }

    if( isExpected )
        SkDebugf("---- failed to open <%s> as a font\n", path );

    return false;
}
#endif

static SkStream *
openReadStream( const char * path )
{
    SkStream * stream = NULL;

    if( !path )
        goto ERROR1;

    stream = SkStream::NewFromFile( path );

    if( !stream )
        goto ERROR2;

    return stream;

ERROR2:
    if( no_such_file() || permission_denied() )
        HyLogi( "%s, %s (%d)", path, strerror( errno ), errno );
    else
        HyLogef( "%s, %s (%d)", path, strerror( errno ), errno );
    goto ERROR0;

ERROR1:
    HyLogef( "'path' is null." );

ERROR0:
    return NULL;
}

static SkFILEWStream *
openWriteStream( const char * path )
{
    SkFILEWStream * stream = NULL;

    if( !path )
        goto ERROR1;

    stream = SkNEW_ARGS( SkFILEWStream, ( path ) );

    if( !stream->isValid() )
        goto ERROR2;

    return stream;

ERROR2:
    SkDELETE( stream );
    stream = NULL;

    if( permission_denied() )
        HyLogi( "%s, %s (%d)", path, strerror( errno ), errno );
    else
        HyLogef( "%s, %s (%d)", path, strerror( errno ), errno );
    goto ERROR0;

ERROR1:
    HyLogef( "'path' is null." );

ERROR0:
    return NULL;
}

static bool
saveFontConfigV2( uint32_t fontIndex, const char * wfaceName )
{
    SkFILEWStream * stream = openWriteStream( SYSTEM_FONTCONFIG_FILE );
    SkString permission;

    if( !stream )
    {
        if( permission_denied() )
            goto SKIP_ERROR0;
        goto ERROR0;
    }

    if( stream->write32( fontIndex ) == false )
    {
        HyLogef( "write fontIndex(%d)", fontIndex );
        goto ERROR0;
    }

    if( !wfaceName )
    {
        HyLogef( "write fontIndex(%d)", fontIndex );
        goto ERROR0;
    }

    if( stream->write( wfaceName, WEBFACE_NAME_LEN ) == false )
    {
        HyLogef( "write fontIndex(%d)", fontIndex );
        goto ERROR0;
    }

    SkDELETE( stream );

    permission.set( SYSTEM_FONT_PERMISSION_SET );
    permission.append( SYSTEM_FONTCONFIG_FILE );
    system( permission.c_str() );

    HyLogi( "Font Index (%d) saved.", fontIndex );
    return true;

SKIP_ERROR0:
    return false;

ERROR0:
    if( stream )
        SkDELETE( stream );
    return false;
}

static uint32_t
readFontConfigV2( char * wfaceName )
{
    SkStream * stream = openReadStream( SYSTEM_FONTCONFIG_FILE );
    uint32_t fontIndex = SYSTEM_DEFAULT_FAMILY_INDEX;

    if( !stream )
    {
        // saveFontConfig( fontIndex );
        return fontIndex;
    }

    fontIndex = stream->readU32();
    if( wfaceName != NULL )
        stream->read( wfaceName, WEBFACE_NAME_LEN );
    SkDELETE( stream );
    return fontIndex;
}

static uint32_t
readFontConfig()
{
    SkStream * stream = openReadStream( SYSTEM_FONTCONFIG_FILE );
    uint32_t fontIndex = SYSTEM_DEFAULT_FAMILY_INDEX;

    if( !stream )
    {
        // saveFontConfig( fontIndex );
        return fontIndex;
    }

    fontIndex = stream->readU32();
    SkDELETE( stream );
    return fontIndex;
}

static void
convertLowerString( char * s )
{
    char * str = s;
    while( *str != 0x00 )
    {
        if( *str >= 0x41 && *str <= 0x5A )
            *str += 32;
        str++;
    }
}

static bool
compareDefaultSansName( const char * name)
{
    if( !strncmp( "sans", name, strlen("sans") ) ||
        !strncmp( DEFAULT_SANS_NAMES[0], name, strlen(DEFAULT_SANS_NAMES[0]) ) ||
        !strncmp( DEFAULT_SANS_NAMES[1], name, strlen(DEFAULT_SANS_NAMES[1]) ) ||
        !strncmp( DEFAULT_SANS_NAMES[2], name, strlen(DEFAULT_SANS_NAMES[2]) ) ||
        !strncmp( DEFAULT_SANS_NAMES[3], name, strlen(DEFAULT_SANS_NAMES[3]) ) ||
        !strncmp( DEFAULT_SANS_NAMES[4], name, strlen(DEFAULT_SANS_NAMES[4]) ) )
    {
        return true;
    }
    return false;
}

static bool
compareSystemFamilyName( const char * familyName )
{
    int len = strlen( familyName );
    char * lowerName = NULL;
    bool ret = false;
    if( len <= 0 || len > 12 )
        return ret;

    lowerName = ( char * )calloc( len+1, 1 );
    strncpy( lowerName, familyName, len );
    convertLowerString( lowerName );
    ret = compareDefaultSansName( lowerName);
    if( lowerName )
    {
        free( lowerName );
    }
    return ret;
}
#endif
// CAPP_FONTS_HYFONTS_END

#endif /* ON_CAPP_FONTS */
