/*
***************************************************************************
** SkTypeface_hy.cpp
***************************************************************************
**
** 2013.10.08 Android KK
**
** Mobile Communication R&D Center, Hanyang
** Sangmin, Lee (TMSword) ( Mobile Communication R&D Center / Senior Researcher )
**
** This code is a program that changes the font.
**
***************************************************************************
*/
// CAPP_FONTS_HYFONTS Global Font Manager
#ifdef ON_CAPP_FONTS  // This added to disable CAPP_FONTS to  avoid crash for fonts added in system_fonts.xml without serif on TOP.
#ifdef CAPP_FONTS
SkTypeface* SkTypeface::GetDefaultTypeface( Style style )
{
    static const uint32_t FONT_STYLE_COUNT = 4;
    static SkTypeface * gDefaultTypefaces[FONT_STYLE_COUNT];
    SkASSERT( ( unsigned )style < FONT_STYLE_COUNT );

    style = ( Style )( style & 0x03 );

    if( NULL == gDefaultTypefaces[style] )
        gDefaultTypefaces[style] = SkFontHost::CreateTypeface( NULL, NULL, style );

    if (NULL == gDefaultTypefaces[style]) {
        gDefaultTypefaces[style] = SkNEW(SkEmptyTypeface);
    }

    SkTypeface * curDefaultTypeface = SkFontHost::GetDefaultTypeface( style );
    return ( curDefaultTypeface ? curDefaultTypeface : gDefaultTypefaces[style] );
}
#endif
// CAPP_FONTS_HYFONTS_END

#endif /* ON_CAPP_FONTS */