
#ifndef CSSThread_h
#define CSSThread_h


#include "config.h"
#if USE(FAST_CSS)

#include <wtf/Threading.h>



namespace WebCore {

	class CSSThread;
	class CSSThreadManager;
	class CSSStyleSelector;
	class CSSSelector;

	struct CSSThreadData
	{		
		CSSSelector* sel;
		volatile int lock;
		bool result;
	};

	class CSSThread
	{
	public:
		CSSThread(CSSThread *prev);
		CSSThread *getNext() { return m_next; }
		void start();
		void resume();
		void runLoop();
		void runLoopBody();
		void setData(CSSStyleSelector *styleSelector, CSSThreadData *data, int count) 
		{ 
			m_styleSelector = styleSelector;
			m_cssThreadData = data; 
			m_count = count;
		}


	private:
		void waitMainThread();		

		ThreadIdentifier m_tid;
		volatile bool m_canContinue; // false when CSSThread should wait for main thread
		Mutex m_mutex; // for thread-safe accessing of m_shouldWait;
		ThreadCondition m_condition; // condition for m_shouldWait;
		CSSThread *m_next;
		CSSStyleSelector *m_styleSelector;
		CSSThreadData *m_cssThreadData;
		int m_count;
	};

	class CSSThreadManager
	{
	public:
		static CSSThreadManager *getInstance();
		void doCheckSelector(CSSStyleSelector* selector, CSSThreadData *data, int count);
		void notifyMainThread();
		void sync();
		
	private:
		friend class CSSThread;
		CSSThreadManager(int numThreads);			
		CSSThread *m_threads;
		volatile int m_numIdleThreads;
		volatile const int m_numThreads;
		Mutex m_mutex; // mutex for m_numIdleThreads
		ThreadCondition m_condition;
		volatile int m_numRunningThreads;
	};

} // namespace WebCore

#endif

#endif //ifndef CSSThread_h
