/* Copyright (c) 2009, Code Aurora Forum. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 and
 * only version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 *
 */

#ifndef ISX005_REG_H
#define ISX005_REG_H

#include "isx005.h"

#if defined(CONFIG_MACH_MSM7X27_THUNDERG) || defined(CONFIG_MACH_MSM7X27_THUNDERA)
static struct isx005_register_address_value_pair const
init_reg_settings_array[] = {

	// ISX005-0 (FW 2005)
	//   Parallel   8.8fps
	//        PLL   256MHz
	//        DCK    Preview : 64MHz, Capture : 64MHz
	//
	// inifile
	// size address data
	//

	{0x00FC, 0x1f   ,BYTE_LEN},     //
	{0x000b, 0x02, BYTE_LEN},		// PLL_CKSEL    
	{0x3208, 0x01   ,BYTE_LEN},		// [LGE_CODE] FAST MODE CHANGE - eunyoung.shin@lge.com 2010-07-13 
	{0x0009, 0x06   ,BYTE_LEN},		// INCK_SET 
	{0x02C7, 0x01, BYTE_LEN},		// SRCCK_DIV 
	{0x0038, 0x0D  ,BYTE_LEN},		// sync masking on off   - for QCT      
	{0x02B8, 0x10, BYTE_LEN},		// VIF_CLKCONFIG1    - still                            
	{0x02B9, 0x10, BYTE_LEN}, 		// VIF_CLKCONFIG2    - prevew  10 ->64Mhz, 11->32Mhz    
	{0x02BA, 0x12, BYTE_LEN}, 		// VIF_CLKCONFIG3    
	{0x02BB, 0x13, BYTE_LEN}, 		// VIF_CLKCONFIG4    
	{0x02BC, 0x11, BYTE_LEN}, 		// VIF_CLKCONFIG5    
	{0x02BD, 0x12, BYTE_LEN}, 		// VIF_CLKCONFIG6    
	{0x02BE, 0x13, BYTE_LEN}, 		// VIF_CLKCONFIG7    
	{0x02C0, 0x10, BYTE_LEN}, 		// VIF_CLKCONFIG9    
	{0x02C1, 0x30, BYTE_LEN}, 		// VIF_CLKCONFIG10   
	{0x4C10, 0x11, BYTE_LEN}, 		// VIF_CLKCONFIG13   
	{0x0348, 0x30, BYTE_LEN}, 		// VIF_CLKCONFIG_HD1 
	{0x034A, 0x11, BYTE_LEN},		// VIF_CLKCONFIG_HD3 
	{0x034C, 0x30, BYTE_LEN},		// VIF_CLKCONFIG_HD5 
	{0x4044, 0x800C, WORD_LEN},		// 1SECCLK_ALL
	{0x4046, 0x1815, WORD_LEN},		// 1SECCLK_HD_1_1
	{0x402B, 0x59, BYTE_LEN},		// FPS_SENSALL
	{0x402C, 0x9600, WORD_LEN},		// FPS_SENS_HD_1_1
	{0x4060, 0x800C, WORD_LEN},		// PIXEL_CLK
	{0x4062, 0x1815, WORD_LEN},		// PIXEL_CLK_HD_1_1
	{0x403E, 0x001E, WORD_LEN},		// FLSHT50
	{0x4074, 0x0521, WORD_LEN},		// FLSHT50_HD_1_1
	{0x4040, 0xF21C, WORD_LEN},		// FLSHT60
	{0x4076, 0xF71F, WORD_LEN},		// FLSHT60_HD_1_1
	{0x02A2, 0x0000, WORD_LEN},		// VADJ_SENS_1_1
	{0x0364, 0x2100, WORD_LEN},		// VADJ_SENS_HD_1_1
	{0x02A4, 0x0700, WORD_LEN},		// VADJ_SENS_1_2
	{0x02A6, 0x0300, WORD_LEN},		// VADJ_SENS_1_4
	{0x02A8, 0x0000, WORD_LEN},		// VADJ_SENS_1_8
	{0x4C14, 0xE001, WORD_LEN},		// FLC_OPD_HEIGHT_NORMAL_1_1
	{0x4C1C, 0x4003, WORD_LEN},		// FLC_OPD_HEIGHT_HD_1_1
	{0x4C16, 0xE001, WORD_LEN},		// FLC_OPD_HEIGHT_NORMAL_1_2
	{0x4C18, 0x8001, WORD_LEN},		// FLC_OPD_HEIGHT_NORMAL_1_4
	{0x4C1A, 0xC000, WORD_LEN},		// FLC_OPD_HEIGHT_NORMAL_1_8
	{0x000E, 0x12, BYTE_LEN},	  	// GPIO_FUNCSEL IRQ disable & UART enable
	{0x02CD, 0x03, BYTE_LEN},			//[LGE_CODE] Drive Strength - 2mA for RF sensortivity - eunyoung.shin@lge.com 2010-07-13 
	{0x003A, 0x0002 ,WORD_LEN},   // CAM OUTPUT DATA Format
	{0x001C, 0x00   ,BYTE_LEN},   	// OUTPUT FORMAT MONITOR MODE
#if defined (CONFIG_ISX005_ROTATION_180)
	{0x001F, 0x03   ,BYTE_LEN},	    //READVECT_MONI
#else
	{0x001F, 0x00	,BYTE_LEN},		//READVECT_MONI
#endif
	{0x0022, 0x8002 ,WORD_LEN},		//640*480 monitoring SIZE H
	{0x0028, 0xE001 ,WORD_LEN},		//640*480 monitoring SIZE V
	{0x034F,0x01,BYTE_LEN},    		// VEXPAND_F
	/*LGE_START*/
	{0xB000,0xBCBC,WORD_LEN}, // defect calibration additional code - fix bad pixel - eunyoung.shin@lge.com 2010-07-19
	{0xB002,0x2130,WORD_LEN}, 
	{0xB004,0x5580,WORD_LEN},
	{0xB006,0xAE00,WORD_LEN}, 
	{0xB008,0x75F1,WORD_LEN}, 
	{0xB00A,0xE0F8,WORD_LEN}, 
	{0xB00C,0x55D8,WORD_LEN}, 
	{0xB00E,0x9500,WORD_LEN}, 
	{0xB010,0x76F1,WORD_LEN}, 
	{0xB012,0x3AFD,WORD_LEN}, 
	{0xB014,0x0000,WORD_LEN}, 
	{0xB016,0x0000,WORD_LEN}, 
	{0xB018,0x0000,WORD_LEN}, 
	{0xB01A,0x0000,WORD_LEN}, 
	{0xB01C,0x0000,WORD_LEN}, 
	{0xB01E,0x0000,WORD_LEN}, 
	{0xB020,0x0000,WORD_LEN}, 
	{0xB022,0x0000,WORD_LEN}, 
	{0xB024,0x0000,WORD_LEN}, 
	{0xB026,0x0000,WORD_LEN}, 
	{0xB028,0x0000,WORD_LEN}, 
	{0xB02A,0x0000,WORD_LEN}, 
	{0xB02C,0x0000,WORD_LEN}, 
	{0xB02E,0x0000,WORD_LEN}, 
	{0xB030,0x0000,WORD_LEN}, 
	{0xB032,0x0000,WORD_LEN}, 
	{0xB034,0x0000,WORD_LEN}, 
	{0xB036,0x0000,WORD_LEN}, 
	{0xB038,0x0000,WORD_LEN}, 
	{0xB03A,0x0000,WORD_LEN}, 
	{0xB03C,0x0000,WORD_LEN}, 
	{0xB03E,0x0000,WORD_LEN}, 
	{0xB040,0x0000,WORD_LEN}, 
	{0xB042,0x0000,WORD_LEN}, 
	{0xB044,0x8FF6,WORD_LEN}, 
	{0xB046,0xAEFD,WORD_LEN}, 
	{0xB048,0x00F0,WORD_LEN}, 
	{0xB04A,0x08F8,WORD_LEN}, 
	{0xB04C,0x8AF6,WORD_LEN}, 
	{0xB04E,0x1AFF,WORD_LEN}, 
	{0xB050,0x8AF6,WORD_LEN}, 
	{0xB052,0x50F9,WORD_LEN}, 
	{0xB054,0x00F0,WORD_LEN}, 
	{0xB056,0x16F8,WORD_LEN}, 
	{0xB058,0x89F6,WORD_LEN}, 
	{0xB05A,0xC0FA,WORD_LEN}, 
	{0xB05C,0x80B4,WORD_LEN}, 
	{0xB05E,0x0020,WORD_LEN}, 
	{0xB060,0x064A,WORD_LEN}, 
	{0xB062,0x0749,WORD_LEN}, 
	{0xB064,0x8300,WORD_LEN}, 
	{0xB066,0x5B18,WORD_LEN}, 
	{0xB068,0x9B69,WORD_LEN}, 
	{0xB06A,0x5B05,WORD_LEN}, 
	{0xB06C,0x5B0D,WORD_LEN}, 
	{0xB06E,0x4700,WORD_LEN}, 
	{0xB070,0xD353,WORD_LEN},
	{0xB072,0x0130,WORD_LEN},
	{0xB074,0x0A28,WORD_LEN}, 
	{0xB076,0xF5DB,WORD_LEN}, 
	{0xB078,0x80BC,WORD_LEN}, 
	{0xB07A,0xF746,WORD_LEN}, 
	{0xB07C,0x1C01,WORD_LEN}, 
	{0xB07E,0x1800,WORD_LEN}, 
	{0xB080,0x40EC,WORD_LEN}, 
	{0xB082,0x3000,WORD_LEN}, 
	{0xB084,0x00B5,WORD_LEN}, 
	{0xB086,0x0548,WORD_LEN}, 
	{0xB088,0x8079,WORD_LEN}, 
	{0xB08A,0x0128,WORD_LEN}, 
	{0xB08C,0x03D1,WORD_LEN}, 
	{0xB08E,0x0448,WORD_LEN}, 
	{0xB090,0x0078,WORD_LEN}, 
	{0xB092,0x0228,WORD_LEN}, 
	{0xB094,0x01D1,WORD_LEN}, 
	{0xB096,0x00F0,WORD_LEN}, 
	{0xB098,0x05F8,WORD_LEN}, 
	{0xB09A,0x00BD,WORD_LEN}, 
	{0xB09C,0x7C2F,WORD_LEN}, 
	{0xB09E,0x1800,WORD_LEN}, 
	{0xB0A0,0xAC3C,WORD_LEN}, 
	{0xB0A2,0x1800,WORD_LEN}, 
	{0xB0A4,0xF0B4,WORD_LEN}, 
	{0xB0A6,0x0021,WORD_LEN}, 
	{0xB0A8,0x1948,WORD_LEN}, 
	{0xB0AA,0x1A4A,WORD_LEN}, 
	{0xB0AC,0x0478,WORD_LEN}, 
	{0xB0AE,0xC078,WORD_LEN}, 
	{0xB0B0,0x1768,WORD_LEN}, 
	{0xB0B2,0x164D,WORD_LEN}, 
	{0xB0B4,0xC307,WORD_LEN}, 
	{0xB0B6,0xDB0F,WORD_LEN}, 
	{0xB0B8,0x4800,WORD_LEN}, 
	{0xB0BA,0x285A,WORD_LEN}, 
	{0xB0BC,0x002C,WORD_LEN}, 
	{0xB0BE,0x17D0,WORD_LEN}, 
	{0xB0C0,0x7A69,WORD_LEN}, 
	{0xB0C2,0x5202,WORD_LEN}, 
	{0xB0C4,0xD20F,WORD_LEN}, 
	{0xB0C6,0x012A,WORD_LEN}, 
	{0xB0C8,0x12D1,WORD_LEN}, 
	{0xB0CA,0x134E,WORD_LEN}, 
	{0xB0CC,0x8A00,WORD_LEN}, 
	{0xB0CE,0x9219,WORD_LEN}, 
	{0xB0D0,0xD27E,WORD_LEN}, 
	{0xB0D2,0x012A,WORD_LEN}, 
	{0xB0D4,0x0CD1,WORD_LEN}, 
	{0xB0D6,0x002B,WORD_LEN}, 
	{0xB0D8,0x03D0,WORD_LEN}, 
	{0xB0DA,0x8207,WORD_LEN}, 
	{0xB0DC,0x08D1,WORD_LEN}, 
	{0xB0DE,0x0230,WORD_LEN}, 
	{0xB0E0,0x04E0,WORD_LEN}, 
	{0xB0E2,0x8207,WORD_LEN}, 
	{0xB0E4,0x04D0,WORD_LEN}, 
	{0xB0E6,0x0128,WORD_LEN}, 
	{0xB0E8,0x02DD,WORD_LEN}, 
	{0xB0EA,0x0238,WORD_LEN}, 
	{0xB0EC,0x0004,WORD_LEN}, 
	{0xB0EE,0x000C,WORD_LEN}, 
	{0xB0F0,0x094E,WORD_LEN}, 
	{0xB0F2,0x8A00,WORD_LEN}, 
	{0xB0F4,0x9219,WORD_LEN}, 
	{0xB0F6,0x9669,WORD_LEN}, 
	{0xB0F8,0xF60A,WORD_LEN}, 
	{0xB0FA,0xF602,WORD_LEN}, 
	{0xB0FC,0x3043,WORD_LEN}, 
	{0xB0FE,0x9061,WORD_LEN}, 
	{0xB100,0x0131,WORD_LEN}, 
	{0xB102,0x0A29,WORD_LEN}, 
	{0xB104,0xD8DB,WORD_LEN}, 
	{0xB106,0xF0BC,WORD_LEN}, 
	{0xB108,0xF746,WORD_LEN}, 
	{0xB10A,0x0000,WORD_LEN}, 
	{0xB10C,0x1C01,WORD_LEN}, 
	{0xB10E,0x1800,WORD_LEN}, 
	{0xB110,0xB23C,WORD_LEN}, 
	{0xB112,0x1800,WORD_LEN}, 
	{0xB114,0x5819,WORD_LEN}, 
	{0xB116,0x1800,WORD_LEN}, 
	{0xB118,0x40EC,WORD_LEN}, 
	{0xB11A,0x3000,WORD_LEN}, 
	/*LGE_END*/
	{0x0009, 0x16, BYTE_LEN },		// INCK_SET     
  
};

#else

static struct isx005_register_address_value_pair const
init_reg_settings_array[] = {


	// ISX005 Start release 0900909  LEE
	// 1106 Pclk masking off
	// Only PLL
	// Input=24,out=Preview 27Mhz, Capture 54Mhz
	// YCorder CbYCrY
	// USER Ctrl
	//Preview size 640*480

	{0x00FC, 0xFF   ,BYTE_LEN},             //   
	{0x000b, 0x01   ,BYTE_LEN},             // PLL_CKSEL     
	{0x3208, 0x01   ,BYTE_LEN},		// [LGE_CODE] FAST MODE CHANGE - eunyoung.shin@lge.com 2010-07-13 	
	{0x0009, 0x06   ,BYTE_LEN},             // INCK_SET          
	{0x02C7, 0x01   ,BYTE_LEN},             // SRCCK_DIV 
	{0x0038, 0x0D   ,BYTE_LEN},             // sync masking on off        
	{0x02B8, 0x10   ,BYTE_LEN},             // VIF_CLKCONFIG1    
	{0x02B9, 0x11   ,BYTE_LEN},             // VIF_CLKCONFIG2    
	{0x02BA, 0x12   ,BYTE_LEN},             // VIF_CLKCONFIG3    
	{0x02BB, 0x13   ,BYTE_LEN},             // VIF_CLKCONFIG4    
	{0x02BC, 0x11   ,BYTE_LEN},             // VIF_CLKCONFIG5    
	{0x02BD, 0x12   ,BYTE_LEN},             // VIF_CLKCONFIG6    
	{0x02BE, 0x13   ,BYTE_LEN},             // VIF_CLKCONFIG7     
	{0x02C0, 0x10   ,BYTE_LEN},             // VIF_CLKCONFIG9    
	{0x02C1, 0x30   ,BYTE_LEN},             // VIF_CLKCONFIG10   
	{0x4C10, 0x11   ,BYTE_LEN},             // VIF_CLKCONFIG13     
	{0x0348, 0x30   ,BYTE_LEN},             // VIF_CLKCONFIG_HD1 
	{0x034A, 0x11   ,BYTE_LEN},             // VIF_CLKCONFIG_HD3 
	{0x034C, 0x30   ,BYTE_LEN},             // VIF_CLKCONFIG_HD5 
	{0x4044, 0x8C0A ,WORD_LEN},             // 1SECCLK_ALL
	{0x4046, 0x1815 ,WORD_LEN},             // 1SECCLK_HD_1_1
	{0x402B, 0x4B   ,BYTE_LEN},             // FPS_SENSALL
	{0x4044, 0x8C0A ,WORD_LEN},             // 1SECCLK_ALL
	{0x4046, 0x1815 ,WORD_LEN},             // 1SECCLK_HD_1_1
	{0x402B, 0x4B   ,BYTE_LEN},             // FPS_SENSALL
	{0x402C, 0x9600 ,WORD_LEN},             // FPS_SENS_HD_1_1
	{0x4060, 0x8C0A ,WORD_LEN},             // PIXEL_CLK
	{0x4062, 0x1815 ,WORD_LEN},             // PIXEL_CLK_HD_1_1
	{0x403E, 0x041D ,WORD_LEN},             // FLSHT50
	{0x4074, 0x0421 ,WORD_LEN},             // FLSHT50_HD_1_1
	{0x4040, 0xF71B ,WORD_LEN},             // FLSHT60
	{0x4076, 0xF71F ,WORD_LEN},             // FLSHT60_HD_1_1
	{0x02A2, 0x2100 ,WORD_LEN},             // VADJ_SENS_1_1
	{0x0364, 0x2100 ,WORD_LEN},             // VADJ_SENS_HD_1_1
	{0x02A4, 0x1000 ,WORD_LEN},             // VADJ_SENS_1_2
	{0x02A6, 0x0800 ,WORD_LEN},             // VADJ_SENS_1_4
	{0x02A8, 0x0000 ,WORD_LEN},             // VADJ_SENS_1_8
	{0x4C14, 0xA001 ,WORD_LEN},             // FLC_OPD_HEIGHT_NORMAL_1_1
	{0x4C1C, 0x4003 ,WORD_LEN},             // FLC_OPD_HEIGHT_HD_1_1
	{0x4C16, 0xA001 ,WORD_LEN},             // FLC_OPD_HEIGHT_NORMAL_1_2
	{0x4C18, 0x8001 ,WORD_LEN},             // FLC_OPD_HEIGHT_NORMAL_1_4
	{0x4C1A, 0xC000 ,WORD_LEN},             // FLC_OPD_HEIGHT_NORMAL_1_8
	{0x000E, 0x12   ,BYTE_LEN},             // GPIO_FUNCSEL IRQ disable & UART enable
	{0x3400, 0x07   ,BYTE_LEN},    //
	{0x3402, 0x00   ,BYTE_LEN},    //
	{0x003A, 0x0002 ,WORD_LEN},   // CAM OUTPUT DATA Format
	/*LGE_START*/
	{0xB000,0xBCBC,WORD_LEN},	// defect calibration additional code - fix bad pixel - eunyoung.shin@lge.com 2010-07-19
	{0xB002,0x2130,WORD_LEN}, 
	{0xB004,0x5580,WORD_LEN},
	{0xB006,0xAE00,WORD_LEN}, 
	{0xB008,0x75F1,WORD_LEN}, 
	{0xB00A,0xE0F8,WORD_LEN}, 
	{0xB00C,0x55D8,WORD_LEN}, 
	{0xB00E,0x9500,WORD_LEN}, 
	{0xB010,0x76F1,WORD_LEN}, 
	{0xB012,0x3AFD,WORD_LEN}, 
	{0xB014,0x0000,WORD_LEN}, 
	{0xB016,0x0000,WORD_LEN}, 
	{0xB018,0x0000,WORD_LEN}, 
	{0xB01A,0x0000,WORD_LEN}, 
	{0xB01C,0x0000,WORD_LEN}, 
	{0xB01E,0x0000,WORD_LEN}, 
	{0xB020,0x0000,WORD_LEN}, 
	{0xB022,0x0000,WORD_LEN}, 
	{0xB024,0x0000,WORD_LEN}, 
	{0xB026,0x0000,WORD_LEN}, 
	{0xB028,0x0000,WORD_LEN}, 
	{0xB02A,0x0000,WORD_LEN}, 
	{0xB02C,0x0000,WORD_LEN}, 
	{0xB02E,0x0000,WORD_LEN}, 
	{0xB030,0x0000,WORD_LEN}, 
	{0xB032,0x0000,WORD_LEN}, 
	{0xB034,0x0000,WORD_LEN}, 
	{0xB036,0x0000,WORD_LEN}, 
	{0xB038,0x0000,WORD_LEN}, 
	{0xB03A,0x0000,WORD_LEN}, 
	{0xB03C,0x0000,WORD_LEN}, 
	{0xB03E,0x0000,WORD_LEN}, 
	{0xB040,0x0000,WORD_LEN}, 
	{0xB042,0x0000,WORD_LEN}, 
	{0xB044,0x8FF6,WORD_LEN}, 
	{0xB046,0xAEFD,WORD_LEN}, 
	{0xB048,0x00F0,WORD_LEN}, 
	{0xB04A,0x08F8,WORD_LEN}, 
	{0xB04C,0x8AF6,WORD_LEN}, 
	{0xB04E,0x1AFF,WORD_LEN}, 
	{0xB050,0x8AF6,WORD_LEN}, 
	{0xB052,0x50F9,WORD_LEN}, 
	{0xB054,0x00F0,WORD_LEN}, 
	{0xB056,0x16F8,WORD_LEN}, 
	{0xB058,0x89F6,WORD_LEN}, 
	{0xB05A,0xC0FA,WORD_LEN}, 
	{0xB05C,0x80B4,WORD_LEN}, 
	{0xB05E,0x0020,WORD_LEN}, 
	{0xB060,0x064A,WORD_LEN}, 
	{0xB062,0x0749,WORD_LEN}, 
	{0xB064,0x8300,WORD_LEN}, 
	{0xB066,0x5B18,WORD_LEN}, 
	{0xB068,0x9B69,WORD_LEN}, 
	{0xB06A,0x5B05,WORD_LEN}, 
	{0xB06C,0x5B0D,WORD_LEN}, 
	{0xB06E,0x4700,WORD_LEN}, 
	{0xB070,0xD353,WORD_LEN},
	{0xB072,0x0130,WORD_LEN},
	{0xB074,0x0A28,WORD_LEN}, 
	{0xB076,0xF5DB,WORD_LEN}, 
	{0xB078,0x80BC,WORD_LEN}, 
	{0xB07A,0xF746,WORD_LEN}, 
	{0xB07C,0x1C01,WORD_LEN}, 
	{0xB07E,0x1800,WORD_LEN}, 
	{0xB080,0x40EC,WORD_LEN}, 
	{0xB082,0x3000,WORD_LEN}, 
	{0xB084,0x00B5,WORD_LEN}, 
	{0xB086,0x0548,WORD_LEN}, 
	{0xB088,0x8079,WORD_LEN}, 
	{0xB08A,0x0128,WORD_LEN}, 
	{0xB08C,0x03D1,WORD_LEN}, 
	{0xB08E,0x0448,WORD_LEN}, 
	{0xB090,0x0078,WORD_LEN}, 
	{0xB092,0x0228,WORD_LEN}, 
	{0xB094,0x01D1,WORD_LEN}, 
	{0xB096,0x00F0,WORD_LEN}, 
	{0xB098,0x05F8,WORD_LEN}, 
	{0xB09A,0x00BD,WORD_LEN}, 
	{0xB09C,0x7C2F,WORD_LEN}, 
	{0xB09E,0x1800,WORD_LEN}, 
	{0xB0A0,0xAC3C,WORD_LEN}, 
	{0xB0A2,0x1800,WORD_LEN}, 
	{0xB0A4,0xF0B4,WORD_LEN}, 
	{0xB0A6,0x0021,WORD_LEN}, 
	{0xB0A8,0x1948,WORD_LEN}, 
	{0xB0AA,0x1A4A,WORD_LEN}, 
	{0xB0AC,0x0478,WORD_LEN}, 
	{0xB0AE,0xC078,WORD_LEN}, 
	{0xB0B0,0x1768,WORD_LEN}, 
	{0xB0B2,0x164D,WORD_LEN}, 
	{0xB0B4,0xC307,WORD_LEN}, 
	{0xB0B6,0xDB0F,WORD_LEN}, 
	{0xB0B8,0x4800,WORD_LEN}, 
	{0xB0BA,0x285A,WORD_LEN}, 
	{0xB0BC,0x002C,WORD_LEN}, 
	{0xB0BE,0x17D0,WORD_LEN}, 
	{0xB0C0,0x7A69,WORD_LEN}, 
	{0xB0C2,0x5202,WORD_LEN}, 
	{0xB0C4,0xD20F,WORD_LEN}, 
	{0xB0C6,0x012A,WORD_LEN}, 
	{0xB0C8,0x12D1,WORD_LEN}, 
	{0xB0CA,0x134E,WORD_LEN}, 
	{0xB0CC,0x8A00,WORD_LEN}, 
	{0xB0CE,0x9219,WORD_LEN}, 
	{0xB0D0,0xD27E,WORD_LEN}, 
	{0xB0D2,0x012A,WORD_LEN}, 
	{0xB0D4,0x0CD1,WORD_LEN}, 
	{0xB0D6,0x002B,WORD_LEN}, 
	{0xB0D8,0x03D0,WORD_LEN}, 
	{0xB0DA,0x8207,WORD_LEN}, 
	{0xB0DC,0x08D1,WORD_LEN}, 
	{0xB0DE,0x0230,WORD_LEN}, 
	{0xB0E0,0x04E0,WORD_LEN}, 
	{0xB0E2,0x8207,WORD_LEN}, 
	{0xB0E4,0x04D0,WORD_LEN}, 
	{0xB0E6,0x0128,WORD_LEN}, 
	{0xB0E8,0x02DD,WORD_LEN}, 
	{0xB0EA,0x0238,WORD_LEN}, 
	{0xB0EC,0x0004,WORD_LEN}, 
	{0xB0EE,0x000C,WORD_LEN}, 
	{0xB0F0,0x094E,WORD_LEN}, 
	{0xB0F2,0x8A00,WORD_LEN}, 
	{0xB0F4,0x9219,WORD_LEN}, 
	{0xB0F6,0x9669,WORD_LEN}, 
	{0xB0F8,0xF60A,WORD_LEN}, 
	{0xB0FA,0xF602,WORD_LEN}, 
	{0xB0FC,0x3043,WORD_LEN}, 
	{0xB0FE,0x9061,WORD_LEN}, 
	{0xB100,0x0131,WORD_LEN}, 
	{0xB102,0x0A29,WORD_LEN}, 
	{0xB104,0xD8DB,WORD_LEN}, 
	{0xB106,0xF0BC,WORD_LEN}, 
	{0xB108,0xF746,WORD_LEN}, 
	{0xB10A,0x0000,WORD_LEN}, 
	{0xB10C,0x1C01,WORD_LEN}, 
	{0xB10E,0x1800,WORD_LEN}, 
	{0xB110,0xB23C,WORD_LEN}, 
	{0xB112,0x1800,WORD_LEN}, 
	{0xB114,0x5819,WORD_LEN}, 
	{0xB116,0x1800,WORD_LEN}, 
	{0xB118,0x40EC,WORD_LEN}, 
	{0xB11A,0x3000,WORD_LEN},
	/*LGE_END*/
	{0x0009, 0x16   ,BYTE_LEN},     // INPUT CLOCK SETTING
	{0x001C, 0x00   ,BYTE_LEN},     // OUTPUT FORMAT MONITOR MODE
#if defined (CONFIG_ISX005_ROTATION_180)
	{0x001F, 0x03   ,BYTE_LEN},         //READVECT_MONI
#else
	{0x001F, 0x00   ,BYTE_LEN},             //READVECT_MONI
#endif
	{0x0022, 0x8002 ,WORD_LEN},             //640*480 monitoring SIZE H
	{0x0028, 0xE001 ,WORD_LEN},             //640*480 monitoring SIZE V
	//0x0022, 0x0004                //1024*768 monitoring SIZE H
	//0x0028, 0x0003                //1024*768 monitoring SIZE V
	//{0x00FC, 0xff   ,BYTE_LEN},     //
	{0x00FC, 0x1f   ,BYTE_LEN},     //
	{0x0011, 0x00   ,BYTE_LEN},     //  MODE_SEL
	{0x0012, 0x01   ,BYTE_LEN},     //  MODE_Reflesh
};

static struct isx005_register_address_value_pair const
init_reg32_settings_array[] = {

	
	// ISX005-0 (FW 2005)
	//	 Parallel	8.8fps
	//		  PLL	256MHz
	//		  DCK	 Preview : 64MHz, Capture : 64MHz
	//
	// inifile
	// size address data
	//

	{0x00FC, 0x1f	,BYTE_LEN}, 	//
	{0x000b, 0x02, BYTE_LEN},		// PLL_CKSEL	
	{0x3208, 0x01	,BYTE_LEN}, 	// [LGE_CODE] FAST MODE CHANGE - eunyoung.shin@lge.com 2010-07-13 
	{0x0009, 0x06	,BYTE_LEN}, 	// INCK_SET 
	{0x02C7, 0x01, BYTE_LEN},		// SRCCK_DIV 
	{0x0038, 0x0D  ,BYTE_LEN},		// sync masking on off	 - for QCT		
	{0x02B8, 0x10, BYTE_LEN},		// VIF_CLKCONFIG1	 - still							
	{0x02B9, 0x11, BYTE_LEN},		// VIF_CLKCONFIG2	 - prevew  10 ->64Mhz, 11->32Mhz
	{0x02BA, 0x12, BYTE_LEN},		// VIF_CLKCONFIG3	 
	{0x02BB, 0x13, BYTE_LEN},		// VIF_CLKCONFIG4	 
	{0x02BC, 0x11, BYTE_LEN},		// VIF_CLKCONFIG5	 
	{0x02BD, 0x12, BYTE_LEN},		// VIF_CLKCONFIG6	 
	{0x02BE, 0x13, BYTE_LEN},		// VIF_CLKCONFIG7	 
	{0x02C0, 0x10, BYTE_LEN},		// VIF_CLKCONFIG9	 
	{0x02C1, 0x30, BYTE_LEN},		// VIF_CLKCONFIG10	 
	{0x4C10, 0x11, BYTE_LEN},		// VIF_CLKCONFIG13	 
	{0x0348, 0x30, BYTE_LEN},		// VIF_CLKCONFIG_HD1 
	{0x034A, 0x11, BYTE_LEN},		// VIF_CLKCONFIG_HD3 
	{0x034C, 0x30, BYTE_LEN},		// VIF_CLKCONFIG_HD5 
	{0x4044, 0x800C, WORD_LEN}, 	// 1SECCLK_ALL
	{0x4046, 0x1815, WORD_LEN}, 	// 1SECCLK_HD_1_1
	{0x402B, 0x59, BYTE_LEN},		// FPS_SENSALL
	{0x402C, 0x9600, WORD_LEN}, 	// FPS_SENS_HD_1_1
	{0x4060, 0x800C, WORD_LEN}, 	// PIXEL_CLK
	{0x4062, 0x1815, WORD_LEN}, 	// PIXEL_CLK_HD_1_1
	{0x403E, 0x001E, WORD_LEN}, 	// FLSHT50
	{0x4074, 0x0521, WORD_LEN}, 	// FLSHT50_HD_1_1
	{0x4040, 0xF21C, WORD_LEN}, 	// FLSHT60
	{0x4076, 0xF71F, WORD_LEN}, 	// FLSHT60_HD_1_1
	{0x02A2, 0x0000, WORD_LEN}, 	// VADJ_SENS_1_1
	{0x0364, 0x2100, WORD_LEN}, 	// VADJ_SENS_HD_1_1
	{0x02A4, 0x0700, WORD_LEN}, 	// VADJ_SENS_1_2
	{0x02A6, 0x0300, WORD_LEN}, 	// VADJ_SENS_1_4
	{0x02A8, 0x0000, WORD_LEN}, 	// VADJ_SENS_1_8
	{0x4C14, 0xE001, WORD_LEN}, 	// FLC_OPD_HEIGHT_NORMAL_1_1
	{0x4C1C, 0x4003, WORD_LEN}, 	// FLC_OPD_HEIGHT_HD_1_1
	{0x4C16, 0xE001, WORD_LEN}, 	// FLC_OPD_HEIGHT_NORMAL_1_2
	{0x4C18, 0x8001, WORD_LEN}, 	// FLC_OPD_HEIGHT_NORMAL_1_4
	{0x4C1A, 0xC000, WORD_LEN}, 	// FLC_OPD_HEIGHT_NORMAL_1_8
	{0x000E, 0x12, BYTE_LEN},		// GPIO_FUNCSEL IRQ disable & UART enable
	{0x02CD, 0x03, BYTE_LEN},			//[LGE_CODE] Drive Strength - 2mA for RF sensortivity - eunyoung.shin@lge.com 2010-07-13 
	{0x003A, 0x0002 ,WORD_LEN},   // CAM OUTPUT DATA Format
	{0x001C, 0x00	,BYTE_LEN}, 	// OUTPUT FORMAT MONITOR MODE
#if defined (CONFIG_ISX005_ROTATION_180)
	{0x001F, 0x03	,BYTE_LEN}, 	//READVECT_MONI
#else
	{0x001F, 0x00	,BYTE_LEN}, 	//READVECT_MONI
#endif
	{0x0022, 0x8002 ,WORD_LEN}, 	//640*480 monitoring SIZE H
	{0x0028, 0xE001 ,WORD_LEN}, 	//640*480 monitoring SIZE V
	{0x034F,0x01,BYTE_LEN}, 		// VEXPAND_F
	/*LGE_START*/
	{0xB000,0xBCBC,WORD_LEN}, // defect calibration additional code - fix bad pixel - eunyoung.shin@lge.com 2010-07-19
	{0xB002,0x2130,WORD_LEN}, 
	{0xB004,0x5580,WORD_LEN},
	{0xB006,0xAE00,WORD_LEN}, 
	{0xB008,0x75F1,WORD_LEN}, 
	{0xB00A,0xE0F8,WORD_LEN}, 
	{0xB00C,0x55D8,WORD_LEN}, 
	{0xB00E,0x9500,WORD_LEN}, 
	{0xB010,0x76F1,WORD_LEN}, 
	{0xB012,0x3AFD,WORD_LEN}, 
	{0xB014,0x0000,WORD_LEN}, 
	{0xB016,0x0000,WORD_LEN}, 
	{0xB018,0x0000,WORD_LEN}, 
	{0xB01A,0x0000,WORD_LEN}, 
	{0xB01C,0x0000,WORD_LEN}, 
	{0xB01E,0x0000,WORD_LEN}, 
	{0xB020,0x0000,WORD_LEN}, 
	{0xB022,0x0000,WORD_LEN}, 
	{0xB024,0x0000,WORD_LEN}, 
	{0xB026,0x0000,WORD_LEN}, 
	{0xB028,0x0000,WORD_LEN}, 
	{0xB02A,0x0000,WORD_LEN}, 
	{0xB02C,0x0000,WORD_LEN}, 
	{0xB02E,0x0000,WORD_LEN}, 
	{0xB030,0x0000,WORD_LEN}, 
	{0xB032,0x0000,WORD_LEN}, 
	{0xB034,0x0000,WORD_LEN}, 
	{0xB036,0x0000,WORD_LEN}, 
	{0xB038,0x0000,WORD_LEN}, 
	{0xB03A,0x0000,WORD_LEN}, 
	{0xB03C,0x0000,WORD_LEN}, 
	{0xB03E,0x0000,WORD_LEN}, 
	{0xB040,0x0000,WORD_LEN}, 
	{0xB042,0x0000,WORD_LEN}, 
	{0xB044,0x8FF6,WORD_LEN}, 
	{0xB046,0xAEFD,WORD_LEN}, 
	{0xB048,0x00F0,WORD_LEN}, 
	{0xB04A,0x08F8,WORD_LEN}, 
	{0xB04C,0x8AF6,WORD_LEN}, 
	{0xB04E,0x1AFF,WORD_LEN}, 
	{0xB050,0x8AF6,WORD_LEN}, 
	{0xB052,0x50F9,WORD_LEN}, 
	{0xB054,0x00F0,WORD_LEN}, 
	{0xB056,0x16F8,WORD_LEN}, 
	{0xB058,0x89F6,WORD_LEN}, 
	{0xB05A,0xC0FA,WORD_LEN}, 
	{0xB05C,0x80B4,WORD_LEN}, 
	{0xB05E,0x0020,WORD_LEN}, 
	{0xB060,0x064A,WORD_LEN}, 
	{0xB062,0x0749,WORD_LEN}, 
	{0xB064,0x8300,WORD_LEN}, 
	{0xB066,0x5B18,WORD_LEN}, 
	{0xB068,0x9B69,WORD_LEN}, 
	{0xB06A,0x5B05,WORD_LEN}, 
	{0xB06C,0x5B0D,WORD_LEN}, 
	{0xB06E,0x4700,WORD_LEN}, 
	{0xB070,0xD353,WORD_LEN},
	{0xB072,0x0130,WORD_LEN},
	{0xB074,0x0A28,WORD_LEN}, 
	{0xB076,0xF5DB,WORD_LEN}, 
	{0xB078,0x80BC,WORD_LEN}, 
	{0xB07A,0xF746,WORD_LEN}, 
	{0xB07C,0x1C01,WORD_LEN}, 
	{0xB07E,0x1800,WORD_LEN}, 
	{0xB080,0x40EC,WORD_LEN}, 
	{0xB082,0x3000,WORD_LEN}, 
	{0xB084,0x00B5,WORD_LEN}, 
	{0xB086,0x0548,WORD_LEN}, 
	{0xB088,0x8079,WORD_LEN}, 
	{0xB08A,0x0128,WORD_LEN}, 
	{0xB08C,0x03D1,WORD_LEN}, 
	{0xB08E,0x0448,WORD_LEN}, 
	{0xB090,0x0078,WORD_LEN}, 
	{0xB092,0x0228,WORD_LEN}, 
	{0xB094,0x01D1,WORD_LEN}, 
	{0xB096,0x00F0,WORD_LEN}, 
	{0xB098,0x05F8,WORD_LEN}, 
	{0xB09A,0x00BD,WORD_LEN}, 
	{0xB09C,0x7C2F,WORD_LEN}, 
	{0xB09E,0x1800,WORD_LEN}, 
	{0xB0A0,0xAC3C,WORD_LEN}, 
	{0xB0A2,0x1800,WORD_LEN}, 
	{0xB0A4,0xF0B4,WORD_LEN}, 
	{0xB0A6,0x0021,WORD_LEN}, 
	{0xB0A8,0x1948,WORD_LEN}, 
	{0xB0AA,0x1A4A,WORD_LEN}, 
	{0xB0AC,0x0478,WORD_LEN}, 
	{0xB0AE,0xC078,WORD_LEN}, 
	{0xB0B0,0x1768,WORD_LEN}, 
	{0xB0B2,0x164D,WORD_LEN}, 
	{0xB0B4,0xC307,WORD_LEN}, 
	{0xB0B6,0xDB0F,WORD_LEN}, 
	{0xB0B8,0x4800,WORD_LEN}, 
	{0xB0BA,0x285A,WORD_LEN}, 
	{0xB0BC,0x002C,WORD_LEN}, 
	{0xB0BE,0x17D0,WORD_LEN}, 
	{0xB0C0,0x7A69,WORD_LEN}, 
	{0xB0C2,0x5202,WORD_LEN}, 
	{0xB0C4,0xD20F,WORD_LEN}, 
	{0xB0C6,0x012A,WORD_LEN}, 
	{0xB0C8,0x12D1,WORD_LEN}, 
	{0xB0CA,0x134E,WORD_LEN}, 
	{0xB0CC,0x8A00,WORD_LEN}, 
	{0xB0CE,0x9219,WORD_LEN}, 
	{0xB0D0,0xD27E,WORD_LEN}, 
	{0xB0D2,0x012A,WORD_LEN}, 
	{0xB0D4,0x0CD1,WORD_LEN}, 
	{0xB0D6,0x002B,WORD_LEN}, 
	{0xB0D8,0x03D0,WORD_LEN}, 
	{0xB0DA,0x8207,WORD_LEN}, 
	{0xB0DC,0x08D1,WORD_LEN}, 
	{0xB0DE,0x0230,WORD_LEN}, 
	{0xB0E0,0x04E0,WORD_LEN}, 
	{0xB0E2,0x8207,WORD_LEN}, 
	{0xB0E4,0x04D0,WORD_LEN}, 
	{0xB0E6,0x0128,WORD_LEN}, 
	{0xB0E8,0x02DD,WORD_LEN}, 
	{0xB0EA,0x0238,WORD_LEN}, 
	{0xB0EC,0x0004,WORD_LEN}, 
	{0xB0EE,0x000C,WORD_LEN}, 
	{0xB0F0,0x094E,WORD_LEN}, 
	{0xB0F2,0x8A00,WORD_LEN}, 
	{0xB0F4,0x9219,WORD_LEN}, 
	{0xB0F6,0x9669,WORD_LEN}, 
	{0xB0F8,0xF60A,WORD_LEN}, 
	{0xB0FA,0xF602,WORD_LEN}, 
	{0xB0FC,0x3043,WORD_LEN}, 
	{0xB0FE,0x9061,WORD_LEN}, 
	{0xB100,0x0131,WORD_LEN}, 
	{0xB102,0x0A29,WORD_LEN}, 
	{0xB104,0xD8DB,WORD_LEN}, 
	{0xB106,0xF0BC,WORD_LEN}, 
	{0xB108,0xF746,WORD_LEN}, 
	{0xB10A,0x0000,WORD_LEN}, 
	{0xB10C,0x1C01,WORD_LEN}, 
	{0xB10E,0x1800,WORD_LEN}, 
	{0xB110,0xB23C,WORD_LEN}, 
	{0xB112,0x1800,WORD_LEN}, 
	{0xB114,0x5819,WORD_LEN}, 
	{0xB116,0x1800,WORD_LEN}, 
	{0xB118,0x40EC,WORD_LEN}, 
	{0xB11A,0x3000,WORD_LEN}, 
	/*LGE_END*/
	{0x0009, 0x16, BYTE_LEN },		// INCK_SET

};

#endif

static struct isx005_register_address_value_pair const
tuning_reg_settings_array[] = {	//091214
	{0x0068,0x50  ,BYTE_LEN},
	{0x9000,0x8383,WORD_LEN},
	{0x9002,0x01  ,BYTE_LEN},
	{0x9003,0xfc  ,BYTE_LEN},
	{0x9004,0x07  ,BYTE_LEN},
	{0x9005,0xf0  ,BYTE_LEN},
	{0x9006,0x2f  ,BYTE_LEN},
	{0x9007,0x20  ,BYTE_LEN},
	{0x9008,0x80  ,BYTE_LEN},
	{0x9009,0x80  ,BYTE_LEN},
	{0x900A,0x02  ,BYTE_LEN},
	{0x900B,0xff  ,BYTE_LEN},
	{0x900C,0x0b  ,BYTE_LEN},
	{0x900D,0x04  ,BYTE_LEN},
	{0x900E,0x18  ,BYTE_LEN},
	{0x900F,0x10  ,BYTE_LEN},
	{0x9010,0x00  ,BYTE_LEN},
	{0x9011,0x40  ,BYTE_LEN},
	{0x9012,0x00  ,BYTE_LEN},
	{0x9013,0x00  ,BYTE_LEN},
	{0x9014,0x01  ,BYTE_LEN},
	{0x9015,0xfc  ,BYTE_LEN},
	{0x9016,0x07  ,BYTE_LEN},
	{0x9017,0xf0  ,BYTE_LEN},
	{0x9018,0x2f  ,BYTE_LEN},
	{0x9019,0x20  ,BYTE_LEN},
	{0x901A,0x80  ,BYTE_LEN},
	{0x901B,0x80  ,BYTE_LEN},
	{0x901C,0x02  ,BYTE_LEN},
	{0x901D,0xff  ,BYTE_LEN},
	{0x901E,0x0b  ,BYTE_LEN},
	{0x901F,0x04  ,BYTE_LEN},
	{0x9020,0x18  ,BYTE_LEN},
	{0x9021,0x10  ,BYTE_LEN},
	{0x9022,0x00  ,BYTE_LEN},
	{0x9023,0x40  ,BYTE_LEN},
	{0x9024,0x00  ,BYTE_LEN},
	{0x9025,0x00  ,BYTE_LEN},
	{0x9026,0x01  ,BYTE_LEN},
	{0x9027,0x04  ,BYTE_LEN},
	{0x9028,0x04  ,BYTE_LEN},
	{0x9029,0x10  ,BYTE_LEN},
	{0x902A,0xf0  ,BYTE_LEN},
	{0x902B,0x7f  ,BYTE_LEN},
	{0x902C,0x40  ,BYTE_LEN},
	{0x902D,0x00  ,BYTE_LEN},
	{0x902E,0x01  ,BYTE_LEN},
	{0x902F,0x01  ,BYTE_LEN},
	{0x9030,0x08  ,BYTE_LEN},
	{0x9031,0x04  ,BYTE_LEN},
	{0x9032,0x20  ,BYTE_LEN},
	{0x9033,0x30  ,BYTE_LEN},
	{0x9034,0x80  ,BYTE_LEN},
	{0x9035,0xc0  ,BYTE_LEN},
	{0x9036,0x00  ,BYTE_LEN},
	{0x9037,0x02  ,BYTE_LEN},
	{0x9038,0x02  ,BYTE_LEN},
	{0x9039,0x02  ,BYTE_LEN},
	{0x903A,0x08  ,BYTE_LEN},
	{0x903B,0x08  ,BYTE_LEN},
	{0x903C,0x10  ,BYTE_LEN},
	{0x903D,0x20  ,BYTE_LEN},
	{0x903E,0x80  ,BYTE_LEN},
	{0x903F,0x80  ,BYTE_LEN},
	{0x9040,0x00  ,BYTE_LEN},
	{0x9041,0x00  ,BYTE_LEN},
	{0x9042,0x04  ,BYTE_LEN},
	{0x9043,0x08  ,BYTE_LEN},
	{0x9044,0x18  ,BYTE_LEN},
	{0x9045,0x40  ,BYTE_LEN},
	{0x9046,0xa0  ,BYTE_LEN},
	{0x9047,0x00  ,BYTE_LEN},
	{0x9048,0x81  ,BYTE_LEN},
	{0x9049,0x02  ,BYTE_LEN},
	{0x904A,0x01  ,BYTE_LEN},
	{0x904B,0x00  ,BYTE_LEN},
	{0x904C,0x04  ,BYTE_LEN},
	{0x904D,0x00  ,BYTE_LEN},
	{0x904E,0x20  ,BYTE_LEN},
	{0x904F,0x00  ,BYTE_LEN},
	{0x9050,0x40  ,BYTE_LEN},
	{0x9051,0x80  ,BYTE_LEN},
	{0x9052,0xff  ,BYTE_LEN},
	{0x9053,0x01  ,BYTE_LEN},
	{0x9054,0x02  ,BYTE_LEN},
	{0x9055,0x00  ,BYTE_LEN},
	{0x9056,0x10  ,BYTE_LEN},
	{0x9057,0x20  ,BYTE_LEN},
	{0x9058,0x60  ,BYTE_LEN},
	{0x9059,0x80  ,BYTE_LEN},
	{0x905A,0x80  ,BYTE_LEN},
	{0x905B,0x01  ,BYTE_LEN},
	{0x905C,0x03  ,BYTE_LEN},
	{0x905D,0x00  ,BYTE_LEN},
	{0x905E,0x0c  ,BYTE_LEN},
	{0x905F,0x00  ,BYTE_LEN},
	{0x9060,0x10  ,BYTE_LEN},
	{0x9061,0xe0  ,BYTE_LEN},
	{0x9062,0xbf  ,BYTE_LEN},
	{0x9063,0x80  ,BYTE_LEN},
	{0x9064,0xff  ,BYTE_LEN},
	{0x9065,0x01  ,BYTE_LEN},
	{0x9066,0x00  ,BYTE_LEN},
	{0x9067,0x08  ,BYTE_LEN},
	{0x9068,0x08  ,BYTE_LEN},
	{0x9069,0x30  ,BYTE_LEN},
	{0x906A,0x40  ,BYTE_LEN},
	{0x906B,0xc0  ,BYTE_LEN},
	{0x906C,0x00  ,BYTE_LEN},
	{0x906D,0x01  ,BYTE_LEN},
	{0x906E,0x01  ,BYTE_LEN},
	{0x906F,0xfc  ,BYTE_LEN},
	{0x9070,0x07  ,BYTE_LEN},
	{0x9071,0xf0  ,BYTE_LEN},
	{0x9072,0x1f  ,BYTE_LEN},
	{0x9073,0x00  ,BYTE_LEN},
	{0x9074,0x80  ,BYTE_LEN},
	{0x9075,0x80  ,BYTE_LEN},
	{0x9076,0xff  ,BYTE_LEN},
	{0x9077,0x02  ,BYTE_LEN},
	{0x9078,0xfe  ,BYTE_LEN},
	{0x9079,0x17  ,BYTE_LEN},
	{0x907A,0x00  ,BYTE_LEN},
	{0x907B,0x30  ,BYTE_LEN},
	{0x907C,0x20  ,BYTE_LEN},
	{0x907D,0xc0  ,BYTE_LEN},
	{0x907E,0x80  ,BYTE_LEN},
	{0x907F,0x00  ,BYTE_LEN},
	{0x9080,0x00  ,BYTE_LEN},
	{0x9081,0xfe  ,BYTE_LEN},
	{0x9082,0x03  ,BYTE_LEN},
	{0x9083,0xf8  ,BYTE_LEN},
	{0x9084,0x3f  ,BYTE_LEN},
	{0x9085,0x00  ,BYTE_LEN},
	{0x9086,0xc0  ,BYTE_LEN},
	{0x9087,0x00  ,BYTE_LEN},
	{0x9088,0x01  ,BYTE_LEN},
	{0x9089,0x02  ,BYTE_LEN},
	{0x908A,0x02  ,BYTE_LEN},
	{0x908B,0x10  ,BYTE_LEN},
	{0x908C,0x00  ,BYTE_LEN},
	{0x908D,0x40  ,BYTE_LEN},
	{0x908E,0x20  ,BYTE_LEN},
	{0x908F,0x00  ,BYTE_LEN},
	{0x9090,0x81  ,BYTE_LEN},
	{0x9091,0x00  ,BYTE_LEN},
	{0x9092,0x01  ,BYTE_LEN},
	{0x9093,0xf8  ,BYTE_LEN},
	{0x9094,0x07  ,BYTE_LEN},
	{0x9095,0xe0  ,BYTE_LEN},
	{0x9096,0x1f  ,BYTE_LEN},
	{0x9097,0x20  ,BYTE_LEN},
	{0x9098,0x00  ,BYTE_LEN},
	{0x9099,0x01  ,BYTE_LEN},
	{0x909A,0x01  ,BYTE_LEN},
	{0x909B,0x05  ,BYTE_LEN},
	{0x909C,0x02  ,BYTE_LEN},
	{0x909D,0x10  ,BYTE_LEN},
	{0x909E,0x10  ,BYTE_LEN},
	{0x909F,0x40  ,BYTE_LEN},
	{0x90A0,0xc0  ,BYTE_LEN},
	{0x90A1,0x3f  ,BYTE_LEN},
	{0x90A2,0x01  ,BYTE_LEN},
	{0x90A3,0xff  ,BYTE_LEN},
	{0x90A4,0x01  ,BYTE_LEN},
	{0x90A5,0xf8  ,BYTE_LEN},
	{0x90A6,0x07  ,BYTE_LEN},
	{0x90A7,0xe0  ,BYTE_LEN},
	{0x90A8,0x1f  ,BYTE_LEN},
	{0x90A9,0x20  ,BYTE_LEN},
	{0x90AA,0x00  ,BYTE_LEN},
	{0x90AB,0x01  ,BYTE_LEN},
	{0x90AC,0x01  ,BYTE_LEN},
	{0x90AD,0x05  ,BYTE_LEN},
	{0x90AE,0x02  ,BYTE_LEN},
	{0x90AF,0x10  ,BYTE_LEN},
	{0x90B0,0x10  ,BYTE_LEN},
	{0x90B1,0x40  ,BYTE_LEN},
	{0x90B2,0xc0  ,BYTE_LEN},
	{0x90B3,0x3f  ,BYTE_LEN},
	{0x90B4,0x01  ,BYTE_LEN},
	{0x90B5,0xff  ,BYTE_LEN},
	{0x90B6,0xf8  ,BYTE_LEN},
	{0x90B7,0xe5  ,BYTE_LEN},
	{0x90B8,0xe3  ,BYTE_LEN},
	{0x90B9,0x97  ,BYTE_LEN},
	{0x90BA,0xcf  ,BYTE_LEN},
	{0x90BB,0xdf  ,BYTE_LEN},
	{0x90BC,0x3e  ,BYTE_LEN},
	{0x90BD,0x7f  ,BYTE_LEN},
	{0x90BE,0xf9  ,BYTE_LEN},
	{0x90BF,0xfc  ,BYTE_LEN},
	{0x90C0,0xeb  ,BYTE_LEN},
	{0x90C1,0xef  ,BYTE_LEN},
	{0x90C2,0xbf  ,BYTE_LEN},
	{0x90C3,0xaf  ,BYTE_LEN},
	{0x90C4,0x9f  ,BYTE_LEN},
	{0x90C5,0xbf  ,BYTE_LEN},
	{0x90C6,0x7e  ,BYTE_LEN},
	{0x90C7,0xfe  ,BYTE_LEN},
	{0x90C8,0xf8  ,BYTE_LEN},
	{0x90C9,0xe5  ,BYTE_LEN},
	{0x90CA,0xe3  ,BYTE_LEN},
	{0x90CB,0x97  ,BYTE_LEN},
	{0x90CC,0xcf  ,BYTE_LEN},
	{0x90CD,0xdf  ,BYTE_LEN},
	{0x90CE,0x3e  ,BYTE_LEN},
	{0x90CF,0x7f  ,BYTE_LEN},
	{0x90D0,0xf9  ,BYTE_LEN},
	{0x90D1,0xfc  ,BYTE_LEN},
	{0x90D2,0xeb  ,BYTE_LEN},
	{0x90D3,0xef  ,BYTE_LEN},
	{0x90D4,0xbf  ,BYTE_LEN},
	{0x90D5,0xaf  ,BYTE_LEN},
	{0x90D6,0x9f  ,BYTE_LEN},
	{0x90D7,0xbf  ,BYTE_LEN},
	{0x90D8,0x7e  ,BYTE_LEN},
	{0x90D9,0xfe  ,BYTE_LEN},
	{0x90DA,0xfd  ,BYTE_LEN},
	{0x90DB,0xed  ,BYTE_LEN},
	{0x90DC,0xf7  ,BYTE_LEN},
	{0x90DD,0xb7  ,BYTE_LEN},
	{0x90DE,0xef  ,BYTE_LEN},
	{0x90DF,0x9f  ,BYTE_LEN},
	{0x90E0,0x7e  ,BYTE_LEN},
	{0x90E1,0x7f  ,BYTE_LEN},
	{0x90E2,0xfb  ,BYTE_LEN},
	{0x90E3,0xfd  ,BYTE_LEN},
	{0x90E4,0xeb  ,BYTE_LEN},
	{0x90E5,0xf7  ,BYTE_LEN},
	{0x90E6,0xb7  ,BYTE_LEN},
	{0x90E7,0xbf  ,BYTE_LEN},
	{0x90E8,0xdf  ,BYTE_LEN},
	{0x90E9,0xfe  ,BYTE_LEN},
	{0x90EA,0x7e  ,BYTE_LEN},
	{0x90EB,0xfb  ,BYTE_LEN},
	{0x90EC,0xfd  ,BYTE_LEN},
	{0x90ED,0xeb  ,BYTE_LEN},
	{0x90EE,0xf7  ,BYTE_LEN},
	{0x90EF,0xaf  ,BYTE_LEN},
	{0x90F0,0xff  ,BYTE_LEN},
	{0x90F1,0x1f  ,BYTE_LEN},
	{0x90F2,0xbf  ,BYTE_LEN},
	{0x90F3,0x7f  ,BYTE_LEN},
	{0x90F4,0xfc  ,BYTE_LEN},
	{0x90F5,0xfe  ,BYTE_LEN},
	{0x90F6,0xf3  ,BYTE_LEN},
	{0x90F7,0xf3  ,BYTE_LEN},
	{0x90F8,0xc7  ,BYTE_LEN},
	{0x90F9,0xcf  ,BYTE_LEN},
	{0x90FA,0x7f  ,BYTE_LEN},
	{0x90FB,0x3f  ,BYTE_LEN},
	{0x90FC,0xff  ,BYTE_LEN},
	{0x90FD,0xfd  ,BYTE_LEN},
	{0x90FE,0xff  ,BYTE_LEN},
	{0x90FF,0xfb  ,BYTE_LEN},
	{0x9100,0xff  ,BYTE_LEN},
	{0x9101,0xef  ,BYTE_LEN},
	{0x9102,0x0f  ,BYTE_LEN},
	{0x9103,0x40  ,BYTE_LEN},
	{0x9104,0xff  ,BYTE_LEN},
	{0x9105,0x7f  ,BYTE_LEN},
	{0x9106,0xfb  ,BYTE_LEN},
	{0x9107,0xff  ,BYTE_LEN},
	{0x9108,0xf3  ,BYTE_LEN},
	{0x9109,0xf7  ,BYTE_LEN},
	{0x910A,0xc7  ,BYTE_LEN},
	{0x910B,0xdf  ,BYTE_LEN},
	{0x910C,0xff  ,BYTE_LEN},
	{0x910D,0x7f  ,BYTE_LEN},
	{0x910E,0xff  ,BYTE_LEN},
	{0x910F,0xff  ,BYTE_LEN},
	{0x9110,0x01  ,BYTE_LEN},
	{0x9111,0xfa  ,BYTE_LEN},
	{0x9112,0x07  ,BYTE_LEN},
	{0x9113,0xe8  ,BYTE_LEN},
	{0x9114,0x1f  ,BYTE_LEN},
	{0x9115,0xa0  ,BYTE_LEN},
	{0x9116,0xff  ,BYTE_LEN},
	{0x9117,0xff  ,BYTE_LEN},
	{0x9118,0xfe  ,BYTE_LEN},
	{0x9119,0x00  ,BYTE_LEN},
	{0x911A,0xfe  ,BYTE_LEN},
	{0x911B,0x03  ,BYTE_LEN},
	{0x911C,0xf8  ,BYTE_LEN},
	{0x911D,0xff  ,BYTE_LEN},
	{0x911E,0x5f  ,BYTE_LEN},
	{0x911F,0xc0  ,BYTE_LEN},
	{0x9120,0x7f  ,BYTE_LEN},
	{0x9121,0x01  ,BYTE_LEN},
	{0x9122,0x01  ,BYTE_LEN},
	{0x9123,0x00  ,BYTE_LEN},
	{0x9124,0x04  ,BYTE_LEN},
	{0x9125,0x00  ,BYTE_LEN},
	{0x9126,0x30  ,BYTE_LEN},
	{0x9127,0x20  ,BYTE_LEN},
	{0x9128,0x00  ,BYTE_LEN},
	{0x9129,0x80  ,BYTE_LEN},
	{0x912A,0x01  ,BYTE_LEN},
	{0x912B,0x01  ,BYTE_LEN},
	{0x912C,0x04  ,BYTE_LEN},
	{0x912D,0xfc  ,BYTE_LEN},
	{0x912E,0x2f  ,BYTE_LEN},
	{0x912F,0x00  ,BYTE_LEN},
	{0x9130,0x60  ,BYTE_LEN},
	{0x9131,0x00  ,BYTE_LEN},
	{0x9132,0x80  ,BYTE_LEN},
	{0x9133,0x01  ,BYTE_LEN},
	{0x9134,0x02  ,BYTE_LEN},
	{0x9135,0x0a  ,BYTE_LEN},
	{0x9136,0x08  ,BYTE_LEN},
	{0x9137,0x28  ,BYTE_LEN},
	{0x9138,0x10  ,BYTE_LEN},
	{0x9139,0x80  ,BYTE_LEN},
	{0x913A,0xc0  ,BYTE_LEN},
	{0x913B,0x80  ,BYTE_LEN},
	{0x913C,0x01  ,BYTE_LEN},
	{0x913D,0x00  ,BYTE_LEN},
	{0x913E,0x0a  ,BYTE_LEN},
	{0x913F,0xfc  ,BYTE_LEN},
	{0x9140,0x2f  ,BYTE_LEN},
	{0x9141,0x10  ,BYTE_LEN},
	{0x9142,0xc0  ,BYTE_LEN},
	{0x9143,0x40  ,BYTE_LEN},
	{0x9144,0x00  ,BYTE_LEN},
	{0x9145,0x03  ,BYTE_LEN},
	{0x9146,0x00  ,BYTE_LEN},
	{0x9147,0x0c  ,BYTE_LEN},
	{0x9148,0x00  ,BYTE_LEN},
	{0x9149,0x30  ,BYTE_LEN},
	{0x914A,0xf0  ,BYTE_LEN},
	{0x914B,0xbf  ,BYTE_LEN},
	{0x914C,0xc0  ,BYTE_LEN},
	{0x914D,0xff  ,BYTE_LEN},
	{0x914E,0x01  ,BYTE_LEN},
	{0x914F,0x01  ,BYTE_LEN},
	{0x9150,0x0c  ,BYTE_LEN},
	{0x9151,0xfc  ,BYTE_LEN},
	{0x9152,0x3f  ,BYTE_LEN},
	{0x9153,0xc0  ,BYTE_LEN},
	{0x9154,0xff  ,BYTE_LEN},
	{0x9155,0x00  ,BYTE_LEN},
	{0x9156,0xff  ,BYTE_LEN},
	{0x9157,0x03  ,BYTE_LEN},
	{0x9158,0x00  ,BYTE_LEN},
	{0x9159,0x0c  ,BYTE_LEN},
	{0x915A,0x00  ,BYTE_LEN},
	{0x915B,0x30  ,BYTE_LEN},
	{0x915C,0xf0  ,BYTE_LEN},
	{0x915D,0xbf  ,BYTE_LEN},
	{0x915E,0xc0  ,BYTE_LEN},
	{0x915F,0xff  ,BYTE_LEN},
	{0x9160,0x01  ,BYTE_LEN},
	{0x9161,0x01  ,BYTE_LEN},
	{0x9162,0x0c  ,BYTE_LEN},
	{0x9163,0xfc  ,BYTE_LEN},
	{0x9164,0x3f  ,BYTE_LEN},
	{0x9165,0xc0  ,BYTE_LEN},
	{0x9166,0xff  ,BYTE_LEN},
	{0x9167,0x00  ,BYTE_LEN},
	{0x9168,0xff  ,BYTE_LEN},
	{0x9169,0x03  ,BYTE_LEN},
	{0xA000,0x9292,WORD_LEN},
	{0xA002,0xca  ,BYTE_LEN},
	{0xA003,0x61  ,BYTE_LEN},
	{0xA004,0x90  ,BYTE_LEN},
	{0xA005,0x72  ,BYTE_LEN},
	{0xA006,0x02  ,BYTE_LEN},
	{0xA007,0x64  ,BYTE_LEN},
	{0xA008,0x1b  ,BYTE_LEN},
	{0xA009,0xf8  ,BYTE_LEN},
	{0xA00A,0x84  ,BYTE_LEN},
	{0xA00B,0x26  ,BYTE_LEN},
	{0xA00C,0x3c  ,BYTE_LEN},
	{0xA00D,0x9b  ,BYTE_LEN},
	{0xA00E,0xf1  ,BYTE_LEN},
	{0xA00F,0x4e  ,BYTE_LEN},
	{0xA010,0x6b  ,BYTE_LEN},
	{0xA011,0xdc  ,BYTE_LEN},
	{0xA012,0x73  ,BYTE_LEN},
	{0xA013,0x9c  ,BYTE_LEN},
	{0xA014,0x02  ,BYTE_LEN},
	{0xA015,0x05  ,BYTE_LEN},
	{0xA016,0x67  ,BYTE_LEN},
	{0xA017,0x40  ,BYTE_LEN},
	{0xA018,0xce  ,BYTE_LEN},
	{0xA019,0x31  ,BYTE_LEN},
	{0xA01A,0x10  ,BYTE_LEN},
	{0xA01B,0x73  ,BYTE_LEN},
	{0xA01C,0xfe  ,BYTE_LEN},
	{0xA01D,0x83  ,BYTE_LEN},
	{0xA01E,0x9a  ,BYTE_LEN},
	{0xA01F,0xed  ,BYTE_LEN},
	{0xA020,0x48  ,BYTE_LEN},
	{0xA021,0x06  ,BYTE_LEN},
	{0xA022,0x39  ,BYTE_LEN},
	{0xA023,0x8b  ,BYTE_LEN},
	{0xA024,0x19  ,BYTE_LEN},
	{0xA025,0xce  ,BYTE_LEN},
	{0xA026,0x66  ,BYTE_LEN},
	{0xA027,0xa6  ,BYTE_LEN},
	{0xA028,0x23  ,BYTE_LEN},
	{0xA029,0x1c  ,BYTE_LEN},
	{0xA02A,0xfe  ,BYTE_LEN},
	{0xA02B,0x10  ,BYTE_LEN},
	{0xA02C,0x47  ,BYTE_LEN},
	{0xA02D,0x40  ,BYTE_LEN},
	{0xA02E,0xa9  ,BYTE_LEN},
	{0xA02F,0xd1  ,BYTE_LEN},
	{0xA030,0xce  ,BYTE_LEN},
	{0xA031,0x66  ,BYTE_LEN},
	{0xA032,0x92  ,BYTE_LEN},
	{0xA033,0x63  ,BYTE_LEN},
	{0xA034,0x16  ,BYTE_LEN},
	{0xA035,0xc5  ,BYTE_LEN},
	{0xA036,0x2c  ,BYTE_LEN},
	{0xA037,0xe5  ,BYTE_LEN},
	{0xA038,0x2c  ,BYTE_LEN},
	{0xA039,0x45  ,BYTE_LEN},
	{0xA03A,0x11  ,BYTE_LEN},
	{0xA03B,0xcb  ,BYTE_LEN},
	{0xA03C,0x55  ,BYTE_LEN},
	{0xA03D,0xf4  ,BYTE_LEN},
	{0xA03E,0x52  ,BYTE_LEN},
	{0xA03F,0x18  ,BYTE_LEN},
	{0xA040,0xda  ,BYTE_LEN},
	{0xA041,0x48  ,BYTE_LEN},
	{0xA042,0xc6  ,BYTE_LEN},
	{0xA043,0x38  ,BYTE_LEN},
	{0xA044,0x85  ,BYTE_LEN},
	{0xA045,0x79  ,BYTE_LEN},
	{0xA046,0x0d  ,BYTE_LEN},
	{0xA047,0x5c  ,BYTE_LEN},
	{0xA048,0x24  ,BYTE_LEN},
	{0xA049,0xb3  ,BYTE_LEN},
	{0xA04A,0x93  ,BYTE_LEN},
	{0xA04B,0xa6  ,BYTE_LEN},
	{0xA04C,0x64  ,BYTE_LEN},
	{0xA04D,0x64  ,BYTE_LEN},
	{0xA04E,0x24  ,BYTE_LEN},
	{0xA04F,0x13  ,BYTE_LEN},
	{0xA050,0xe1  ,BYTE_LEN},
	{0xA051,0x48  ,BYTE_LEN},
	{0xA052,0x4a  ,BYTE_LEN},
	{0xA053,0x74  ,BYTE_LEN},
	{0xA054,0x52  ,BYTE_LEN},
	{0xA055,0x15  ,BYTE_LEN},
	{0xA056,0xbb  ,BYTE_LEN},
	{0xA057,0x94  ,BYTE_LEN},
	{0xA058,0xc5  ,BYTE_LEN},
	{0xA059,0x31  ,BYTE_LEN},
	{0xA05A,0x74  ,BYTE_LEN},
	{0xA05B,0xb1  ,BYTE_LEN},
	{0xA05C,0x0c  ,BYTE_LEN},
	{0xA05D,0x57  ,BYTE_LEN},
	{0xA05E,0xee  ,BYTE_LEN},
	{0xA05F,0x22  ,BYTE_LEN},
	{0xA060,0x92  ,BYTE_LEN},
	{0xA061,0x95  ,BYTE_LEN},
	{0xA062,0x08  ,BYTE_LEN},
	{0xA063,0x44  ,BYTE_LEN},
	{0xA064,0x20  ,BYTE_LEN},
	{0xA065,0xfb  ,BYTE_LEN},
	{0xA066,0xd8  ,BYTE_LEN},
	{0xA067,0x87  ,BYTE_LEN},
	{0xA068,0x43  ,BYTE_LEN},
	{0xA069,0x2e  ,BYTE_LEN},
	{0xA06A,0xe2  ,BYTE_LEN},
	{0xA06B,0x13  ,BYTE_LEN},
	{0xA06C,0xab  ,BYTE_LEN},
	{0xA06D,0x3c  ,BYTE_LEN},
	{0xA06E,0x05  ,BYTE_LEN},
	{0xA06F,0x2e  ,BYTE_LEN},
	{0xA070,0x77  ,BYTE_LEN},
	{0xA071,0xc1  ,BYTE_LEN},
	{0xA072,0xcc  ,BYTE_LEN},
	{0xA073,0x57  ,BYTE_LEN},
	{0xA074,0xf2  ,BYTE_LEN},
	{0xA075,0x42  ,BYTE_LEN},
	{0xA076,0x92  ,BYTE_LEN},
	{0xA077,0x96  ,BYTE_LEN},
	{0xA078,0x10  ,BYTE_LEN},
	{0xA079,0x84  ,BYTE_LEN},
	{0xA07A,0x20  ,BYTE_LEN},
	{0xA07B,0xfd  ,BYTE_LEN},
	{0xA07C,0xe0  ,BYTE_LEN},
	{0xA07D,0x47  ,BYTE_LEN},
	{0xA07E,0x44  ,BYTE_LEN},
	{0xA07F,0x30  ,BYTE_LEN},
	{0xA080,0x12  ,BYTE_LEN},
	{0xA081,0x94  ,BYTE_LEN},
	{0xA082,0xab  ,BYTE_LEN},
	{0xA083,0x48  ,BYTE_LEN},
	{0xA084,0x25  ,BYTE_LEN},
	{0xA085,0x2e  ,BYTE_LEN},
	{0xA086,0x8d  ,BYTE_LEN},
	{0xA087,0x89  ,BYTE_LEN},
	{0xA088,0x0d  ,BYTE_LEN},
	{0xA089,0x5e  ,BYTE_LEN},
	{0xA08A,0x2a  ,BYTE_LEN},
	{0xA08B,0x13  ,BYTE_LEN},
	{0xA08C,0x14  ,BYTE_LEN},
	{0xA08D,0xa9  ,BYTE_LEN},
	{0xA08E,0x7c  ,BYTE_LEN},
	{0xA08F,0xc4  ,BYTE_LEN},
	{0xA090,0x24  ,BYTE_LEN},
	{0xA091,0x19  ,BYTE_LEN},
	{0xA092,0xf1  ,BYTE_LEN},
	{0xA093,0x48  ,BYTE_LEN},
	{0xA094,0x4c  ,BYTE_LEN},
	{0xA095,0x78  ,BYTE_LEN},
	{0xA096,0xb2  ,BYTE_LEN},
	{0xA097,0x95  ,BYTE_LEN},
	{0xA098,0xbb  ,BYTE_LEN},
	{0xA099,0xb0  ,BYTE_LEN},
	{0xA09A,0xc5  ,BYTE_LEN},
	{0xA09B,0x31  ,BYTE_LEN},
	{0xA09C,0xb4  ,BYTE_LEN},
	{0xA09D,0x21  ,BYTE_LEN},
	{0xA09E,0xcf  ,BYTE_LEN},
	{0xA09F,0x69  ,BYTE_LEN},
	{0xA0A0,0xa0  ,BYTE_LEN},
	{0xA0A1,0x23  ,BYTE_LEN},
	{0xA0A2,0x97  ,BYTE_LEN},
	{0xA0A3,0xc8  ,BYTE_LEN},
	{0xA0A4,0x50  ,BYTE_LEN},
	{0xA0A5,0xc5  ,BYTE_LEN},
	{0xA0A6,0x2d  ,BYTE_LEN},
	{0xA0A7,0x4e  ,BYTE_LEN},
	{0xA0A8,0x31  ,BYTE_LEN},
	{0xA0A9,0x8b  ,BYTE_LEN},
	{0xA0AA,0x58  ,BYTE_LEN},
	{0xA0AB,0xfe  ,BYTE_LEN},
	{0xA0AC,0x12  ,BYTE_LEN},
	{0xA0AD,0x99  ,BYTE_LEN},
	{0xA0AE,0xdd  ,BYTE_LEN},
	{0xA0AF,0x78  ,BYTE_LEN},
	{0xA0B0,0x66  ,BYTE_LEN},
	{0xA0B1,0x39  ,BYTE_LEN},
	{0xA0B2,0xda  ,BYTE_LEN},
	{0xA0B3,0x69  ,BYTE_LEN},
	{0xA0B4,0xd0  ,BYTE_LEN},
	{0xA0B5,0x76  ,BYTE_LEN},
	{0xA0B6,0x18  ,BYTE_LEN},
	{0xA0B7,0x34  ,BYTE_LEN},
	{0xA0B8,0x9b  ,BYTE_LEN},
	{0xA0B9,0xf3  ,BYTE_LEN},
	{0xA0BA,0x70  ,BYTE_LEN},
	{0xA0BB,0xc6  ,BYTE_LEN},
	{0xA0BC,0x39  ,BYTE_LEN},
	{0xA0BD,0x98  ,BYTE_LEN},
	{0xA0BE,0x29  ,BYTE_LEN},
	{0xA0BF,0x4e  ,BYTE_LEN},
	{0xA0C0,0x6a  ,BYTE_LEN},
	{0xA0C1,0xb8  ,BYTE_LEN},
	{0xA0C2,0x23  ,BYTE_LEN},
	{0xA0C3,0x1d  ,BYTE_LEN},
	{0xA0C4,0x04  ,BYTE_LEN},
	{0xA0C5,0x59  ,BYTE_LEN},
	{0xA0C6,0x87  ,BYTE_LEN},
	{0xA0C7,0x41  ,BYTE_LEN},
	{0xA0C8,0xc6  ,BYTE_LEN},
	{0xA0C9,0xd1  ,BYTE_LEN},
	{0xA0CA,0x0f  ,BYTE_LEN},
	{0xA0CB,0x74  ,BYTE_LEN},
	{0xA0CC,0x0a  ,BYTE_LEN},
	{0xA0CD,0xa4  ,BYTE_LEN},
	{0xA0CE,0x1b  ,BYTE_LEN},
	{0xA0CF,0xfa  ,BYTE_LEN},
	{0xA0D0,0x90  ,BYTE_LEN},
	{0xA0D1,0xa6  ,BYTE_LEN},
	{0xA0D2,0x3b  ,BYTE_LEN},
	{0xA0D3,0xa1  ,BYTE_LEN},
	{0xA0D4,0xb1  ,BYTE_LEN},
	{0xA0D5,0x4e  ,BYTE_LEN},
	{0xA0D6,0x6d  ,BYTE_LEN},
	{0xA0D7,0xdc  ,BYTE_LEN},
	{0xA0D8,0xf3  ,BYTE_LEN},
	{0xA0D9,0x1c  ,BYTE_LEN},
	{0xA0DA,0x04  ,BYTE_LEN},
	{0xA0DB,0x21  ,BYTE_LEN},
	{0xA0DC,0xe7  ,BYTE_LEN},
	{0xA0DD,0x3f  ,BYTE_LEN},
	{0xA0DE,0xab  ,BYTE_LEN},
	{0xA0DF,0x49  ,BYTE_LEN},
	{0xA0E0,0x0e  ,BYTE_LEN},
	{0xA0E1,0x6b  ,BYTE_LEN},
	{0xA0E2,0x92  ,BYTE_LEN},
	{0xA0E3,0x13  ,BYTE_LEN},
	{0xA0E4,0x1a  ,BYTE_LEN},
	{0xA0E5,0xdc  ,BYTE_LEN},
	{0xA0E6,0x44  ,BYTE_LEN},
	{0xA0E7,0x66  ,BYTE_LEN},
	{0xA0E8,0x34  ,BYTE_LEN},
	{0xA0E9,0x8f  ,BYTE_LEN},
	{0xA0EA,0x11  ,BYTE_LEN},
	{0xA0EB,0xcd  ,BYTE_LEN},
	{0xA0EC,0x67  ,BYTE_LEN},
	{0xA0ED,0x6a  ,BYTE_LEN},
	{0xA0EE,0x73  ,BYTE_LEN},
	{0xA0EF,0x9b  ,BYTE_LEN},
	{0xA0F0,0xe8  ,BYTE_LEN},
	{0xA0F1,0xc8  ,BYTE_LEN},
	{0xA0F2,0x66  ,BYTE_LEN},
	{0xA0F3,0x39  ,BYTE_LEN},
	{0xA0F4,0xb0  ,BYTE_LEN},
	{0xA0F5,0x69  ,BYTE_LEN},
	{0xA0F6,0xce  ,BYTE_LEN},
	{0xA0F7,0x6b  ,BYTE_LEN},
	{0xA0F8,0x98  ,BYTE_LEN},
	{0xA0F9,0x43  ,BYTE_LEN},
	{0xA0FA,0x99  ,BYTE_LEN},
	{0xA0FB,0xd5  ,BYTE_LEN},
	{0xA0FC,0x10  ,BYTE_LEN},
	{0xA0FD,0x86  ,BYTE_LEN},
	{0xA0FE,0x32  ,BYTE_LEN},
	{0xA0FF,0x80  ,BYTE_LEN},
	{0xA100,0x89  ,BYTE_LEN},
	{0xA101,0x8c  ,BYTE_LEN},
	{0xA102,0x63  ,BYTE_LEN},
	{0xA103,0x44  ,BYTE_LEN},
	{0xA104,0x33  ,BYTE_LEN},
	{0xA105,0x1b  ,BYTE_LEN},
	{0xA106,0xe6  ,BYTE_LEN},
	{0xA107,0xd4  ,BYTE_LEN},
	{0xA108,0xc6  ,BYTE_LEN},
	{0xA109,0x39  ,BYTE_LEN},
	{0xA10A,0x92  ,BYTE_LEN},
	{0xA10B,0x41  ,BYTE_LEN},
	{0xA10C,0x8d  ,BYTE_LEN},
	{0xA10D,0x61  ,BYTE_LEN},
	{0xA10E,0x38  ,BYTE_LEN},
	{0xA10F,0xb3  ,BYTE_LEN},
	{0xA110,0x15  ,BYTE_LEN},
	{0xA111,0xb5  ,BYTE_LEN},
	{0xA112,0x10  ,BYTE_LEN},
	{0xA113,0xc5  ,BYTE_LEN},
	{0xA114,0x29  ,BYTE_LEN},
	{0xA115,0x40  ,BYTE_LEN},
	{0xA116,0x49  ,BYTE_LEN},
	{0xA117,0xca  ,BYTE_LEN},
	{0xA118,0x53  ,BYTE_LEN},
	{0xA119,0xb6  ,BYTE_LEN},
	{0xA11A,0x82  ,BYTE_LEN},
	{0xA11B,0x17  ,BYTE_LEN},
	{0xA11C,0xc4  ,BYTE_LEN},
	{0xA11D,0x08  ,BYTE_LEN},
	{0xA11E,0x66  ,BYTE_LEN},
	{0xA11F,0x32  ,BYTE_LEN},
	{0xA120,0x6f  ,BYTE_LEN},
	{0xA121,0x21  ,BYTE_LEN},
	{0xA122,0xcc  ,BYTE_LEN},
	{0xA123,0x57  ,BYTE_LEN},
	{0xA124,0xe2  ,BYTE_LEN},
	{0xA125,0x32  ,BYTE_LEN},
	{0xA126,0x13  ,BYTE_LEN},
	{0xA127,0x9f  ,BYTE_LEN},
	{0xA128,0x60  ,BYTE_LEN},
	{0xA129,0x84  ,BYTE_LEN},
	{0xA12A,0x23  ,BYTE_LEN},
	{0xA12B,0x13  ,BYTE_LEN},
	{0xA12C,0xb1  ,BYTE_LEN},
	{0xA12D,0x48  ,BYTE_LEN},
	{0xA12E,0x49  ,BYTE_LEN},
	{0xA12F,0x56  ,BYTE_LEN},
	{0xA130,0xa2  ,BYTE_LEN},
	{0xA131,0x94  ,BYTE_LEN},
	{0xA132,0xab  ,BYTE_LEN},
	{0xA133,0x5c  ,BYTE_LEN},
	{0xA134,0xc5  ,BYTE_LEN},
	{0xA135,0x2c  ,BYTE_LEN},
	{0xA136,0x61  ,BYTE_LEN},
	{0xA137,0x91  ,BYTE_LEN},
	{0xA138,0x4b  ,BYTE_LEN},
	{0xA139,0x53  ,BYTE_LEN},
	{0xA13A,0xba  ,BYTE_LEN},
	{0xA13B,0xc2  ,BYTE_LEN},
	{0xA13C,0x11  ,BYTE_LEN},
	{0xA13D,0x92  ,BYTE_LEN},
	{0xA13E,0x08  ,BYTE_LEN},
	{0xA13F,0x64  ,BYTE_LEN},
	{0xA140,0x20  ,BYTE_LEN},
	{0xA141,0xfd  ,BYTE_LEN},
	{0xA142,0xe0  ,BYTE_LEN},
	{0xA143,0x87  ,BYTE_LEN},
	{0xA144,0x43  ,BYTE_LEN},
	{0xA145,0x1e  ,BYTE_LEN},
	{0xA146,0x62  ,BYTE_LEN},
	{0xA147,0x93  ,BYTE_LEN},
	{0xA148,0x9f  ,BYTE_LEN},
	{0xA149,0x0c  ,BYTE_LEN},
	{0xA14A,0x05  ,BYTE_LEN},
	{0xA14B,0x2a  ,BYTE_LEN},
	{0xA14C,0x66  ,BYTE_LEN},
	{0xA14D,0x89  ,BYTE_LEN},
	{0xA14E,0x4b  ,BYTE_LEN},
	{0xA14F,0x54  ,BYTE_LEN},
	{0xA150,0xb8  ,BYTE_LEN},
	{0xA151,0xd2  ,BYTE_LEN},
	{0xA152,0x91  ,BYTE_LEN},
	{0xA153,0x91  ,BYTE_LEN},
	{0xA154,0x04  ,BYTE_LEN},
	{0xA155,0x64  ,BYTE_LEN},
	{0xA156,0x20  ,BYTE_LEN},
	{0xA157,0xfe  ,BYTE_LEN},
	{0xA158,0xe0  ,BYTE_LEN},
	{0xA159,0x07  ,BYTE_LEN},
	{0xA15A,0x44  ,BYTE_LEN},
	{0xA15B,0x20  ,BYTE_LEN},
	{0xA15C,0x72  ,BYTE_LEN},
	{0xA15D,0x13  ,BYTE_LEN},
	{0xA15E,0xa0  ,BYTE_LEN},
	{0xA15F,0x14  ,BYTE_LEN},
	{0xA160,0x45  ,BYTE_LEN},
	{0xA161,0x2a  ,BYTE_LEN},
	{0xA162,0x7e  ,BYTE_LEN},
	{0xA163,0x31  ,BYTE_LEN},
	{0xA164,0xcc  ,BYTE_LEN},
	{0xA165,0x5a  ,BYTE_LEN},
	{0xA166,0xe6  ,BYTE_LEN},
	{0xA167,0xa2  ,BYTE_LEN},
	{0xA168,0x93  ,BYTE_LEN},
	{0xA169,0x9f  ,BYTE_LEN},
	{0xA16A,0x68  ,BYTE_LEN},
	{0xA16B,0x84  ,BYTE_LEN},
	{0xA16C,0x23  ,BYTE_LEN},
	{0xA16D,0x15  ,BYTE_LEN},
	{0xA16E,0xb1  ,BYTE_LEN},
	{0xA16F,0x08  ,BYTE_LEN},
	{0xA170,0x4a  ,BYTE_LEN},
	{0xA171,0x5c  ,BYTE_LEN},
	{0xA172,0xc2  ,BYTE_LEN},
	{0xA173,0x14  ,BYTE_LEN},
	{0xA174,0xad  ,BYTE_LEN},
	{0xA175,0x64  ,BYTE_LEN},
	{0xA176,0x45  ,BYTE_LEN},
	{0xA177,0x2d  ,BYTE_LEN},
	{0xA178,0xa9  ,BYTE_LEN},
	{0xA179,0x81  ,BYTE_LEN},
	{0xA17A,0xcd  ,BYTE_LEN},
	{0xA17B,0x66  ,BYTE_LEN},
	{0xA17C,0x46  ,BYTE_LEN},
	{0xA17D,0x93  ,BYTE_LEN},
	{0xA17E,0x96  ,BYTE_LEN},
	{0xA17F,0xb7  ,BYTE_LEN},
	{0xA180,0x34  ,BYTE_LEN},
	{0xA181,0x45  ,BYTE_LEN},
	{0xA182,0x2a  ,BYTE_LEN},
	{0xA183,0x46  ,BYTE_LEN},
	{0xA184,0x69  ,BYTE_LEN},
	{0xA185,0x0a  ,BYTE_LEN},
	{0xA186,0x55  ,BYTE_LEN},
	{0xA187,0xc4  ,BYTE_LEN},
	{0xA188,0xb2  ,BYTE_LEN},
	{0xA189,0x17  ,BYTE_LEN},
	{0xA18A,0xc9  ,BYTE_LEN},
	{0xA18B,0x18  ,BYTE_LEN},
	{0xA18C,0xc6  ,BYTE_LEN},
	{0xA18D,0x33  ,BYTE_LEN},
	{0xA18E,0xcd  ,BYTE_LEN},
	{0xA18F,0xb9  ,BYTE_LEN},
	{0xA190,0x4e  ,BYTE_LEN},
	{0xA191,0x73  ,BYTE_LEN},
	{0xA192,0xb0  ,BYTE_LEN},
	{0xA193,0x83  ,BYTE_LEN},
	{0xA194,0x9a  ,BYTE_LEN},
	{0xA195,0xd9  ,BYTE_LEN},
	{0xA196,0x44  ,BYTE_LEN},
	{0xA197,0x86  ,BYTE_LEN},
	{0xA198,0x33  ,BYTE_LEN},
	{0xA199,0x8d  ,BYTE_LEN},
	{0xA19A,0xd1  ,BYTE_LEN},
	{0xA19B,0x0c  ,BYTE_LEN},
	{0xA19C,0x66  ,BYTE_LEN},
	{0xA19D,0x5e  ,BYTE_LEN},
	{0xA19E,0x43  ,BYTE_LEN},
	{0xA19F,0x1b  ,BYTE_LEN},
	{0xA1A0,0xec  ,BYTE_LEN},
	{0xA1A1,0xd0  ,BYTE_LEN},
	{0xA1A2,0x46  ,BYTE_LEN},
	{0xA1A3,0x3b  ,BYTE_LEN},
	{0xA1A4,0xb8  ,BYTE_LEN},
	{0xA1A5,0x09  ,BYTE_LEN},
	{0xA1A6,0x4e  ,BYTE_LEN},
	{0xA1A7,0x71  ,BYTE_LEN},
	{0xA1A8,0x9c  ,BYTE_LEN},
	{0xA1A9,0xf3  ,BYTE_LEN},
	{0xA1AA,0x9a  ,BYTE_LEN},
	{0xA1AB,0xdd  ,BYTE_LEN},
	{0xA1AC,0x64  ,BYTE_LEN},
	{0xA1AD,0xa6  ,BYTE_LEN},
	{0xA1AE,0x34  ,BYTE_LEN},
	{0xA1AF,0x95  ,BYTE_LEN},
	{0xA1B0,0x31  ,BYTE_LEN},
	{0xA1B1,0xcd  ,BYTE_LEN},
	{0xA1B2,0x68  ,BYTE_LEN},
	{0xA1B3,0x78  ,BYTE_LEN},
	{0xA1B4,0x23  ,BYTE_LEN},
	{0xA1B5,0x1b  ,BYTE_LEN},
	{0xA1B6,0xeb  ,BYTE_LEN},
	{0xA1B7,0xac  ,BYTE_LEN},
	{0xA1B8,0x06  ,BYTE_LEN},
	{0xA1B9,0x3a  ,BYTE_LEN},
	{0xA1BA,0xdc  ,BYTE_LEN},
	{0xA1BB,0xc9  ,BYTE_LEN},
	{0xA1BC,0xce  ,BYTE_LEN},
	{0xA1BD,0x72  ,BYTE_LEN},
	{0xA1BE,0x7c  ,BYTE_LEN},
	{0xA1BF,0xb3  ,BYTE_LEN},
	{0xA1C0,0x1b  ,BYTE_LEN},
	{0xA1C1,0xe6  ,BYTE_LEN},
	{0xA1C2,0x84  ,BYTE_LEN},
	{0xA1C3,0x47  ,BYTE_LEN},
	{0xA1C4,0x3b  ,BYTE_LEN},
	{0xA1C5,0xdd  ,BYTE_LEN},
	{0xA1C6,0xe1  ,BYTE_LEN},
	{0xA1C7,0x8e  ,BYTE_LEN},
	{0xA1C8,0x6e  ,BYTE_LEN},
	{0xA1C9,0x4e  ,BYTE_LEN},
	{0xA1CA,0x33  ,BYTE_LEN},
	{0xA1CB,0x1a  ,BYTE_LEN},
	{0xA1CC,0xda  ,BYTE_LEN},
	{0xA1CD,0x70  ,BYTE_LEN},
	{0xA1CE,0xc7  ,BYTE_LEN},
	{0xA1CF,0x3b  ,BYTE_LEN},
	{0xA1D0,0xb8  ,BYTE_LEN},
	{0xA1D1,0x49  ,BYTE_LEN},
	{0xA1D2,0x0d  ,BYTE_LEN},
	{0xA1D3,0x5c  ,BYTE_LEN},
	{0xA1D4,0xa2  ,BYTE_LEN},
	{0xA1D5,0xd2  ,BYTE_LEN},
	{0xA1D6,0x14  ,BYTE_LEN},
	{0xA1D7,0xb1  ,BYTE_LEN},
	{0xA1D8,0x5c  ,BYTE_LEN},
	{0xA1D9,0x26  ,BYTE_LEN},
	{0xA1DA,0x35  ,BYTE_LEN},
	{0xA1DB,0x90  ,BYTE_LEN},
	{0xA1DC,0xb9  ,BYTE_LEN},
	{0xA1DD,0x4b  ,BYTE_LEN},
	{0xA1DE,0x4f  ,BYTE_LEN},
	{0xA1DF,0x34  ,BYTE_LEN},
	{0xA1E0,0x42  ,BYTE_LEN},
	{0xA1E1,0x11  ,BYTE_LEN},
	{0xA1E2,0x96  ,BYTE_LEN},
	{0xA1E3,0x80  ,BYTE_LEN},
	{0xA1E4,0xa5  ,BYTE_LEN},
	{0xA1E5,0x2e  ,BYTE_LEN},
	{0xA1E6,0x7a  ,BYTE_LEN},
	{0xA1E7,0x01  ,BYTE_LEN},
	{0xA1E8,0x8b  ,BYTE_LEN},
	{0xA1E9,0x48  ,BYTE_LEN},
	{0xA1EA,0x02  ,BYTE_LEN},
	{0xA1EB,0xb2  ,BYTE_LEN},
	{0xA1EC,0x8f  ,BYTE_LEN},
	{0xA1ED,0x88  ,BYTE_LEN},
	{0xA1EE,0x18  ,BYTE_LEN},
	{0xA1EF,0x85  ,BYTE_LEN},
	{0xA1F0,0x2b  ,BYTE_LEN},
	{0xA1F1,0x7e  ,BYTE_LEN},
	{0xA1F2,0x21  ,BYTE_LEN},
	{0xA1F3,0x4b  ,BYTE_LEN},
	{0xA1F4,0x49  ,BYTE_LEN},
	{0xA1F5,0x08  ,BYTE_LEN},
	{0xA1F6,0xd2  ,BYTE_LEN},
	{0xA1F7,0x8f  ,BYTE_LEN},
	{0xA1F8,0x89  ,BYTE_LEN},
	{0xA1F9,0x20  ,BYTE_LEN},
	{0xA1FA,0xc5  ,BYTE_LEN},
	{0xA1FB,0x2b  ,BYTE_LEN},
	{0xA1FC,0x97  ,BYTE_LEN},
	{0xA1FD,0xf9  ,BYTE_LEN},
	{0xA1FE,0x4b  ,BYTE_LEN},
	{0xA1FF,0x51  ,BYTE_LEN},
	{0xA200,0x40  ,BYTE_LEN},
	{0xA201,0x92  ,BYTE_LEN},
	{0xA202,0x11  ,BYTE_LEN},
	{0xA203,0x99  ,BYTE_LEN},
	{0xA204,0x94  ,BYTE_LEN},
	{0xA205,0x45  ,BYTE_LEN},
	{0xA206,0x2f  ,BYTE_LEN},
	{0xA207,0xc7  ,BYTE_LEN},
	{0xA208,0xc1  ,BYTE_LEN},
	{0xA209,0x8d  ,BYTE_LEN},
	{0xA20A,0x5f  ,BYTE_LEN},
	{0xA20B,0xba  ,BYTE_LEN},
	{0xA20C,0x52  ,BYTE_LEN},
	{0xA20D,0x15  ,BYTE_LEN},
	{0xA20E,0xb6  ,BYTE_LEN},
	{0xA20F,0x90  ,BYTE_LEN},
	{0xA210,0x86  ,BYTE_LEN},
	{0xA211,0x36  ,BYTE_LEN},
	{0xA212,0xee  ,BYTE_LEN},
	{0xA213,0x79  ,BYTE_LEN},
	{0xA214,0x0f  ,BYTE_LEN},
	{0xA215,0x73  ,BYTE_LEN},
	{0xA216,0x68  ,BYTE_LEN},
	{0xA217,0xc3  ,BYTE_LEN},
	{0xA218,0x1a  ,BYTE_LEN},
	{0xA219,0xe1  ,BYTE_LEN},
	{0xA21A,0xb8  ,BYTE_LEN},
	{0xA21B,0x27  ,BYTE_LEN},
	{0xA21C,0x3e  ,BYTE_LEN},
	{0xA21D,0xda  ,BYTE_LEN},
	{0xA21E,0x29  ,BYTE_LEN},
	{0xA21F,0xcf  ,BYTE_LEN},
	{0xA220,0x75  ,BYTE_LEN},
	{0xA221,0x86  ,BYTE_LEN},
	{0xA222,0xe3  ,BYTE_LEN},
	{0xA223,0x1b  ,BYTE_LEN},
	{0xA224,0xea  ,BYTE_LEN},
	{0xA225,0xb4  ,BYTE_LEN},
	{0xA226,0xa7  ,BYTE_LEN},
	{0xA227,0x3c  ,BYTE_LEN},
	{0x0068,0x57  ,BYTE_LEN},
	{0x4001,0x00  ,BYTE_LEN},
	{0x4A04,0x0010,WORD_LEN},
	{0x4A06,0x260E,WORD_LEN},
	{0x4A08,0x3D01,WORD_LEN},
	{0x4A0A,0x3202,WORD_LEN},
	{0x4A0C,0x00  ,BYTE_LEN},
	{0x4A0D,0x00  ,BYTE_LEN},
	{0x4A0E,0x05  ,BYTE_LEN},
	{0x4A10,0x830A,WORD_LEN},
	{0x4A12,0x2D1C,WORD_LEN},
	{0x4A14,0x81  ,BYTE_LEN},
	{0x4A15,0x87  ,BYTE_LEN},
	{0x4A16,0x0000,WORD_LEN},
	{0x4A18,0x0000,WORD_LEN},
	{0x4A1A,0x0004,WORD_LEN},
	{0x4A1C,0x0004,WORD_LEN},
	{0x4A1E,0x0004,WORD_LEN},
	{0x4A20,0x0004,WORD_LEN},
	{0x4A22,0x0000,WORD_LEN},
	{0x4A24,0x1000,WORD_LEN},
	{0x4A26,0x0000,WORD_LEN},
	{0x4A28,0xECFF,WORD_LEN},
	{0x4A2A,0x0000,WORD_LEN},
	{0x4A2C,0xF7FF,WORD_LEN},
	{0x0084,0x4A01,WORD_LEN},
	{0x0086,0x9802,WORD_LEN},
	{0x0088,0xE204,WORD_LEN},
	{0x008A,0x960A,WORD_LEN},
	{0x008C,0xD007,WORD_LEN},
	{0x008E,0x0000,WORD_LEN},
	{0x0090,0x0000,WORD_LEN},
	{0x0092,0x0000,WORD_LEN},
	{0x400E,0x0024,WORD_LEN},
	{0x4012,0xF224,WORD_LEN},
	{0x4014,0x090C,WORD_LEN},
	{0x42BD,0x00  ,BYTE_LEN},
	{0x42BE,0x00  ,BYTE_LEN},
	{0x42BF,0x00  ,BYTE_LEN},
	{0x42C0,0x00  ,BYTE_LEN},
	{0x42C1,0x00  ,BYTE_LEN},
	{0x42C2,0x00  ,BYTE_LEN},
	{0x42C3,0x00  ,BYTE_LEN},
	{0x42C4,0x00  ,BYTE_LEN},
	{0x42C5,0x00  ,BYTE_LEN},
	{0x42C6,0x00  ,BYTE_LEN},
	{0x42C7,0x10  ,BYTE_LEN},
	{0x42C8,0x16  ,BYTE_LEN},
	{0x42C9,0x1C  ,BYTE_LEN},
	{0x42CA,0x1F  ,BYTE_LEN},
	{0x42CB,0x1C  ,BYTE_LEN},
	{0x42CC,0x16  ,BYTE_LEN},
	{0x42CD,0x10  ,BYTE_LEN},
	{0x42CE,0x00  ,BYTE_LEN},
	{0x42CF,0x00  ,BYTE_LEN},
	{0x42D0,0x19  ,BYTE_LEN},
	{0x42D1,0x21  ,BYTE_LEN},
	{0x42D2,0x32  ,BYTE_LEN},
	{0x42D3,0x47  ,BYTE_LEN},
	{0x42D4,0x32  ,BYTE_LEN},
	{0x42D5,0x21  ,BYTE_LEN},
	{0x42D6,0x19  ,BYTE_LEN},
	{0x42D7,0x00  ,BYTE_LEN},
	{0x42D8,0x00  ,BYTE_LEN},
	{0x42D9,0x1C  ,BYTE_LEN},
	{0x42DA,0x50  ,BYTE_LEN},
	{0x42DB,0x52  ,BYTE_LEN},
	{0x42DC,0x52  ,BYTE_LEN},
	{0x42DD,0x52  ,BYTE_LEN},
	{0x42DE,0x50  ,BYTE_LEN},
	{0x42DF,0x1C  ,BYTE_LEN},
	{0x42E0,0x00  ,BYTE_LEN},
	{0x42E1,0x00  ,BYTE_LEN},
	{0x42E2,0x1C  ,BYTE_LEN},
	{0x42E3,0x2B  ,BYTE_LEN},
	{0x42E4,0x52  ,BYTE_LEN},
	{0x42E5,0x64  ,BYTE_LEN},
	{0x42E6,0x52  ,BYTE_LEN},
	{0x42E7,0x2B  ,BYTE_LEN},
	{0x42E8,0x1C  ,BYTE_LEN},
	{0x42E9,0x00  ,BYTE_LEN},
	{0x42EA,0x00  ,BYTE_LEN},
	{0x42EB,0x19  ,BYTE_LEN},
	{0x42EC,0x21  ,BYTE_LEN},
	{0x42ED,0x32  ,BYTE_LEN},
	{0x42EE,0x32  ,BYTE_LEN},
	{0x42EF,0x32  ,BYTE_LEN},
	{0x42F0,0x21  ,BYTE_LEN},
	{0x42F1,0x19  ,BYTE_LEN},
	{0x42F2,0x00  ,BYTE_LEN},
	{0x42F3,0x00  ,BYTE_LEN},
	{0x42F4,0x00  ,BYTE_LEN},
	{0x42F5,0x00  ,BYTE_LEN},
	{0x42F6,0x00  ,BYTE_LEN},
	{0x42F7,0x00  ,BYTE_LEN},
	{0x42F8,0x00  ,BYTE_LEN},
	{0x42F9,0x00  ,BYTE_LEN},
	{0x42FA,0x00  ,BYTE_LEN},
	{0x42FB,0x00  ,BYTE_LEN},
	{0x5200,0x0000,WORD_LEN},
	{0x5202,0x0100,WORD_LEN},
	{0x5204,0x0300,WORD_LEN},
	{0x5206,0x0C00,WORD_LEN},
	{0x5208,0x1500,WORD_LEN},
	{0x520A,0x2000,WORD_LEN},
	{0x520C,0x2A00,WORD_LEN},
	{0x520E,0x3200,WORD_LEN},
	{0x5210,0x3900,WORD_LEN},
	{0x5212,0x4100,WORD_LEN},
	{0x5214,0x4700,WORD_LEN},
	{0x5216,0x4D00,WORD_LEN},
	{0x5218,0x5200,WORD_LEN},
	{0x521A,0x5700,WORD_LEN},
	{0x521C,0x5B00,WORD_LEN},
	{0x521E,0x6000,WORD_LEN},
	{0x5220,0x6300,WORD_LEN},
	{0x5222,0x6A00,WORD_LEN},
	{0x5224,0x5000,WORD_LEN},
	{0x5226,0x7B00,WORD_LEN},
	{0x5228,0xA500,WORD_LEN},
	{0x522A,0xC200,WORD_LEN},
	{0x522C,0xD800,WORD_LEN},
	{0x522E,0xEA00,WORD_LEN},
	{0x5230,0xF500,WORD_LEN},
	{0x5232,0xFF00,WORD_LEN},
	{0x5234,0x0401,WORD_LEN},
	{0x5236,0x0000,WORD_LEN},
	{0x5238,0x0100,WORD_LEN},
	{0x523A,0x0300,WORD_LEN},
	{0x523C,0x0C00,WORD_LEN},
	{0x523E,0x1500,WORD_LEN},
	{0x5240,0x2000,WORD_LEN},
	{0x5242,0x2A00,WORD_LEN},
	{0x5244,0x3200,WORD_LEN},
	{0x5246,0x3900,WORD_LEN},
	{0x5248,0x4100,WORD_LEN},
	{0x524A,0x4700,WORD_LEN},
	{0x524C,0x4D00,WORD_LEN},
	{0x524E,0x5200,WORD_LEN},
	{0x5250,0x5700,WORD_LEN},
	{0x5252,0x5B00,WORD_LEN},
	{0x5254,0x6000,WORD_LEN},
	{0x5256,0x6300,WORD_LEN},
	{0x5258,0x6A00,WORD_LEN},
	{0x525A,0x5000,WORD_LEN},
	{0x525C,0x7B00,WORD_LEN},
	{0x525E,0xA500,WORD_LEN},
	{0x5260,0xC200,WORD_LEN},
	{0x5262,0xD800,WORD_LEN},
	{0x5264,0xEA00,WORD_LEN},
	{0x5266,0xF500,WORD_LEN},
	{0x5268,0xFF00,WORD_LEN},
	{0x526A,0x0401,WORD_LEN},
	{0x526C,0x0000,WORD_LEN},
	{0x526E,0x0100,WORD_LEN},
	{0x5270,0x0300,WORD_LEN},
	{0x5272,0x0C00,WORD_LEN},
	{0x5274,0x1500,WORD_LEN},
	{0x5276,0x2000,WORD_LEN},
	{0x5278,0x2A00,WORD_LEN},
	{0x527A,0x3200,WORD_LEN},
	{0x527C,0x3900,WORD_LEN},
	{0x527E,0x4100,WORD_LEN},
	{0x5280,0x4700,WORD_LEN},
	{0x5282,0x4D00,WORD_LEN},
	{0x5284,0x5200,WORD_LEN},
	{0x5286,0x5700,WORD_LEN},
	{0x5288,0x5B00,WORD_LEN},
	{0x528A,0x6000,WORD_LEN},
	{0x528C,0x6300,WORD_LEN},
	{0x528E,0x6A00,WORD_LEN},
	{0x5290,0x5000,WORD_LEN},
	{0x5292,0x7B00,WORD_LEN},
	{0x5294,0xA500,WORD_LEN},
	{0x5296,0xC200,WORD_LEN},
	{0x5298,0xD800,WORD_LEN},
	{0x529A,0xEA00,WORD_LEN},
	{0x529C,0xF500,WORD_LEN},
	{0x529E,0xFF00,WORD_LEN},
	{0x52A0,0x0401,WORD_LEN},
	{0x52A2,0x1003,WORD_LEN},
	{0x52A4,0x0540,WORD_LEN},
	{0x52A6,0x1003,WORD_LEN},
	{0x52A8,0x0540,WORD_LEN},
	{0x52AA,0x1003,WORD_LEN},
	{0x52AC,0x0540,WORD_LEN},
	{0x52AE,0x0021,WORD_LEN},
	{0xC000,0xF7B5,WORD_LEN},
	{0xC002,0x0E4D,WORD_LEN},
	{0xC004,0x0E4C,WORD_LEN},
	{0xC006,0x0F4A,WORD_LEN},
	{0xC008,0x0F4F,WORD_LEN},
	{0xC00A,0x104B,WORD_LEN},
	{0xC00C,0x0021,WORD_LEN},
	{0xC00E,0x002A,WORD_LEN},
	{0xC010,0x04D9,WORD_LEN},
	{0xC012,0x6E5C,WORD_LEN},
	{0xC014,0x6654,WORD_LEN},
	{0xC016,0x0131,WORD_LEN},
	{0xC018,0x9142,WORD_LEN},
	{0xC01A,0xFAD3,WORD_LEN},
	{0xC01C,0x0021,WORD_LEN},
	{0xC01E,0x002B,WORD_LEN},
	{0xC020,0x04D9,WORD_LEN},
	{0xC022,0x0022,WORD_LEN},
	{0xC024,0x7A54,WORD_LEN},
	{0xC026,0x0131,WORD_LEN},
	{0xC028,0x9942,WORD_LEN},
	{0xC02A,0xFBD3,WORD_LEN},
	{0xC02C,0x0849,WORD_LEN},
	{0xC02E,0x8860,WORD_LEN},
	{0xC030,0x0199,WORD_LEN},
	{0xC032,0x0848,WORD_LEN},
	{0xC034,0x0860,WORD_LEN},
	{0xC036,0x03B0,WORD_LEN},
	{0xC038,0x0120,WORD_LEN},
	{0xC03A,0xF0BD,WORD_LEN},
	{0xC03C,0x840B,WORD_LEN},
	{0xC03E,0x1800,WORD_LEN},
	{0xC040,0x840B,WORD_LEN},
	{0xC042,0x1800,WORD_LEN},
	{0xC044,0x0400,WORD_LEN},
	{0xC046,0x0000,WORD_LEN},
	{0xC048,0x880B,WORD_LEN},
	{0xC04A,0x1800,WORD_LEN},
	{0xC04C,0x0C00,WORD_LEN},
	{0xC04E,0x0000,WORD_LEN},
	{0xC050,0x880B,WORD_LEN},
	{0xC052,0x1800,WORD_LEN},
	{0xC054,0x840B,WORD_LEN},
	{0xC056,0x1800,WORD_LEN},
	{0xC058,0x80B5,WORD_LEN},
	{0xC05A,0x1F78,WORD_LEN},
	{0xC05C,0x002F,WORD_LEN},
	{0xC05E,0x02D1,WORD_LEN},
	{0xC060,0x00F0,WORD_LEN},
	{0xC062,0xB8F8,WORD_LEN},
	{0xC064,0x80BD,WORD_LEN},
	{0xC066,0x00F0,WORD_LEN},
	{0xC068,0x01F8,WORD_LEN},
	{0xC06A,0xFBE7,WORD_LEN},
	{0xC06C,0xFFB5,WORD_LEN},
	{0xC06E,0x83B0,WORD_LEN},
	{0xC070,0x0C1C,WORD_LEN},
	{0xC072,0x1F1C,WORD_LEN},
	{0xC074,0x0025,WORD_LEN},
	{0xC076,0x0823,WORD_LEN},
	{0xC078,0xF85E,WORD_LEN},
	{0xC07A,0xEB43,WORD_LEN},
	{0xC07C,0x544E,WORD_LEN},
	{0xC07E,0x9842,WORD_LEN},
	{0xC080,0x28D1,WORD_LEN},
	{0xC082,0xF280,WORD_LEN},
	{0xC084,0xA01A,WORD_LEN},
	{0xC086,0x02D5,WORD_LEN},
	{0xC088,0x4042,WORD_LEN},
	{0xC08A,0x0121,WORD_LEN},
	{0xC08C,0x00E0,WORD_LEN},
	{0xC08E,0x0021,WORD_LEN},
	{0xC090,0x3170,WORD_LEN},
	{0xC092,0x0004,WORD_LEN},
	{0xC094,0x000C,WORD_LEN},
	{0xC096,0x7080,WORD_LEN},
	{0xC098,0xB080,WORD_LEN},
	{0xC09A,0x1BD1,WORD_LEN},
	{0xC09C,0x2001,WORD_LEN},
	{0xC09E,0x0004,WORD_LEN},
	{0xC0A0,0x000C,WORD_LEN},
	{0xC0A2,0x00AB,WORD_LEN},
	{0xC0A4,0x1880,WORD_LEN},
	{0xC0A6,0x00F0,WORD_LEN},
	{0xC0A8,0xEEF8,WORD_LEN},
	{0xC0AA,0x00AB,WORD_LEN},
	{0xC0AC,0x1880,WORD_LEN},
	{0xC0AE,0xB068,WORD_LEN},
	{0xC0B0,0x6A46,WORD_LEN},
	{0xC0B2,0x0221,WORD_LEN},
	{0xC0B4,0x0368,WORD_LEN},
	{0xC0B6,0x0C20,WORD_LEN},
	{0xC0B8,0x7FF6,WORD_LEN},
	{0xC0BA,0x7DFC,WORD_LEN},
	{0xC0BC,0x0128,WORD_LEN},
	{0xC0BE,0x04D0,WORD_LEN},
	{0xC0C0,0x0020,WORD_LEN},
	{0xC0C2,0xC043,WORD_LEN},
	{0xC0C4,0x3881,WORD_LEN},
	{0xC0C6,0x0020,WORD_LEN},
	{0xC0C8,0x7FE0,WORD_LEN},
	{0xC0CA,0x0398,WORD_LEN},
	{0xC0CC,0x0480,WORD_LEN},
	{0xC0CE,0x0120,WORD_LEN},
	{0xC0D0,0x3881,WORD_LEN},
	{0xC0D2,0x7AE0,WORD_LEN},
	{0xC0D4,0x7878,WORD_LEN},
	{0xC0D6,0x3E4E,WORD_LEN},
	{0xC0D8,0x0290,WORD_LEN},
	{0xC0DA,0xB978,WORD_LEN},
	{0xC0DC,0x4000,WORD_LEN},
	{0xC0DE,0x401A,WORD_LEN},
	{0xC0E0,0xF978,WORD_LEN},
	{0xC0E2,0x401A,WORD_LEN},
	{0xC0E4,0xB188,WORD_LEN},
	{0xC0E6,0x4900,WORD_LEN},
	{0xC0E8,0x7FF6,WORD_LEN},
	{0xC0EA,0x6AFC,WORD_LEN},
	{0xC0EC,0x0404,WORD_LEN},
	{0xC0EE,0x240C,WORD_LEN},
	{0xC0F0,0x388A,WORD_LEN},
	{0xC0F2,0xA042,WORD_LEN},
	{0xC0F4,0x02DA,WORD_LEN},
	{0xC0F6,0x0121,WORD_LEN},
	{0xC0F8,0x041C,WORD_LEN},
	{0xC0FA,0x00E0,WORD_LEN},
	{0xC0FC,0x0021,WORD_LEN},
	{0xC0FE,0x0191,WORD_LEN},
	{0xC100,0x0298,WORD_LEN},
	{0xC102,0x0026,WORD_LEN},
	{0xC104,0x0028,WORD_LEN},
	{0xC106,0x0BDD,WORD_LEN},
	{0xC108,0x301C,WORD_LEN},
	{0xC10A,0x211C,WORD_LEN},
	{0xC10C,0x3A1C,WORD_LEN},
	{0xC10E,0x00F0,WORD_LEN},
	{0xC110,0x9FF8,WORD_LEN},
	{0xC112,0x4019,WORD_LEN},
	{0xC114,0x0504,WORD_LEN},
	{0xC116,0x2D0C,WORD_LEN},
	{0xC118,0x7878,WORD_LEN},
	{0xC11A,0x0136,WORD_LEN},
	{0xC11C,0xB042,WORD_LEN},
	{0xC11E,0xF3DC,WORD_LEN},
	{0xC120,0x2B4E,WORD_LEN},
	{0xC122,0xB088,WORD_LEN},
	{0xC124,0x401B,WORD_LEN},
	{0xC126,0xB080,WORD_LEN},
	{0xC128,0x0823,WORD_LEN},
	{0xC12A,0xF85E,WORD_LEN},
	{0xC12C,0x0123,WORD_LEN},
	{0xC12E,0xD842,WORD_LEN},
	{0xC130,0x13D1,WORD_LEN},
	{0xC132,0x0199,WORD_LEN},
	{0xC134,0x0029,WORD_LEN},
	{0xC136,0x02D1,WORD_LEN},
	{0xC138,0x0121,WORD_LEN},
	{0xC13A,0x3981,WORD_LEN},
	{0xC13C,0x0DE0,WORD_LEN},
	{0xC13E,0x7188,WORD_LEN},
	{0xC140,0x281C,WORD_LEN},
	{0xC142,0x7FF6,WORD_LEN},
	{0xC144,0x87FB,WORD_LEN},
	{0xC146,0x3881,WORD_LEN},
	{0xC148,0x7188,WORD_LEN},
	{0xC14A,0x281C,WORD_LEN},
	{0xC14C,0x7FF6,WORD_LEN},
	{0xC14E,0x82FB,WORD_LEN},
	{0xC150,0x0029,WORD_LEN},
	{0xC152,0x02D0,WORD_LEN},
	{0xC154,0x3889,WORD_LEN},
	{0xC156,0x0130,WORD_LEN},
	{0xC158,0x3881,WORD_LEN},
	{0xC15A,0x7878,WORD_LEN},
	{0xC15C,0x0025,WORD_LEN},
	{0xC15E,0x0028,WORD_LEN},
	{0xC160,0x32DD,WORD_LEN},
	{0xC162,0x281C,WORD_LEN},
	{0xC164,0x211C,WORD_LEN},
	{0xC166,0x3A1C,WORD_LEN},
	{0xC168,0x00F0,WORD_LEN},
	{0xC16A,0x72F8,WORD_LEN},
	{0xC16C,0x0199,WORD_LEN},
	{0xC16E,0x0029,WORD_LEN},
	{0xC170,0x07D1,WORD_LEN},
	{0xC172,0xB188,WORD_LEN},
	{0xC174,0x0029,WORD_LEN},
	{0xC176,0x04DD,WORD_LEN},
	{0xC178,0x0130,WORD_LEN},
	{0xC17A,0x0004,WORD_LEN},
	{0xC17C,0x000C,WORD_LEN},
	{0xC17E,0x0139,WORD_LEN},
	{0xC180,0xB180,WORD_LEN},
	{0xC182,0x3178,WORD_LEN},
	{0xC184,0x0029,WORD_LEN},
	{0xC186,0x02D1,WORD_LEN},
	{0xC188,0xF188,WORD_LEN},
	{0xC18A,0x0818,WORD_LEN},
	{0xC18C,0x01E0,WORD_LEN},
	{0xC18E,0xF188,WORD_LEN},
	{0xC190,0x081A,WORD_LEN},
	{0xC192,0xF080,WORD_LEN},
	{0xC194,0xF088,WORD_LEN},
	{0xC196,0x00AB,WORD_LEN},
	{0xC198,0x0001,WORD_LEN},
	{0xC19A,0x0004,WORD_LEN},
	{0xC19C,0x000C,WORD_LEN},
	{0xC19E,0x1880,WORD_LEN},
	{0xC1A0,0x00F0,WORD_LEN},
	{0xC1A2,0x71F8,WORD_LEN},
	{0xC1A4,0x00AB,WORD_LEN},
	{0xC1A6,0x1880,WORD_LEN},
	{0xC1A8,0xB068,WORD_LEN},
	{0xC1AA,0x6A46,WORD_LEN},
	{0xC1AC,0x0221,WORD_LEN},
	{0xC1AE,0x0368,WORD_LEN},
	{0xC1B0,0x0C20,WORD_LEN},
	{0xC1B2,0x7FF6,WORD_LEN},
	{0xC1B4,0x00FC,WORD_LEN},
	{0xC1B6,0x0128,WORD_LEN},
	{0xC1B8,0x82D1,WORD_LEN},
	{0xC1BA,0xF088,WORD_LEN},
	{0xC1BC,0x0399,WORD_LEN},
	{0xC1BE,0x0880,WORD_LEN},
	{0xC1C0,0x7878,WORD_LEN},
	{0xC1C2,0x0135,WORD_LEN},
	{0xC1C4,0xA842,WORD_LEN},
	{0xC1C6,0xCCDC,WORD_LEN},
	{0xC1C8,0x0120,WORD_LEN},
	{0xC1CA,0x07B0,WORD_LEN},
	{0xC1CC,0xF0BD,WORD_LEN},
	{0xC1CE,0x0000,WORD_LEN},
	{0xC1D0,0x880B,WORD_LEN},
	{0xC1D2,0x1800,WORD_LEN},
	{0xC1D4,0xF8B5,WORD_LEN},
	{0xC1D6,0x1C1C,WORD_LEN},
	{0xC1D8,0x151C,WORD_LEN},
	{0xC1DA,0x061C,WORD_LEN},
	{0xC1DC,0x0F1C,WORD_LEN},
	{0xC1DE,0x3801,WORD_LEN},
	{0xC1E0,0x0004,WORD_LEN},
	{0xC1E2,0x000C,WORD_LEN},
	{0xC1E4,0x00AB,WORD_LEN},
	{0xC1E6,0x1880,WORD_LEN},
	{0xC1E8,0x00F0,WORD_LEN},
	{0xC1EA,0x4DF8,WORD_LEN},
	{0xC1EC,0x00AB,WORD_LEN},
	{0xC1EE,0x1880,WORD_LEN},
	{0xC1F0,0x0948,WORD_LEN},
	{0xC1F2,0x6A46,WORD_LEN},
	{0xC1F4,0x8068,WORD_LEN},
	{0xC1F6,0x0221,WORD_LEN},
	{0xC1F8,0x0368,WORD_LEN},
	{0xC1FA,0x0C20,WORD_LEN},
	{0xC1FC,0x7FF6,WORD_LEN},
	{0xC1FE,0xDBFB,WORD_LEN},
	{0xC200,0x0128,WORD_LEN},
	{0xC202,0x01D0,WORD_LEN},
	{0xC204,0x0020,WORD_LEN},
	{0xC206,0x06E0,WORD_LEN},
	{0xC208,0x381C,WORD_LEN},
	{0xC20A,0x291C,WORD_LEN},
	{0xC20C,0x221C,WORD_LEN},
	{0xC20E,0x3780,WORD_LEN},
	{0xC210,0x00F0,WORD_LEN},
	{0xC212,0x04F8,WORD_LEN},
	{0xC214,0x0120,WORD_LEN},
	{0xC216,0xF8BD,WORD_LEN},
	{0xC218,0x880B,WORD_LEN},
	{0xC21A,0x1800,WORD_LEN},
	{0xC21C,0x80B5,WORD_LEN},
	{0xC21E,0x171C,WORD_LEN},
	{0xC220,0x401A,WORD_LEN},
	{0xC222,0x00D5,WORD_LEN},
	{0xC224,0x4042,WORD_LEN},
	{0xC226,0xBA89,WORD_LEN},
	{0xC228,0x0109,WORD_LEN},
	{0xC22A,0x5143,WORD_LEN},
	{0xC22C,0x0007,WORD_LEN},
	{0xC22E,0x000F,WORD_LEN},
	{0xC230,0x00D0,WORD_LEN},
	{0xC232,0x5118,WORD_LEN},
	{0xC234,0xF889,WORD_LEN},
	{0xC236,0x4118,WORD_LEN},
	{0xC238,0x7869,WORD_LEN},
	{0xC23A,0x0918,WORD_LEN},
	{0xC23C,0x7FF6,WORD_LEN},
	{0xC23E,0x0AFB,WORD_LEN},
	{0xC240,0x024B,WORD_LEN},
	{0xC242,0x9842,WORD_LEN},
	{0xC244,0x00D9,WORD_LEN},
	{0xC246,0x181C,WORD_LEN},
	{0xC248,0x3881,WORD_LEN},
	{0xC24A,0x80BD,WORD_LEN},
	{0xC24C,0xFF7F,WORD_LEN},
	{0xC24E,0x0000,WORD_LEN},
	{0xC250,0x80B5,WORD_LEN},
	{0xC252,0x9378,WORD_LEN},
	{0xC254,0x8342,WORD_LEN},
	{0xC256,0x05DD,WORD_LEN},
	{0xC258,0x0130,WORD_LEN},
	{0xC25A,0x4843,WORD_LEN},
	{0xC25C,0x0A1C,WORD_LEN},
	{0xC25E,0x011C,WORD_LEN},
	{0xC260,0x581C,WORD_LEN},
	{0xC262,0x09E0,WORD_LEN},
	{0xC264,0x5378,WORD_LEN},
	{0xC266,0xD278,WORD_LEN},
	{0xC268,0x9F1A,WORD_LEN},
	{0xC26A,0x8742,WORD_LEN},
	{0xC26C,0x09DC,WORD_LEN},
	{0xC26E,0x181A,WORD_LEN},
	{0xC270,0x4843,WORD_LEN},
	{0xC272,0x0B1C,WORD_LEN},
	{0xC274,0x011C,WORD_LEN},
	{0xC276,0x501C,WORD_LEN},
	{0xC278,0x7FF6,WORD_LEN},
	{0xC27A,0xA2FB,WORD_LEN},
	{0xC27C,0x0004,WORD_LEN},
	{0xC27E,0x000C,WORD_LEN},
	{0xC280,0x80BD,WORD_LEN},
	{0xC282,0x081C,WORD_LEN},
	{0xC284,0xFCE7,WORD_LEN},
	{0xC286,0x0102,WORD_LEN},
	{0xC288,0x0012,WORD_LEN},
	{0xC28A,0x0843,WORD_LEN},
	{0xC28C,0x0004,WORD_LEN},
	{0xC28E,0x000C,WORD_LEN},
	{0xC290,0xF746,WORD_LEN},
	{0xC292,0x0000,WORD_LEN},
	{0xC294,0x4909,WORD_LEN},
	{0xC296,0x1800,WORD_LEN},
	{0x485C,0x9802,WORD_LEN},
	{0x485E,0x555E,WORD_LEN},
	{0x000A,0x01  ,BYTE_LEN},
	{0x4C4C,0x1003,WORD_LEN},
	{0x4C4E,0x1002,WORD_LEN},
	{0x4C50,0x5002,WORD_LEN},
	{0x4C52,0x5002,WORD_LEN},
	{0x4C54,0xEE02,WORD_LEN},
	{0x4C56,0xEE01,WORD_LEN},
	{0x4C58,0xA002,WORD_LEN},
	{0x4C5A,0xA002,WORD_LEN},
	{0x4C7C,0x00  ,BYTE_LEN},
	{0x4C7D,0x00  ,BYTE_LEN},
	{0x4C7E,0x00  ,BYTE_LEN},
	{0x4C7F,0x00  ,BYTE_LEN},
	{0x4C80,0x08  ,BYTE_LEN},
	{0x4C81,0x07  ,BYTE_LEN},
	{0x4C82,0x00  ,BYTE_LEN},
	{0x4C83,0x00  ,BYTE_LEN},
	{0x4C84,0x00  ,BYTE_LEN},
	{0x4C85,0x00  ,BYTE_LEN},
	{0x484E,0x08  ,BYTE_LEN},

#if defined (CONFIG_MACH_MSM7X27_THUNDERG)
	{0x4808,0x9600,WORD_LEN},
	{0x480A,0xFA00,WORD_LEN},
	{0x480C,0xE803,WORD_LEN},
	{0x480E,0xFA,BYTE_LEN},
	{0x4810,0xFA,BYTE_LEN},
	{0x4812,0xE803,WORD_LEN},
	{0x481D,0x00  ,BYTE_LEN},
	{0x4822,0x0500,WORD_LEN},
	{0x4824,0x0A00,WORD_LEN},
	{0x4826,0x0500,WORD_LEN},
	{0x482C,0x1E00,WORD_LEN},
	{0x4832,0x2C01,WORD_LEN},
	{0x4838,0x1600,WORD_LEN},
	{0x4844,0x5000,WORD_LEN},
	{0x484F,0x00  ,BYTE_LEN},
	{0x4856,0x28  ,BYTE_LEN},
	{0x486A,0x6400,WORD_LEN},
	{0x486C,0x2800,WORD_LEN},
	{0x486E,0x1400,WORD_LEN},
	{0x4870,0x2800,WORD_LEN},
	{0x4872,0x1400,WORD_LEN},
	{0x4876,0x1801,WORD_LEN},
	{0x4878,0x9A01,WORD_LEN},
	{0x487A,0x3200,WORD_LEN},
	{0x487C,0x9A01,WORD_LEN},
	{0x487E,0x3200,WORD_LEN},
	{0x4880,0x4402,WORD_LEN},
	{0x4884,0x00  ,BYTE_LEN},
	{0x4889,0x20  ,BYTE_LEN},
	{0x488A,0x00  ,BYTE_LEN},
	{0x488B,0x00  ,BYTE_LEN},
#else	/* improve autofocusing time */
	{0x4808,0x9600,WORD_LEN},
	{0x480A,0xFA00,WORD_LEN},
	{0x480C,0xE803,WORD_LEN},
	{0x480E,0xFA,BYTE_LEN},
	{0x4810,0xFA,BYTE_LEN},
	{0x4812,0xE803,WORD_LEN},
	{0x481D,0x00  ,BYTE_LEN},
	{0x4822,0x0500,WORD_LEN},
	{0x4824,0x0A00,WORD_LEN},
	{0x4826,0x0500,WORD_LEN},
	{0x482C,0x1E00,WORD_LEN},
	{0x4832,0x2C01,WORD_LEN},
	{0x4838,0x1600,WORD_LEN},
	{0x4844,0x2800,WORD_LEN},
	{0x484F,0x00  ,BYTE_LEN},
	{0x4856,0x28  ,BYTE_LEN},
	{0x486A,0x6400,WORD_LEN},
	{0x486C,0x2800,WORD_LEN},
	{0x486E,0x0a00,WORD_LEN},
	{0x4870,0x2800,WORD_LEN},
	{0x4872,0x0a00,WORD_LEN},
	{0x4876,0x7C01,WORD_LEN},
	{0x4878,0x4402,WORD_LEN},
	{0x487A,0x3200,WORD_LEN},
	{0x487C,0x9A01,WORD_LEN},
	{0x487E,0x3200,WORD_LEN},
	{0x4880,0x4402,WORD_LEN},
	{0x4884,0x00  ,BYTE_LEN},
	{0x4889,0x20  ,BYTE_LEN},
	{0x488A,0x00  ,BYTE_LEN},
	{0x488B,0x00  ,BYTE_LEN},
#endif

	{0x488C,0x0400,WORD_LEN},
	{0x489A,0x9162,WORD_LEN},
	{0x489C,0xC86B,WORD_LEN},
	{0x489E,0x597B,WORD_LEN},
	{0x48A0,0x2D00,WORD_LEN},
	{0x48A2,0x0A00,WORD_LEN},
	{0x48A4,0x2B00,WORD_LEN},
	{0x48A6,0x9162,WORD_LEN},
	{0x48A8,0xC86B,WORD_LEN},
	{0x48AA,0x597B,WORD_LEN},
	{0x48AC,0x0200,WORD_LEN},
	{0x48AE,0x0600,WORD_LEN},
	{0x48B0,0x0400,WORD_LEN},
	{0x48B2,0x9162,WORD_LEN},
	{0x48B4,0xC86B,WORD_LEN},
	{0x48B6,0x597B,WORD_LEN},
	{0x48B8,0x0700,WORD_LEN},
	{0x48BA,0x0800,WORD_LEN},
	{0x48BC,0x1400,WORD_LEN},
	{0x48BE,0x9162,WORD_LEN},
	{0x48C0,0xC86B,WORD_LEN},
	{0x48C2,0x597B,WORD_LEN},
	{0x48C4,0x1400,WORD_LEN},
	{0x48C6,0x2200,WORD_LEN},
	{0x48C8,0x3200,WORD_LEN},
	{0x48CA,0x9162,WORD_LEN},
	{0x48CC,0xC86B,WORD_LEN},
	{0x48CE,0x597B,WORD_LEN},
	{0x48D0,0x2D00,WORD_LEN},
	{0x48D2,0x0A00,WORD_LEN},
	{0x48D4,0x2B00,WORD_LEN},
	{0x48D6,0x9162,WORD_LEN},
	{0x48D8,0xC86B,WORD_LEN},
	{0x48DA,0x597B,WORD_LEN},
	{0x48DC,0x0200,WORD_LEN},
	{0x48DE,0x0600,WORD_LEN},
	{0x48E0,0x0400,WORD_LEN},
	{0x48E2,0x9162,WORD_LEN},
	{0x48E4,0xC86B,WORD_LEN},
	{0x48E6,0x597B,WORD_LEN},
	{0x48E8,0xFF03,WORD_LEN},
	{0x48EA,0xFF03,WORD_LEN},
	{0x48EC,0xFF03,WORD_LEN},
	{0x48EE,0x9162,WORD_LEN},
	{0x48F0,0xC86B,WORD_LEN},
	{0x48F2,0x597B,WORD_LEN},
	{0x48F4,0xFF03,WORD_LEN},
	{0x48F6,0xFF03,WORD_LEN},
	{0x48F8,0xFF03,WORD_LEN},
	{0x495C,0x01  ,BYTE_LEN},
	{0x4968,0x00  ,BYTE_LEN},
	{0x4969,0x08  ,BYTE_LEN},
	{0x496C,0x00  ,BYTE_LEN},
	{0x6E08,0x1E00,WORD_LEN},
	{0x6E12,0x3400,WORD_LEN},
	{0x6E22,0x9162,WORD_LEN},
	{0x6E24,0xC86B,WORD_LEN},
	{0x6E26,0x597B,WORD_LEN},
	{0x6E28,0x2D00,WORD_LEN},
	{0x6E2A,0x0A00,WORD_LEN},
	{0x6E2C,0x2B00,WORD_LEN},
	{0x6E2E,0x9162,WORD_LEN},
	{0x6E30,0xC86B,WORD_LEN},
	{0x6E32,0x597B,WORD_LEN},
	{0x6E34,0x0200,WORD_LEN},
	{0x6E36,0x0600,WORD_LEN},
	{0x6E38,0x0400,WORD_LEN},
	{0x6E3A,0x9162,WORD_LEN},
	{0x6E3C,0xC86B,WORD_LEN},
	{0x6E3E,0x597B,WORD_LEN},
	{0x6E40,0x0700,WORD_LEN},
	{0x6E42,0x0800,WORD_LEN},
	{0x6E44,0x1400,WORD_LEN},
	{0x6E46,0x9162,WORD_LEN},
	{0x6E48,0xC86B,WORD_LEN},
	{0x6E4A,0x597B,WORD_LEN},
	{0x6E4C,0x1400,WORD_LEN},
	{0x6E4E,0x2200,WORD_LEN},
	{0x6E50,0x3200,WORD_LEN},
	{0x481C,0x00  ,BYTE_LEN},
	{0x4038,0x02  ,BYTE_LEN},
	{0x4039,0x32  ,BYTE_LEN},
	{0x403A,0x0500,WORD_LEN},
	{0x404A,0x4400,WORD_LEN},
	{0x4600,0xAA  ,BYTE_LEN},
	{0x4601,0xAA  ,BYTE_LEN},
	{0x4602,0xAA  ,BYTE_LEN},
	{0x4603,0xAA  ,BYTE_LEN},
	{0x4604,0xAA  ,BYTE_LEN},
	{0x4605,0xAA  ,BYTE_LEN},
	{0x4606,0xAA  ,BYTE_LEN},
	{0x4607,0xAA  ,BYTE_LEN},
	{0x4608,0xAA  ,BYTE_LEN},
	{0x4609,0xAE  ,BYTE_LEN},
	{0x460A,0xA0  ,BYTE_LEN},
	{0x460B,0xA1  ,BYTE_LEN},
	{0x460C,0x8A  ,BYTE_LEN},
	{0x460D,0x78  ,BYTE_LEN},
	{0x460E,0x5B  ,BYTE_LEN},
	{0x460F,0x4C  ,BYTE_LEN},
	{0x4610,0x44  ,BYTE_LEN},
	{0x4611,0x3E  ,BYTE_LEN},
	{0x4612,0x3A  ,BYTE_LEN},
	{0x4613,0x35  ,BYTE_LEN},
	{0x4614,0x32  ,BYTE_LEN},
	{0x4615,0x2F  ,BYTE_LEN},
	{0x4616,0x2E  ,BYTE_LEN},
	{0x4617,0x2D  ,BYTE_LEN},
	{0x4618,0x2C  ,BYTE_LEN},
	{0x4619,0x2B  ,BYTE_LEN},
	{0x461A,0x2A  ,BYTE_LEN},
	{0x461B,0x29  ,BYTE_LEN},
	{0x461C,0x28  ,BYTE_LEN},
	{0x461D,0x27  ,BYTE_LEN},
	{0x461E,0x26  ,BYTE_LEN},
	{0x461F,0x24  ,BYTE_LEN},
	{0x4620,0x25  ,BYTE_LEN},
	{0x4621,0x24  ,BYTE_LEN},
	{0x4622,0x23  ,BYTE_LEN},
	{0x4623,0x22  ,BYTE_LEN},
	{0x4624,0x21  ,BYTE_LEN},
	{0x4625,0x20  ,BYTE_LEN},
	{0x4626,0xAF  ,BYTE_LEN},
	{0x4627,0xAF  ,BYTE_LEN},
	{0x4628,0xAF  ,BYTE_LEN},
	{0x4629,0xAF  ,BYTE_LEN},
	{0x462A,0xAF  ,BYTE_LEN},
	{0x462B,0xAF  ,BYTE_LEN},
	{0x462C,0xAF  ,BYTE_LEN},
	{0x462D,0xAF  ,BYTE_LEN},
	{0x462E,0xAF  ,BYTE_LEN},
	{0x462F,0xAE  ,BYTE_LEN},
	{0x4630,0xB2  ,BYTE_LEN},
	{0x4631,0xB7  ,BYTE_LEN},
	{0x4632,0xB9  ,BYTE_LEN},
	{0x4633,0xB7  ,BYTE_LEN},
	{0x4634,0x9E  ,BYTE_LEN},
	{0x4635,0x85  ,BYTE_LEN},
	{0x4636,0x7B  ,BYTE_LEN},
	{0x4637,0x75  ,BYTE_LEN},
	{0x4638,0x6F  ,BYTE_LEN},
	{0x4639,0x6A  ,BYTE_LEN},
	{0x463A,0x66  ,BYTE_LEN},
	{0x463B,0x61  ,BYTE_LEN},
	{0x463C,0x5B  ,BYTE_LEN},
	{0x463D,0x56  ,BYTE_LEN},
	{0x463E,0x51  ,BYTE_LEN},
	{0x463F,0x4D  ,BYTE_LEN},
	{0x4640,0x48  ,BYTE_LEN},
	{0x4641,0x43  ,BYTE_LEN},
	{0x4642,0x40  ,BYTE_LEN},
	{0x4643,0x3D  ,BYTE_LEN},
	{0x4644,0x3B  ,BYTE_LEN},
	{0x4645,0x39  ,BYTE_LEN},
	{0x4646,0x3B  ,BYTE_LEN},
	{0x4647,0x3A  ,BYTE_LEN},
	{0x4648,0x39  ,BYTE_LEN},
	{0x4649,0x38  ,BYTE_LEN},
	{0x464A,0x37  ,BYTE_LEN},
	{0x464B,0x36  ,BYTE_LEN},
	{0x464C,0x1F  ,BYTE_LEN},
	{0x464D,0x0B  ,BYTE_LEN},
	{0x464E,0x19  ,BYTE_LEN},
	{0x464F,0x10  ,BYTE_LEN},
	{0x4650,0x91  ,BYTE_LEN},
	{0x4651,0x91  ,BYTE_LEN},
	{0x4652,0x91  ,BYTE_LEN},
	{0x4653,0x91  ,BYTE_LEN},
	{0x4654,0x91  ,BYTE_LEN},
	{0x4655,0x91  ,BYTE_LEN},
	{0x4656,0x91  ,BYTE_LEN},
	{0x4657,0x91  ,BYTE_LEN},
	{0x4658,0x91  ,BYTE_LEN},
	{0x4659,0x91  ,BYTE_LEN},
	{0x465A,0x91  ,BYTE_LEN},
	{0x465B,0x91  ,BYTE_LEN},
	{0x465C,0x91  ,BYTE_LEN},
	{0x465D,0x78  ,BYTE_LEN},
	{0x465E,0x70  ,BYTE_LEN},
	{0x465F,0x60  ,BYTE_LEN},
	{0x4660,0x4B  ,BYTE_LEN},
	{0x4661,0x44  ,BYTE_LEN},
	{0x4662,0x3E  ,BYTE_LEN},
	{0x4663,0x3A  ,BYTE_LEN},
	{0x4664,0x36  ,BYTE_LEN},
	{0x4665,0x34  ,BYTE_LEN},
	{0x4666,0x33  ,BYTE_LEN},
	{0x4667,0x32  ,BYTE_LEN},
	{0x4668,0x31  ,BYTE_LEN},
	{0x4669,0x30  ,BYTE_LEN},
	{0x466A,0x2F  ,BYTE_LEN},
	{0x466B,0x2E  ,BYTE_LEN},
	{0x466C,0x2D  ,BYTE_LEN},
	{0x466D,0x2C  ,BYTE_LEN},
	{0x466E,0x2B  ,BYTE_LEN},
	{0x466F,0x29  ,BYTE_LEN},
	{0x4670,0x25  ,BYTE_LEN},
	{0x4671,0x24  ,BYTE_LEN},
	{0x4672,0x29  ,BYTE_LEN},
	{0x4673,0x28  ,BYTE_LEN},
	{0x4674,0x27  ,BYTE_LEN},
	{0x4675,0x26  ,BYTE_LEN},
	{0x4676,0xFF  ,BYTE_LEN},
	{0x4677,0xFF  ,BYTE_LEN},
	{0x4678,0xFF  ,BYTE_LEN},
	{0x4679,0xFF  ,BYTE_LEN},
	{0x467A,0xFF  ,BYTE_LEN},
	{0x467B,0xFF  ,BYTE_LEN},
	{0x467C,0xFF  ,BYTE_LEN},
	{0x467D,0xFF  ,BYTE_LEN},
	{0x467E,0xFF  ,BYTE_LEN},
	{0x467F,0xFF  ,BYTE_LEN},
	{0x4680,0xD9  ,BYTE_LEN},
	{0x4681,0xB7  ,BYTE_LEN},
	{0x4682,0x96  ,BYTE_LEN},
	{0x4683,0x83  ,BYTE_LEN},
	{0x4684,0x80  ,BYTE_LEN},
	{0x4685,0x72  ,BYTE_LEN},
	{0x4686,0x75  ,BYTE_LEN},
	{0x4687,0x6F  ,BYTE_LEN},
	{0x4688,0x69  ,BYTE_LEN},
	{0x4689,0x64  ,BYTE_LEN},
	{0x468A,0x5F  ,BYTE_LEN},
	{0x468B,0x5B  ,BYTE_LEN},
	{0x468C,0x57  ,BYTE_LEN},
	{0x468D,0x53  ,BYTE_LEN},
	{0x468E,0x4E  ,BYTE_LEN},
	{0x468F,0x4A  ,BYTE_LEN},
	{0x4690,0x45  ,BYTE_LEN},
	{0x4691,0x40  ,BYTE_LEN},
	{0x4692,0x3D  ,BYTE_LEN},
	{0x4693,0x3A  ,BYTE_LEN},
	{0x4694,0x38  ,BYTE_LEN},
	{0x4695,0x36  ,BYTE_LEN},
	{0x4696,0x3B  ,BYTE_LEN},
	{0x4697,0x32  ,BYTE_LEN},
	{0x4698,0x39  ,BYTE_LEN},
	{0x4699,0x30  ,BYTE_LEN},
	{0x469A,0x2F  ,BYTE_LEN},
	{0x469B,0x2E  ,BYTE_LEN},
	{0x469C,0x1E  ,BYTE_LEN},
	{0x469D,0x0F  ,BYTE_LEN},
	{0x469E,0x18  ,BYTE_LEN},
	{0x469F,0x10  ,BYTE_LEN},
	{0x46A0,0xFF  ,BYTE_LEN},
	{0x46A1,0xFF  ,BYTE_LEN},
	{0x46A2,0xFF  ,BYTE_LEN},
	{0x46A3,0xFF  ,BYTE_LEN},
	{0x46A4,0xFF  ,BYTE_LEN},
	{0x46A5,0xFF  ,BYTE_LEN},
	{0x46A6,0xFF  ,BYTE_LEN},
	{0x46A7,0xFF  ,BYTE_LEN},
	{0x46A8,0xFF  ,BYTE_LEN},
	{0x46A9,0xFD  ,BYTE_LEN},
	{0x46AA,0xCB  ,BYTE_LEN},
	{0x46AB,0xA9  ,BYTE_LEN},
	{0x46AC,0x90  ,BYTE_LEN},
	{0x46AD,0x7D  ,BYTE_LEN},
	{0x46AE,0x70  ,BYTE_LEN},
	{0x46AF,0x65  ,BYTE_LEN},
	{0x46B0,0x5C  ,BYTE_LEN},
	{0x46B1,0x55  ,BYTE_LEN},
	{0x46B2,0x4F  ,BYTE_LEN},
	{0x46B3,0x32  ,BYTE_LEN},
	{0x46B4,0x30  ,BYTE_LEN},
	{0x46B5,0x2F  ,BYTE_LEN},
	{0x46B6,0x30  ,BYTE_LEN},
	{0x46B7,0x2C  ,BYTE_LEN},
	{0x46B8,0x29  ,BYTE_LEN},
	{0x46B9,0x27  ,BYTE_LEN},
	{0x46BA,0x25  ,BYTE_LEN},
	{0x46BB,0x23  ,BYTE_LEN},
	{0x46BC,0x21  ,BYTE_LEN},
	{0x46BD,0x1F  ,BYTE_LEN},
	{0x46BE,0x1D  ,BYTE_LEN},
	{0x46BF,0x1B  ,BYTE_LEN},
	{0x46C0,0x1A  ,BYTE_LEN},
	{0x46C1,0x2A  ,BYTE_LEN},
	{0x46C2,0x29  ,BYTE_LEN},
	{0x46C3,0x28  ,BYTE_LEN},
	{0x46C4,0x27  ,BYTE_LEN},
	{0x46C5,0x26  ,BYTE_LEN},
	{0x46C6,0xFF  ,BYTE_LEN},
	{0x46C7,0xFF  ,BYTE_LEN},
	{0x46C8,0xFF  ,BYTE_LEN},
	{0x46C9,0xFF  ,BYTE_LEN},
	{0x46CA,0xFF  ,BYTE_LEN},
	{0x46CB,0xFF  ,BYTE_LEN},
	{0x46CC,0xFF  ,BYTE_LEN},
	{0x46CD,0xFF  ,BYTE_LEN},
	{0x46CE,0xFF  ,BYTE_LEN},
	{0x46CF,0xFF  ,BYTE_LEN},
	{0x46D0,0xD3  ,BYTE_LEN},
	{0x46D1,0xB1  ,BYTE_LEN},
	{0x46D2,0x98  ,BYTE_LEN},
	{0x46D3,0x85  ,BYTE_LEN},
	{0x46D4,0x78  ,BYTE_LEN},
	{0x46D5,0x6D  ,BYTE_LEN},
	{0x46D6,0x64  ,BYTE_LEN},
	{0x46D7,0x5D  ,BYTE_LEN},
	{0x46D8,0x57  ,BYTE_LEN},
	{0x46D9,0x63  ,BYTE_LEN},
	{0x46DA,0x5E  ,BYTE_LEN},
	{0x46DB,0x5A  ,BYTE_LEN},
	{0x46DC,0x56  ,BYTE_LEN},
	{0x46DD,0x52  ,BYTE_LEN},
	{0x46DE,0x50  ,BYTE_LEN},
	{0x46DF,0x4E  ,BYTE_LEN},
	{0x46E0,0x4C  ,BYTE_LEN},
	{0x46E1,0x4A  ,BYTE_LEN},
	{0x46E2,0x48  ,BYTE_LEN},
	{0x46E3,0x46  ,BYTE_LEN},
	{0x46E4,0x44  ,BYTE_LEN},
	{0x46E5,0x43  ,BYTE_LEN},
	{0x46E6,0x42  ,BYTE_LEN},
	{0x46E7,0x32  ,BYTE_LEN},
	{0x46E8,0x31  ,BYTE_LEN},
	{0x46E9,0x30  ,BYTE_LEN},
	{0x46EA,0x2F  ,BYTE_LEN},
	{0x46EB,0x2E  ,BYTE_LEN},
	{0x46EC,0x1E  ,BYTE_LEN},
	{0x46ED,0x16  ,BYTE_LEN},
	{0x46EE,0x19  ,BYTE_LEN},
	{0x46EF,0x10  ,BYTE_LEN},
	{0x46F0,0xFF  ,BYTE_LEN},
	{0x46F1,0xFF  ,BYTE_LEN},
	{0x46F2,0xFF  ,BYTE_LEN},
	{0x46F3,0xFF  ,BYTE_LEN},
	{0x46F4,0xFF  ,BYTE_LEN},
	{0x46F5,0xFF  ,BYTE_LEN},
	{0x46F6,0xFF  ,BYTE_LEN},
	{0x46F7,0xFF  ,BYTE_LEN},
	{0x46F8,0xFF  ,BYTE_LEN},
	{0x46F9,0xFF  ,BYTE_LEN},
	{0x46FA,0xCD  ,BYTE_LEN},
	{0x46FB,0xAB  ,BYTE_LEN},
	{0x46FC,0x92  ,BYTE_LEN},
	{0x46FD,0x7E  ,BYTE_LEN},
	{0x46FE,0x72  ,BYTE_LEN},
	{0x46FF,0x67  ,BYTE_LEN},
	{0x4700,0x5E  ,BYTE_LEN},
	{0x4701,0x57  ,BYTE_LEN},
	{0x4702,0x51  ,BYTE_LEN},
	{0x4703,0x4E  ,BYTE_LEN},
	{0x4704,0x49  ,BYTE_LEN},
	{0x4705,0x45  ,BYTE_LEN},
	{0x4706,0x41  ,BYTE_LEN},
	{0x4707,0x3D  ,BYTE_LEN},
	{0x4708,0x36  ,BYTE_LEN},
	{0x4709,0x35  ,BYTE_LEN},
	{0x470A,0x33  ,BYTE_LEN},
	{0x470B,0x32  ,BYTE_LEN},
	{0x470C,0x30  ,BYTE_LEN},
	{0x470D,0x30  ,BYTE_LEN},
	{0x470E,0x2A  ,BYTE_LEN},
	{0x470F,0x2E  ,BYTE_LEN},
	{0x4710,0x2D  ,BYTE_LEN},
	{0x4711,0x2C  ,BYTE_LEN},
	{0x4712,0x2B  ,BYTE_LEN},
	{0x4713,0x2A  ,BYTE_LEN},
	{0x4714,0x29  ,BYTE_LEN},
	{0x4715,0x28  ,BYTE_LEN},
	{0x4716,0xFF  ,BYTE_LEN},
	{0x4717,0xFF  ,BYTE_LEN},
	{0x4718,0xFF  ,BYTE_LEN},
	{0x4719,0xFF  ,BYTE_LEN},
	{0x471A,0xFF  ,BYTE_LEN},
	{0x471B,0xFF  ,BYTE_LEN},
	{0x471C,0xFF  ,BYTE_LEN},
	{0x471D,0xFF  ,BYTE_LEN},
	{0x471E,0xFF  ,BYTE_LEN},
	{0x471F,0xFF  ,BYTE_LEN},
	{0x4720,0xD3  ,BYTE_LEN},
	{0x4721,0xB1  ,BYTE_LEN},
	{0x4722,0x98  ,BYTE_LEN},
	{0x4723,0x85  ,BYTE_LEN},
	{0x4724,0x78  ,BYTE_LEN},
	{0x4725,0x6D  ,BYTE_LEN},
	{0x4726,0x64  ,BYTE_LEN},
	{0x4727,0x5D  ,BYTE_LEN},
	{0x4728,0x57  ,BYTE_LEN},
	{0x4729,0x52  ,BYTE_LEN},
	{0x472A,0x4D  ,BYTE_LEN},
	{0x472B,0x49  ,BYTE_LEN},
	{0x472C,0x44  ,BYTE_LEN},
	{0x472D,0x42  ,BYTE_LEN},
	{0x472E,0x3F  ,BYTE_LEN},
	{0x472F,0x3C  ,BYTE_LEN},
	{0x4730,0x3B  ,BYTE_LEN},
	{0x4731,0x39  ,BYTE_LEN},
	{0x4732,0x37  ,BYTE_LEN},
	{0x4733,0x36  ,BYTE_LEN},
	{0x4734,0x34  ,BYTE_LEN},
	{0x4735,0x34  ,BYTE_LEN},
	{0x4736,0x33  ,BYTE_LEN},
	{0x4737,0x32  ,BYTE_LEN},
	{0x4738,0x31  ,BYTE_LEN},
	{0x4739,0x30  ,BYTE_LEN},
	{0x473A,0x2F  ,BYTE_LEN},
	{0x473B,0x2E  ,BYTE_LEN},
	{0x473C,0x1D  ,BYTE_LEN},
	{0x473D,0x17  ,BYTE_LEN},
	{0x473E,0x19  ,BYTE_LEN},
	{0x473F,0x16  ,BYTE_LEN},
	{0x4400,0x00  ,BYTE_LEN},
	{0x4C0A,0xE400,WORD_LEN},
	{0x4C0C,0xD200,WORD_LEN},
	{0x4401,0x02  ,BYTE_LEN},
	{0x4402,0x00  ,BYTE_LEN},
	{0x4403,0x01  ,BYTE_LEN},
	{0x4404,0x00  ,BYTE_LEN},
	{0x4405,0x01  ,BYTE_LEN},
	{0x4406,0x0A  ,BYTE_LEN},
	{0x4408,0x0001,WORD_LEN},
	{0x440A,0x0010,WORD_LEN},
	{0x440C,0x23  ,BYTE_LEN},
	{0x440D,0x23  ,BYTE_LEN},
	{0x440E,0x23  ,BYTE_LEN},
	{0x440F,0x23  ,BYTE_LEN},
	{0x4410,0x04  ,BYTE_LEN},
	{0x4411,0x04  ,BYTE_LEN},
	{0x4412,0x04  ,BYTE_LEN},
	{0x4413,0x04  ,BYTE_LEN},
	{0x4414,0x20  ,BYTE_LEN},
	{0x4415,0x20  ,BYTE_LEN},
	{0x4416,0x20  ,BYTE_LEN},
	{0x4417,0x20  ,BYTE_LEN},
	{0x4418,0x04  ,BYTE_LEN},
	{0x4419,0x04  ,BYTE_LEN},
	{0x441A,0x04  ,BYTE_LEN},
	{0x441B,0x04  ,BYTE_LEN},
	{0x441C,0x01  ,BYTE_LEN},
	{0x441D,0x01  ,BYTE_LEN},
	{0x441E,0x01  ,BYTE_LEN},
	{0x441F,0x01  ,BYTE_LEN},
	{0x4420,0x00  ,BYTE_LEN},
	{0x4421,0x04  ,BYTE_LEN},
	{0x4422,0x10  ,BYTE_LEN},
	{0x4423,0x02  ,BYTE_LEN},  
	{0x4424,0x03  ,BYTE_LEN},  
	{0x4425,0x02  ,BYTE_LEN},
	{0x4426,0xFFFF,WORD_LEN},
	{0x4428,0xFFFF,WORD_LEN},
	{0x442A,0x2D0D,WORD_LEN},
	{0x442C,0xF613,WORD_LEN},
	{0x442E,0xBC0B,WORD_LEN},
	{0x4430,0x7517,WORD_LEN},
	{0x4432,0x0010,WORD_LEN},
	{0x4434,0x0010,WORD_LEN},
	{0x444A,0xE882,WORD_LEN},
	{0x444C,0xD084,WORD_LEN},
	{0x444E,0x0A  ,BYTE_LEN},
	{0x444F,0x00  ,BYTE_LEN},
	{0x4450,0x0000,WORD_LEN},
	{0x4452,0x1E  ,BYTE_LEN},
	{0x4453,0x7B  ,BYTE_LEN},
	{0x4454,0x0000,WORD_LEN},
	{0x4456,0x0000,WORD_LEN},
	{0x4458,0x0000,WORD_LEN},
	{0x445A,0x0000,WORD_LEN},
	{0x445C,0x0000,WORD_LEN},
	{0x445E,0x0000,WORD_LEN},
	{0x4460,0xC002,WORD_LEN},
	{0x4462,0x2000,WORD_LEN},
	{0x4464,0x3002,WORD_LEN},
	{0x4466,0xC203,WORD_LEN},
	{0x4468,0x3002,WORD_LEN},
	{0x446A,0x18  ,BYTE_LEN},
	{0x446B,0x05  ,BYTE_LEN},
	{0x446C,0x00  ,BYTE_LEN},
	{0x446D,0x20  ,BYTE_LEN},
	{0x446E,0x0000,WORD_LEN},
	{0x4470,0x05  ,BYTE_LEN},
	{0x4471,0x40  ,BYTE_LEN},
	{0x0060,0x00  ,BYTE_LEN},
	{0x0061,0x80  ,BYTE_LEN},
	{0x0062,0x20  ,BYTE_LEN},
	{0x0080,0x00  ,BYTE_LEN},
	{0x01BD,0x01  ,BYTE_LEN},
	{0x01BE,0x01  ,BYTE_LEN},
	{0x01BF,0x02  ,BYTE_LEN},
	{0x01C0,0x0F  ,BYTE_LEN},
	{0x01E5,0x00  ,BYTE_LEN},
	{0x01E6,0x04  ,BYTE_LEN},
	{0x01E7,0x0A  ,BYTE_LEN},
	{0x01E8,0x00  ,BYTE_LEN},
	{0x4A00,0x0D05,WORD_LEN},
	{0x4A02,0x0000,WORD_LEN},
	{0x4016,0x1621,WORD_LEN},
	{0x4018,0xCA03,WORD_LEN},
	{0x401A,0x0002,WORD_LEN},
	{0x401C,0xCA03,WORD_LEN},
	{0x401E,0x6c03,WORD_LEN},
	{0x4020,0x3004,WORD_LEN},
	{0x4036,0x9F02,WORD_LEN},
	{0x4087,0x05  ,BYTE_LEN},
	{0x4088,0x0E  ,BYTE_LEN},
	{0x4089,0x0B  ,BYTE_LEN},
	{0x408A,0x0F  ,BYTE_LEN},
	{0x408B,0x21  ,BYTE_LEN},
	{0x408C,0x13  ,BYTE_LEN},
	{0x408D,0x06  ,BYTE_LEN},
	{0x408E,0x0E  ,BYTE_LEN},
	{0x408F,0x0C  ,BYTE_LEN},
	{0x4090,0x13  ,BYTE_LEN},
	{0x4091,0x21  ,BYTE_LEN},
	{0x4092,0x18  ,BYTE_LEN},
	{0x4436,0x300B,WORD_LEN},
	{0x4438,0x7118,WORD_LEN},
	{0x443A,0xA009,WORD_LEN},
	{0x443C,0xFC21,WORD_LEN},
	{0x443E,0x8C0A,WORD_LEN},
	{0x4440,0xB91C,WORD_LEN},
	{0x4442,0x0E0F,WORD_LEN},
	{0x4444,0x7513,WORD_LEN},
	{0x4446,0x3610,WORD_LEN},
	{0x4448,0xA00F,WORD_LEN},
	{0x0100,0x00  ,BYTE_LEN},
	{0x0102,0x20  ,BYTE_LEN},
	{0x0103,0x01  ,BYTE_LEN},
	{0x0104,0x4C  ,BYTE_LEN},
	{0x0105,0x40  ,BYTE_LEN},
	{0x0106,0x00  ,BYTE_LEN},
	{0x0107,0x20  ,BYTE_LEN},
	{0x0108,0x01  ,BYTE_LEN},
	{0x0109,0x4D  ,BYTE_LEN},
	{0x010A,0x40  ,BYTE_LEN},
	{0x010B,0x00  ,BYTE_LEN},
	{0x010C,0x20  ,BYTE_LEN},
	{0x010D,0x01  ,BYTE_LEN},
	{0x010E,0x4F  ,BYTE_LEN},
	{0x010F,0x54  ,BYTE_LEN},
	{0x0110,0x00  ,BYTE_LEN},
	{0x0111,0x20  ,BYTE_LEN},
	{0x0112,0x00  ,BYTE_LEN},
	{0x0113,0x0D  ,BYTE_LEN},
	{0x0114,0x40  ,BYTE_LEN},
	{0x0115,0x00  ,BYTE_LEN},
	{0x0116,0x20  ,BYTE_LEN},
	{0x0117,0x41  ,BYTE_LEN},
	{0x0118,0x4D  ,BYTE_LEN},
	{0x0119,0x54  ,BYTE_LEN},
	{0x011A,0x00  ,BYTE_LEN},
	{0x011B,0x20  ,BYTE_LEN},
	{0x011C,0x21  ,BYTE_LEN},
	{0x011D,0x4D  ,BYTE_LEN},
	{0x011E,0x54  ,BYTE_LEN},
	{0x011F,0x00  ,BYTE_LEN},
	{0x0120,0x24  ,BYTE_LEN},
	{0x0121,0x01  ,BYTE_LEN},
	{0x0122,0x4D  ,BYTE_LEN},
	{0x0123,0x40  ,BYTE_LEN},
	{0x0124,0x00  ,BYTE_LEN},
	{0x0125,0x27  ,BYTE_LEN},
	{0x0126,0x01  ,BYTE_LEN},
	{0x0127,0x4D  ,BYTE_LEN},
	{0x0128,0x40  ,BYTE_LEN},
	{0x0129,0x00  ,BYTE_LEN},
	{0x012A,0x20  ,BYTE_LEN},
	{0x012B,0x01  ,BYTE_LEN},
	{0x012C,0x4D  ,BYTE_LEN},
	{0x012D,0x68  ,BYTE_LEN},
	{0x012E,0x00  ,BYTE_LEN},
	{0x012F,0x20  ,BYTE_LEN},
	{0x0130,0x01  ,BYTE_LEN},
	{0x0131,0x4D  ,BYTE_LEN},
	{0x0132,0x40  ,BYTE_LEN},
	{0x0133,0x00  ,BYTE_LEN},
	{0x0134,0x20  ,BYTE_LEN},
	{0x0135,0x01  ,BYTE_LEN},
	{0x0136,0x4D  ,BYTE_LEN},
	{0x0137,0x40  ,BYTE_LEN},
	{0x0138,0x00  ,BYTE_LEN},
	{0x0139,0x20  ,BYTE_LEN},
	{0x013A,0x01  ,BYTE_LEN},
	{0x013B,0x03  ,BYTE_LEN},
	{0x013C,0x40  ,BYTE_LEN},
	{0x013D,0x00  ,BYTE_LEN},
	{0x01AE,0x00  ,BYTE_LEN},
	{0x01AF,0xF5  ,BYTE_LEN},
	{0x01B0,0xF5  ,BYTE_LEN},
	{0x01B1,0x8E  ,BYTE_LEN},
	{0x01B2,0x9F  ,BYTE_LEN},
	{0x01B3,0xA3  ,BYTE_LEN},
	{0x01D3,0x04  ,BYTE_LEN},
	{0x01D4,0x04  ,BYTE_LEN},
	{0x01D5,0x04  ,BYTE_LEN},
	{0x01D6,0x04  ,BYTE_LEN},
	{0x01D7,0x04  ,BYTE_LEN},
	{0x01D8,0x04  ,BYTE_LEN},
	{0x01D9,0x04  ,BYTE_LEN},
	{0x01DA,0x04  ,BYTE_LEN},
	{0x01DB,0x04  ,BYTE_LEN},
	{0x01DC,0x04  ,BYTE_LEN},
	{0x01DD,0x04  ,BYTE_LEN},
	{0x01DE,0x04  ,BYTE_LEN},
	{0x4E5D,0x00  ,BYTE_LEN},
	{0x4E5E,0x0000,WORD_LEN},
	{0x4E60,0x0000,WORD_LEN},
	{0x4E62,0x0000,WORD_LEN},
	{0x4E60,0x0000,WORD_LEN},
	{0x4E64,0x0000,WORD_LEN},
	{0x4E66,0x0000,WORD_LEN},
	{0x4E68,0x0000,WORD_LEN},
	{0x4E6A,0x0000,WORD_LEN},
	{0x4E6C,0x0000,WORD_LEN},
	{0x4E70,0x0000,WORD_LEN},
	{0x4E74,0x0000,WORD_LEN},
	{0x4E78,0x0000,WORD_LEN},
	{0x4E7C,0x0000,WORD_LEN},
	{0x4E62,0x0000,WORD_LEN},
	{0x4E66,0x0000,WORD_LEN},
	{0x4E6A,0x0000,WORD_LEN},
	{0x4E6E,0x0000,WORD_LEN},
	{0x4E72,0x0000,WORD_LEN},
	{0x4E76,0x0000,WORD_LEN},
	{0x4E7A,0x0000,WORD_LEN},
	{0x4E7E,0x0000,WORD_LEN},
	{0x4F24,0x3E  ,BYTE_LEN},
	{0x4F25,0x09  ,BYTE_LEN},
	{0x5000,0xD5FF,WORD_LEN},
	{0x5002,0xF7FF,WORD_LEN},
	{0x5004,0xF0FF,WORD_LEN},
	{0x5006,0xE1FF,WORD_LEN},
	{0x5008,0xFFFF,WORD_LEN},
	{0x500A,0xCDFF,WORD_LEN},
	{0x500C,0xD5FF,WORD_LEN},
	{0x500E,0xF7FF,WORD_LEN},
	{0x5010,0xF0FF,WORD_LEN},
	{0x5012,0xE1FF,WORD_LEN},
	{0x5014,0xFFFF,WORD_LEN},
	{0x5016,0xCDFF,WORD_LEN},
	{0x503C,0xD5FF,WORD_LEN},
	{0x503E,0xF7FF,WORD_LEN},
	{0x5040,0xF0FF,WORD_LEN},
	{0x5042,0xE1FF,WORD_LEN},
	{0x5044,0xFFFF,WORD_LEN},
	{0x5046,0xCDFF,WORD_LEN},
	{0x5018,0xD5FF,WORD_LEN},
	{0x501A,0xF7FF,WORD_LEN},
	{0x501C,0xF0FF,WORD_LEN},
	{0x501E,0xE1FF,WORD_LEN},
	{0x5020,0xFFFF,WORD_LEN},
	{0x5022,0xCDFF,WORD_LEN},
	{0x5048,0xD5FF,WORD_LEN},
	{0x504A,0xF7FF,WORD_LEN},
	{0x504C,0xF0FF,WORD_LEN},
	{0x504E,0xE1FF,WORD_LEN},
	{0x5050,0xFFFF,WORD_LEN},
	{0x5052,0xCDFF,WORD_LEN},
	{0x5024,0xD5FF,WORD_LEN},
	{0x5026,0xF7FF,WORD_LEN},
	{0x5028,0xF0FF,WORD_LEN},
	{0x502A,0xE1FF,WORD_LEN},
	{0x502C,0xFFFF,WORD_LEN},
	{0x502E,0xCDFF,WORD_LEN},
	{0x5030,0x0000,WORD_LEN},
	{0x5032,0xF7FF,WORD_LEN},
	{0x5034,0xEAFF,WORD_LEN},
	{0x5036,0xE8FF,WORD_LEN},
	{0x5038,0xEFFF,WORD_LEN},
	{0x503A,0xC6FF,WORD_LEN},
	{0x5054,0x31  ,BYTE_LEN},
	{0x5055,0x1E  ,BYTE_LEN},
	{0x5056,0x39  ,BYTE_LEN},
	{0x5057,0x19  ,BYTE_LEN},
	{0x5058,0x42  ,BYTE_LEN},
	{0x5059,0x15  ,BYTE_LEN},
	{0x505A,0x53  ,BYTE_LEN},
	{0x505B,0x12  ,BYTE_LEN},
	{0x505C,0x5F  ,BYTE_LEN},
	{0x505D,0x10  ,BYTE_LEN},
	{0x505E,0x3D  ,BYTE_LEN},
	{0x505F,0x17  ,BYTE_LEN},
	{0x5060,0x4B  ,BYTE_LEN},
	{0x5061,0x13  ,BYTE_LEN},
	{0x5092,0xFAFF,WORD_LEN},
	{0x5094,0xEEFF,WORD_LEN},
	{0x5096,0xFAFF,WORD_LEN},
	{0x5098,0xEEFF,WORD_LEN},
	{0x509A,0xFAFF,WORD_LEN},
	{0x509C,0xEEFF,WORD_LEN},
	{0x509E,0xF2FF,WORD_LEN},
	{0x50A0,0xEEFF,WORD_LEN},
	{0x50A2,0x60  ,BYTE_LEN},
	{0x50A3,0x4c  ,BYTE_LEN},
	{0x50A4,0x60  ,BYTE_LEN},
	{0x50A5,0x4c  ,BYTE_LEN},
	{0x50A6,0x60  ,BYTE_LEN},
	{0x50A7,0x4c  ,BYTE_LEN},
	{0x50A8,0x60  ,BYTE_LEN},
	{0x50A9,0x4c  ,BYTE_LEN},
	{0x50C2,0x17  ,BYTE_LEN},
	{0x50C3,0x15  ,BYTE_LEN},
	{0x01B1,0x80  ,BYTE_LEN},
	{0x4E0B,0x01  ,BYTE_LEN},
	{0x4E0C,0x0004,WORD_LEN},
	{0x4E0E,0x0005,WORD_LEN},
	{0x4E10,0xD800,WORD_LEN},
	{0x4E16,0x00  ,BYTE_LEN},
	{0x4E17,0x84  ,BYTE_LEN},
	{0x59BD,0x60  ,BYTE_LEN},
	{0x59BE,0x70  ,BYTE_LEN},
	{0x02D7,0x10  ,BYTE_LEN},
	{0x4E40,0x9c18,WORD_LEN},
	{0x4E42,0x0618,WORD_LEN},
	{0x4E44,0xa00f,WORD_LEN},
	{0x4E46,0x3c0f,WORD_LEN},
	{0x4E48,0x2c1a,WORD_LEN},
	{0x4E4A,0x5c12,WORD_LEN},
	{0x4E50,0x800c,WORD_LEN},
	{0x4E52,0x4e0c,WORD_LEN},
	{0x4E54,0xdd05,WORD_LEN},
	{0x4E56,0x0005,WORD_LEN},
	{0x4E58,0x581b,WORD_LEN},
	{0x4E5A,0x2c1a,WORD_LEN},
	{0x5841,0x07  ,BYTE_LEN},
	{0x5842,0x06  ,BYTE_LEN},
	{0x5843,0x06  ,BYTE_LEN},
	{0x5844,0x06  ,BYTE_LEN},
	{0x5845,0x06  ,BYTE_LEN},
	{0x5846,0x06  ,BYTE_LEN},
	{0x5847,0x06  ,BYTE_LEN},
	{0x5848,0x06  ,BYTE_LEN},
	{0x5849,0x06  ,BYTE_LEN},
	{0x584A,0x06  ,BYTE_LEN},
	{0x584B,0x06  ,BYTE_LEN},
	{0x584C,0x06  ,BYTE_LEN},
	{0x584D,0x06  ,BYTE_LEN},
	{0x584E,0x06  ,BYTE_LEN},
	{0x584F,0x06  ,BYTE_LEN},
	{0x5850,0x00  ,BYTE_LEN},
	{0x5851,0x00  ,BYTE_LEN},
	{0x5852,0x00  ,BYTE_LEN},
	{0x5853,0x00  ,BYTE_LEN},
	{0x5854,0x00  ,BYTE_LEN},
	{0x5855,0x00  ,BYTE_LEN},
	{0x5856,0x00  ,BYTE_LEN},
	{0x5857,0x00  ,BYTE_LEN},
	{0x5876,0x000F,WORD_LEN},
	{0x5878,0x000F,WORD_LEN},
	{0x587A,0x000F,WORD_LEN},
	{0x587C,0xCA03,WORD_LEN},
	{0x587E,0x9A01,WORD_LEN},
	{0x5880,0x0000,WORD_LEN},
	{0x5882,0xBE0A,WORD_LEN},
	{0x5884,0xB409,WORD_LEN},
	{0x5886,0x0807,WORD_LEN},
	{0x59BF,0x20  ,BYTE_LEN},
	{0x59C0,0x20  ,BYTE_LEN},
	{0x59C1,0x00  ,BYTE_LEN},
	{0x59C2,0x20  ,BYTE_LEN},
	{0x59C3,0x20  ,BYTE_LEN},
	{0x59C4,0x00  ,BYTE_LEN},
	{0x59C5,0x09  ,BYTE_LEN},
	{0x59C6,0x09  ,BYTE_LEN},
	{0x59C7,0x00  ,BYTE_LEN},
	{0x59C8,0x08  ,BYTE_LEN},
	{0x59C9,0x08  ,BYTE_LEN},
	{0x59CA,0x00  ,BYTE_LEN},
	{0x59CB,0x08  ,BYTE_LEN},
	{0x59CC,0x08  ,BYTE_LEN},
	{0x59CD,0x00  ,BYTE_LEN},
	{0x59CE,0x08  ,BYTE_LEN},
	{0x59CF,0x08  ,BYTE_LEN},
	{0x59D0,0x00  ,BYTE_LEN},
	{0x59D1,0x08  ,BYTE_LEN},
	{0x59D2,0x08  ,BYTE_LEN},
	{0x59D3,0x00  ,BYTE_LEN},
	{0x59D4,0xF0FF,WORD_LEN},
	{0x59D6,0xF0FF,WORD_LEN},
	{0x59D8,0x0000,WORD_LEN},
	{0x59DA,0xF0FF,WORD_LEN},
	{0x59DC,0xF0FF,WORD_LEN},
	{0x59DE,0x0000,WORD_LEN},
	{0x59E0,0xF0FF,WORD_LEN},
	{0x59E2,0xF0FF,WORD_LEN},
	{0x59E4,0x0000,WORD_LEN},
	{0x59E6,0xF0FF,WORD_LEN},
	{0x59E8,0xF0FF,WORD_LEN},
	{0x59EA,0x0000,WORD_LEN},
	{0x59EC,0xF9  ,BYTE_LEN},
	{0x59ED,0xF9  ,BYTE_LEN},
	{0x59EE,0x00  ,BYTE_LEN},
	{0x59EF,0xFE  ,BYTE_LEN},
	{0x59F0,0xFE  ,BYTE_LEN},
	{0x59F1,0x00  ,BYTE_LEN},
	{0x59F2,0xF9  ,BYTE_LEN},
	{0x59F3,0xF9  ,BYTE_LEN},
	{0x59F4,0x00  ,BYTE_LEN},
	{0x5826,0x08  ,BYTE_LEN},                                                                                                                                                                                          
	{0x5827,0x00  ,BYTE_LEN},                                                                                                                                                                                            
	{0x5828,0x00  ,BYTE_LEN},                                                                                                                                                                                 
	{0x0062,0x22  ,BYTE_LEN},
	{0x5829,0x00  ,BYTE_LEN},
	{0x4F2C,0x0A00,WORD_LEN},
	{0x4F2E,0x0000,WORD_LEN},
	{0x4F30,0x0000,WORD_LEN},
	{0x4F32,0x0A00,WORD_LEN},
	{0x4F34,0x0000,WORD_LEN},
	{0x4F36,0x0000,WORD_LEN},
	{0x4F38,0x10  ,BYTE_LEN},
	{0x4F39,0x17  ,BYTE_LEN},
	{0x4F3A,0x19  ,BYTE_LEN},
	{0x4F3B,0x10  ,BYTE_LEN},
	{0x4F3C,0x17  ,BYTE_LEN},
	{0x4F3D,0x19  ,BYTE_LEN},
	{0x4F3E,0x0A  ,BYTE_LEN},
	{0x4F3F,0x1E  ,BYTE_LEN},
	{0x4F40,0x1E  ,BYTE_LEN},
	{0x4F41,0x00  ,BYTE_LEN},
	{0x4F42,0x03  ,BYTE_LEN},
	{0x4F48,0x00  ,BYTE_LEN},
	{0x4F49,0x00  ,BYTE_LEN},
	{0x4F4A,0x00  ,BYTE_LEN},
	{0x5858,0x5E0A,WORD_LEN},
	{0x585A,0xa406,WORD_LEN},
	{0x585C,0x8000,WORD_LEN},
	{0x5888,0x1500,WORD_LEN},
	{0x588A,0x1300,WORD_LEN},
	{0x588C,0x0600,WORD_LEN},
	{0x588E,0x3300,WORD_LEN},
	{0x5890,0x1000,WORD_LEN},
	{0x5892,0x0400,WORD_LEN},
	{0x5894,0x0200,WORD_LEN},
	{0x5896,0x0200,WORD_LEN},
	{0x5898,0x0000,WORD_LEN},
	{0x589A,0x1200,WORD_LEN},
	{0x589C,0x1200,WORD_LEN},
	{0x589E,0x0A00,WORD_LEN},
	{0x58A6,0x0200,WORD_LEN},
	{0x58A8,0x0200,WORD_LEN},
	{0x58AA,0x0600,WORD_LEN},
	{0x58AC,0x1200,WORD_LEN},
	{0x58AE,0x1200,WORD_LEN},
	{0x58B0,0x0A00,WORD_LEN},
	{0x58B8,0x0100,WORD_LEN},
	{0x58BA,0x0400,WORD_LEN},
	{0x58BC,0x0000,WORD_LEN},
	{0x58BE,0x0500,WORD_LEN},
	{0x58C0,0x0500,WORD_LEN},
	{0x58C2,0x0400,WORD_LEN},
	{0x58CA,0x0100,WORD_LEN},
	{0x58CC,0x0300,WORD_LEN},
	{0x58CE,0x0000,WORD_LEN},
	{0x58D0,0x0500,WORD_LEN},
	{0x58D2,0x0500,WORD_LEN},
	{0x58D4,0x0400,WORD_LEN},
	{0x58DC,0x0400,WORD_LEN},
	{0x58DE,0x0600,WORD_LEN},
	{0x58E0,0x0500,WORD_LEN},
	{0x58E2,0x0C00,WORD_LEN},
	{0x58E4,0x0C00,WORD_LEN},
	{0x58E6,0x0A00,WORD_LEN},
	{0x58EE,0x0400,WORD_LEN},
	{0x58F0,0x0600,WORD_LEN},
	{0x58F2,0x0600,WORD_LEN},
	{0x58F4,0x0C00,WORD_LEN},
	{0x58F6,0x0C00,WORD_LEN},
	{0x58F8,0x0D00,WORD_LEN},
	{0x5900,0x0000,WORD_LEN},
	{0x5902,0x0000,WORD_LEN},
	{0x5904,0x0000,WORD_LEN},
	{0x5906,0x5E01,WORD_LEN},
	{0x5908,0x5E01,WORD_LEN},
	{0x590A,0x5E01,WORD_LEN},
	{0x590C,0x2602,WORD_LEN},
	{0x590E,0x2602,WORD_LEN},
	{0x5910,0x2602,WORD_LEN},
	{0x591E,0x0400,WORD_LEN},
	{0x5920,0x0400,WORD_LEN},
	{0x5922,0x0400,WORD_LEN},
	{0x5924,0x0000,WORD_LEN},
	{0x5926,0x0000,WORD_LEN},
	{0x5928,0x0000,WORD_LEN},
	{0x592A,0xF000,WORD_LEN},
	{0x592C,0x2003,WORD_LEN},
	{0x592E,0x2003,WORD_LEN},
	{0x5930,0x8403,WORD_LEN},
	{0x5932,0x8403,WORD_LEN},
	{0x5934,0x8403,WORD_LEN},
	{0x5942,0x0500,WORD_LEN},
	{0x5944,0x0400,WORD_LEN},
	{0x5946,0x0400,WORD_LEN},
	{0x5948,0x0000,WORD_LEN},
	{0x594A,0x2300,WORD_LEN},
	{0x594C,0x1700,WORD_LEN},
	{0x594E,0x3200,WORD_LEN},
	{0x5950,0x2300,WORD_LEN},
	{0x5952,0x3200,WORD_LEN},
	{0x5954,0xC800,WORD_LEN},
	{0x5956,0x5D00,WORD_LEN},
	{0x5958,0xC800,WORD_LEN},
	{0x5966,0x0100,WORD_LEN},
	{0x5968,0x0000,WORD_LEN},
	{0x596A,0x0500,WORD_LEN},
	{0x596C,0x19  ,BYTE_LEN},
	{0x596D,0x40  ,BYTE_LEN},
	{0x596E,0x40  ,BYTE_LEN},
	{0x596F,0x1e  ,BYTE_LEN},
	{0x5970,0x40  ,BYTE_LEN},
	{0x5971,0x52  ,BYTE_LEN},
	{0x5972,0x00  ,BYTE_LEN},
	{0x5973,0x0C  ,BYTE_LEN},
	{0x5974,0x4B  ,BYTE_LEN},
	{0x5975,0x0a  ,BYTE_LEN},
	{0x5976,0x10  ,BYTE_LEN},
	{0x5977,0x0e  ,BYTE_LEN},
	{0x5978,0x1e  ,BYTE_LEN},
	{0x5979,0x60  ,BYTE_LEN},
	{0x597A,0x62  ,BYTE_LEN},
	{0x597B,0x00  ,BYTE_LEN},
	{0x597C,0x21  ,BYTE_LEN},
	{0x597D,0x5a  ,BYTE_LEN},
	{0x597E,0x10  ,BYTE_LEN},
	{0x597F,0x10  ,BYTE_LEN},
	{0x5980,0x0E  ,BYTE_LEN},
	{0x5981,0x10  ,BYTE_LEN},
	{0x5982,0x10  ,BYTE_LEN},
	{0x5983,0x10  ,BYTE_LEN},
	{0x5984,0x10  ,BYTE_LEN},
	{0x5985,0x10  ,BYTE_LEN},
	{0x5986,0x10  ,BYTE_LEN},
	{0x5987,0x10  ,BYTE_LEN},
	{0x5988,0x10  ,BYTE_LEN},
	{0x5989,0x10  ,BYTE_LEN},
	{0x598A,0x10  ,BYTE_LEN},
	{0x598B,0x10  ,BYTE_LEN},
	{0x598C,0x10  ,BYTE_LEN},
	{0x598D,0x08  ,BYTE_LEN},
	{0x598E,0x08  ,BYTE_LEN},
	{0x598F,0x10  ,BYTE_LEN},
	{0x5990,0x0D  ,BYTE_LEN},
	{0x5991,0x0D  ,BYTE_LEN},
	{0x5992,0x10  ,BYTE_LEN},
	{0x5993,0x10  ,BYTE_LEN},
	{0x5994,0x10  ,BYTE_LEN},
	{0x5995,0x10  ,BYTE_LEN},
	{0x5996,0x10  ,BYTE_LEN},
	{0x5997,0x0C  ,BYTE_LEN},
	{0x5998,0x0C  ,BYTE_LEN},
	{0x5999,0x03  ,BYTE_LEN},
	{0x599A,0x03  ,BYTE_LEN},
	{0x599B,0x08  ,BYTE_LEN},
	{0x599C,0x08  ,BYTE_LEN},
	{0x599D,0x08  ,BYTE_LEN},
	{0x599E,0x10  ,BYTE_LEN},
	{0x599F,0x03  ,BYTE_LEN},
	{0x59A0,0x03  ,BYTE_LEN},
	{0x59A1,0x08  ,BYTE_LEN},
	{0x59A2,0x00  ,BYTE_LEN},
	{0x59A3,0x00  ,BYTE_LEN},
	{0x59A4,0x00  ,BYTE_LEN},
	{0x59A5,0x20  ,BYTE_LEN},
	{0x59A6,0x20  ,BYTE_LEN},
	{0x59A7,0x20  ,BYTE_LEN},
	{0x59A8,0x50  ,BYTE_LEN},
	{0x59A9,0x50  ,BYTE_LEN},
	{0x59AA,0x50  ,BYTE_LEN},
	{0x59AB,0x00  ,BYTE_LEN},
	{0x59AC,0x00  ,BYTE_LEN},
	{0x59AD,0x00  ,BYTE_LEN},
	{0x59AE,0x11  ,BYTE_LEN},
	{0x59AF,0x50  ,BYTE_LEN},
	{0x59B0,0x50  ,BYTE_LEN},
	{0x59B1,0x50  ,BYTE_LEN},
	{0x59B2,0x50  ,BYTE_LEN},
	{0x59B3,0x50  ,BYTE_LEN},
	{0x59B4,0x00  ,BYTE_LEN},
	{0x59B5,0x00  ,BYTE_LEN},
	{0x59B6,0x00  ,BYTE_LEN},
	{0x59B7,0x30  ,BYTE_LEN},
	{0x59B8,0x30  ,BYTE_LEN},
	{0x59B9,0x30  ,BYTE_LEN},
	{0x59BA,0x20  ,BYTE_LEN},
	{0x59BB,0x20  ,BYTE_LEN},
	{0x59BC,0x20  ,BYTE_LEN},
};

static struct isx005_register_address_value_pair const
preview_mode_reg_settings_array[] = {
	{0x001C, 0x00 ,BYTE_LEN},   	// OUTPUT FORMAT MONITOR MODE
#if defined (CONFIG_ISX005_ROTATION_180)
	{0x001F, 0x03	,BYTE_LEN},		//READVECT_MONI
#else
	{0x001F, 0x00	,BYTE_LEN},		//READVECT_MONI
#endif
	{0x0022, 0x8002 ,WORD_LEN},		//640*480 monitoring SIZE H
	{0x0028, 0xE001 ,WORD_LEN},		//640*480 monitoring SIZE V
	{0x00FC, 0x1F ,BYTE_LEN},	// CM_CHANGED          
	{0x0011, 0x00 ,BYTE_LEN},	// MODE_SEL
	{0x0012, 0x01 ,BYTE_LEN},	// MONI_REFRESH_F{              ,BYTE_LEN, 0},
};

#define ISX005_CAPTURE_SIZE_WIDTH		0x0008	//0x0280	//0x0500	// 1280
#define ISX005_CAPTURE_SIZE_HIGHT		0x0006	//0x01E0	//0x03C0	//  960

static struct isx005_register_address_value_pair const
snapshot_mode_reg_settings_array[] = {

	//
	// Snapshot Setting
	//
	{0x001D, 0x00  ,BYTE_LEN},			//OUTPUT CAPTURE MODE
#if defined (CONFIG_ISX005_ROTATION_180)	
	{0x0020, 0x03  ,BYTE_LEN},			//READVECT_CAP
#else
	{0x0020, 0x00  ,BYTE_LEN},			//READVECT_CAP
#endif
	{0x0024, ISX005_CAPTURE_SIZE_WIDTH,WORD_LEN},		//CAPTURE SIZE H
	{0x002A, ISX005_CAPTURE_SIZE_HIGHT,WORD_LEN},		//CAPTURE SIZE V
	{0x0014, 0x00  ,BYTE_LEN},	     	//CAPTURE MODE OUTPUT FRAME NUMBER
	{0x00FC, 0x1F  ,BYTE_LEN},	     	//CM_CHANGED
	{0x0011, 0x02  ,BYTE_LEN},	     	//MODE SELECT
	{0x0012, 0x01  ,BYTE_LEN},	     	// MONI_REFRESH_F

};

static struct isx005_register_address_value_pair const
af_normal_mode_reg_settings_array[] =
{
	{0x00FC, 0x1F, BYTE_LEN},
	{0x01D3, 0x04, BYTE_LEN},	//AF_SN1
	{0x01D4, 0x04, BYTE_LEN},	//AF_SN2
	{0x01D5, 0x04, BYTE_LEN},	//AF_SN3
	{0x01D6, 0x04, BYTE_LEN},	//AF_SN4
	{0x01D7, 0x04, BYTE_LEN},	//AF_SN5
	{0x01D8, 0x04, BYTE_LEN},	//AF_SN6
	{0x01D9, 0x04, BYTE_LEN},	//AF_SN7
	{0x01DA, 0x04, BYTE_LEN},	//AF_SN8
	{0x01DB, 0x04, BYTE_LEN},	//AF_SN9
	{0x01DC, 0x04, BYTE_LEN},	//AF_SN10
	{0x01DD, 0x04, BYTE_LEN},	//AF_SN11
	{0x01DE, 0x04, BYTE_LEN},	//AF_SN12
	{0x002E, 0x02, BYTE_LEN},
	{0x0012, 0x01, BYTE_LEN},
	{0x4852, 0x3200, WORD_LEN},
	{0x4850, 0x01, BYTE_LEN},
};

static struct isx005_register_address_value_pair const
af_macro_mode_reg_settings_array[] =
{
	{0x00FC, 0x1F, BYTE_LEN},
	{0x01D3, 0x02, BYTE_LEN},	//AF_SN1
	{0x01D4, 0x02, BYTE_LEN},	//AF_SN2
	{0x01D5, 0x02, BYTE_LEN},	//AF_SN3
	{0x01D6, 0x02, BYTE_LEN},	//AF_SN4
	{0x01D7, 0x02, BYTE_LEN},	//AF_SN5
	{0x01D8, 0x02, BYTE_LEN},	//AF_SN6
	{0x01D9, 0x02, BYTE_LEN},	//AF_SN7
	{0x01DA, 0x02, BYTE_LEN},	//AF_SN8
	{0x01DB, 0x02, BYTE_LEN},	//AF_SN9
	{0x01DC, 0x02, BYTE_LEN},	//AF_SN10
	{0x01DD, 0x02, BYTE_LEN},	//AF_SN11
	{0x01DE, 0x02, BYTE_LEN},	//AF_SN12
	{0x002E, 0x02, BYTE_LEN},
	{0x0012, 0x01, BYTE_LEN},
	{0x4852, 0x4402, WORD_LEN},
	{0x4850, 0x01, BYTE_LEN},
};

static const struct isx005_register_address_value_pair const
af_manual_mode_reg_settings_array[] =
{
	{0x4884, 0x00, BYTE_LEN},
	{0x01D3, 0x08, BYTE_LEN},	//AF_SN1
	{0x01D4, 0x08, BYTE_LEN},	//AF_SN2
	{0x01D5, 0x08, BYTE_LEN},	//AF_SN3
	{0x01D6, 0x08, BYTE_LEN},	//AF_SN4
	{0x01D7, 0x08, BYTE_LEN},	//AF_SN5
	{0x01D8, 0x08, BYTE_LEN},	//AF_SN6
	{0x01D9, 0x08, BYTE_LEN},	//AF_SN7
	{0x01DA, 0x08, BYTE_LEN},	//AF_SN8
	{0x01DB, 0x08, BYTE_LEN},	//AF_SN9
	{0x01DC, 0x08, BYTE_LEN},	//AF_SN10
	{0x01DD, 0x08, BYTE_LEN},	//AF_SN11
	{0x01DE, 0x08, BYTE_LEN},	//AF_SN12
	{0x002E, 0x02, BYTE_LEN},
	{0x0012, 0x01, BYTE_LEN},
	{0x0015, 0x01, BYTE_LEN},
};

static struct isx005_register_address_value_pair const
af_start_reg_settings_array[] =
{
	{0x002E, 0x00 ,BYTE_LEN},		// AF_MODE 0 : SINGLE_AF
	{0x0012, 0x01 ,BYTE_LEN},		// MONI_REFRESH
};

static const struct isx005_register_address_value_pair const
	scene_mode_auto_reg_settings_array[] = 
{
	{0x0100, 0x00, BYTE_LEN},	// SCENE_SELECT :                                       
	{0x0062, 0x20, BYTE_LEN},	// UISHARPNESS[7:0]   ?????? -1                                                                  
	{0x01BE, 0x01, BYTE_LEN},	// MAx FRAME TYPE2 LONG AE MODE  66MS FOR 1/2S          
	{0x4A00, 0x0D05, WORD_LEN},	//MIN SHT START FROM 2LINE @CAPTURE
	{0x4A02, 0x0000, WORD_LEN},	//MIN AGC
	{0x4016, 0x1621, WORD_LEN},	// NORMSHTSCL_L : 60MS
	{0x4018, 0xCA03, WORD_LEN},	// AGCLOWSCL_L : 3DB  
	{0x401A, 0x0002, WORD_LEN},	// ExPSHTSCL_L : 82MS 
	{0x401C, 0xCA03, WORD_LEN},	// AGCHISCL_L : 9DB   
	{0x401E, 0x6C03, WORD_LEN},	// MAxSHTSCL_L : 110MS2301 
	{0x4020, 0x3004, WORD_LEN},	// AGCMAxSCL_L : 18.3DB

	{0x4887, 0x02, BYTE_LEN},
	{0x4856, 0x28, BYTE_LEN},
	{0x486C, 0x2800, WORD_LEN},
	{0x4870, 0x2800, WORD_LEN},
};

static const struct isx005_register_address_value_pair const 
	scene_mode_portrait_reg_settings_array[] = 
{
	{0x0100, 0x01, BYTE_LEN},	// SCENE_SELECT :                                       
	{0x0062, 0x16, BYTE_LEN},	// UISHARPNESS[7:0]   ?????? -1                                                                  
	{0x01BE, 0x01, BYTE_LEN},	// MAx FRAME TYPE2 LONG AE MODE  66MS FOR 1/2S          
	{0x4A00, 0x0D05, WORD_LEN},	//MIN SHT START FROM 2LINE @CAPTURE
	{0x4A02, 0x0000, WORD_LEN},	//MIN AGC
	{0x4016, 0x1621, WORD_LEN},	// NORMSHTSCL_L : 60MS
	{0x4018, 0xCA03, WORD_LEN},	// AGCLOWSCL_L : 3DB  
	{0x401A, 0x0002, WORD_LEN},	// ExPSHTSCL_L : 82MS 
	{0x401C, 0xCA03, WORD_LEN},	// AGCHISCL_L : 9DB   
	{0x401E, 0x6C03, WORD_LEN},	// MAxSHTSCL_L : 110MS2301 
	{0x4020, 0x3004, WORD_LEN},	// AGCMAxSCL_L : 18.3DB

	{0x4887, 0x02, BYTE_LEN},
	{0x4856, 0x28, BYTE_LEN},
	{0x486C, 0x2800, WORD_LEN},
	{0x4870, 0x2800, WORD_LEN},
};

static const struct isx005_register_address_value_pair const
	scene_mode_landscape_reg_settings_array[] = 
{
	{0x0100, 0x02, BYTE_LEN},	// SCENE_SELECT :                                       
	{0x0062, 0x2A, BYTE_LEN},	// UISHARPNESS[7:0]   ?????? -1                         
	{0x01BE, 0x01, BYTE_LEN},	// MAx FRAME TYPE2 LONG AE MODE  66MS FOR 1/2S                                            
	{0x4A00, 0x0D05, WORD_LEN},	//MIN SHT START FROM 2LINE @CAPTURE
	{0x4A02, 0x0000, WORD_LEN},	//MIN AGC
	{0x4016, 0x1621, WORD_LEN}, // NORMSHTSCL_L : 60MS
	{0x4018, 0xCA03, WORD_LEN}, // AGCLOWSCL_L : 3DB  
	{0x401A, 0x0002, WORD_LEN}, // ExPSHTSCL_L : 82MS 
	{0x401C, 0xCA03, WORD_LEN}, // AGCHISCL_L : 9DB   
	{0x401E, 0x6C03, WORD_LEN}, // MAxSHTSCL_L : 110MS2301 
	{0x4020, 0x3004, WORD_LEN}, // AGCMAxSCL_L : 18.3DB

	{0x4887, 0x02, BYTE_LEN},
	{0x4856, 0x28, BYTE_LEN},
	{0x486C, 0x2800, WORD_LEN},
	{0x4870, 0x2800, WORD_LEN},
};

static const struct isx005_register_address_value_pair const
	scene_mode_sports_reg_settings_array[] =
{
	{0x0100, 0x03, BYTE_LEN},	// SCENE_SELECT :  SPORT
	{0x0062, 0x20, BYTE_LEN},	// UISHARPNESS[7:0]   ??????
	{0x01BE, 0x01, BYTE_LEN},	// MAx FRAME TYPE2 LONG AE MODE  66MS FOR 1/2S
	{0x4A00, 0x0D05, WORD_LEN},	//MIN SHT START FROM 2LINE @CAPTURE
	{0x4A02, 0x0000, WORD_LEN},	//MIN AGC
	{0x4016, 0x1621, WORD_LEN}, // NORMSHTSCL_L : 60MS
	{0x4018, 0xCA03, WORD_LEN}, // AGCLOWSCL_L : 3DB  
	{0x401A, 0x0002, WORD_LEN}, // ExPSHTSCL_L : 82MS 
	{0x401C, 0xCA03, WORD_LEN}, // AGCHISCL_L : 9DB   
	{0x401E, 0x6C03, WORD_LEN}, // MAxSHTSCL_L : 110MS2301 
	{0x4020, 0x3004, WORD_LEN}, // AGCMAxSCL_L : 18.3DB

	{0x4887, 0x02, BYTE_LEN},
	{0x4856, 0x28, BYTE_LEN},
	{0x486C, 0x2800, WORD_LEN},
	{0x4870, 0x2800, WORD_LEN},
};

static const struct isx005_register_address_value_pair const 
	scene_mode_sunset_reg_settings_array[] = 
{
	{0x0100, 0x06, BYTE_LEN},	// SCENE_SELECT :                                       
	{0x0062, 0x20, BYTE_LEN},	// UISHARPNESS[7:0]   ?????? -1                                                                  
	{0x01BE, 0x01, BYTE_LEN},	// MAx FRAME TYPE2 LONG AE MODE  66MS FOR 1/2S          
	{0x4A00, 0x0D05, WORD_LEN},	//MIN SHT START FROM 2LINE @CAPTURE
	{0x4A02, 0x0000, WORD_LEN},	//MIN AGC
	{0x4016, 0x1621, WORD_LEN}, // NORMSHTSCL_L : 60MS
	{0x4018, 0xCA03, WORD_LEN}, // AGCLOWSCL_L : 3DB  
	{0x401A, 0x0002, WORD_LEN}, // ExPSHTSCL_L : 82MS 
	{0x401C, 0xCA03, WORD_LEN}, // AGCHISCL_L : 9DB
	{0x401E, 0x6C03, WORD_LEN}, // MAxSHTSCL_L : 110MS2301 
	{0x4020, 0x3004, WORD_LEN}, // AGCMAxSCL_L : 18.3DB

	{0x4887, 0x02, BYTE_LEN},
	{0x4856, 0x28, BYTE_LEN},
	{0x486C, 0x2800, WORD_LEN},
	{0x4870, 0x2800, WORD_LEN},
};

static const struct isx005_register_address_value_pair const 
	scene_mode_night_reg_settings_array[] = 
{
	{0x4A00, 0x0D05, WORD_LEN},	//MIN SHT START FROM 2LINE @CAPTURE
	{0x4A02, 0x0000, WORD_LEN},	//MIN AGC
	{0x4016, 0x1621, WORD_LEN},	// NORMSHTSCL_L : 60MS
	{0x4018, 0xCA03, WORD_LEN},	// AGCLOWSCL_L : 3DB
	{0x401A, 0x0002, WORD_LEN},	// ExPSHTSCL_L : 82MS
	{0x401C, 0xCA03, WORD_LEN},	// AGCHISCL_L : 9DB
	{0x401E, 0xF307, WORD_LEN},	// MAxSHTSCL_L
	{0x4020, 0x3004, WORD_LEN},	// AGCMAxSCL_L : 18.3DB
	{0x01BE, 0x01, BYTE_LEN},	// MAx FRAME TYPE2 LONG AE MODE  66MS FOR 1/2S
	{0x0130, 0x01, BYTE_LEN},	// AE_SN10 :  AUTO
	{0x0131, 0x8D, BYTE_LEN},	// AE_SUB_SN10 : 1/2S
	{0x0062, 0x20, BYTE_LEN},	// UISHARPNESS[7:0]
	{0x0100, 0x09, BYTE_LEN},	// SCENE_SELECT :

	{0x4887, 0x00, BYTE_LEN},
	{0x4856, 0x3c, BYTE_LEN},
	{0x486C, 0x3C00, WORD_LEN},
	{0x4870, 0x3200, WORD_LEN},
};

struct isx005_reg isx005_regs = {
	.init_reg_settings = init_reg_settings_array,
	.init_reg_settings_size = ARRAY_SIZE(
		init_reg_settings_array),
#if !defined(CONFIG_MACH_MSM7X27_THUNDERG) && !defined(CONFIG_MACH_MSM7X27_THUNDERA)	
	.init_reg32_settings = init_reg32_settings_array,
	.init_reg32_settings_size = ARRAY_SIZE(
		init_reg32_settings_array),
#endif		
	.tuning_reg_settings = tuning_reg_settings_array,
	.tuning_reg_settings_size = ARRAY_SIZE(
		tuning_reg_settings_array),

	.prev_reg_settings = preview_mode_reg_settings_array,
	.prev_reg_settings_size = ARRAY_SIZE(
		preview_mode_reg_settings_array),	
	.snap_reg_settings = snapshot_mode_reg_settings_array,
	.snap_reg_settings_size = ARRAY_SIZE(
		snapshot_mode_reg_settings_array),

	.af_normal_reg_settings = af_normal_mode_reg_settings_array,
	.af_normal_reg_settings_size = ARRAY_SIZE(
		af_normal_mode_reg_settings_array),
	.af_macro_reg_settings = af_macro_mode_reg_settings_array,
	.af_macro_reg_settings_size = ARRAY_SIZE(
		af_macro_mode_reg_settings_array),
	.af_manual_reg_settings = af_manual_mode_reg_settings_array,
	.af_manual_reg_settings_size = ARRAY_SIZE(
		af_manual_mode_reg_settings_array),

	.af_start_reg_settings = af_start_reg_settings_array,
	.af_start_reg_settings_size = ARRAY_SIZE(
		af_start_reg_settings_array),
	
	.scene_auto_reg_settings = scene_mode_auto_reg_settings_array,
	.scene_auto_reg_settings_size = ARRAY_SIZE(
		scene_mode_auto_reg_settings_array),
	.scene_portrait_reg_settings = scene_mode_portrait_reg_settings_array,
	.scene_portrait_reg_settings_size = ARRAY_SIZE(
		scene_mode_portrait_reg_settings_array),
	.scene_landscape_reg_settings = scene_mode_landscape_reg_settings_array,
	.scene_landscape_reg_settings_size = ARRAY_SIZE(
		scene_mode_landscape_reg_settings_array),
	.scene_sports_reg_settings = scene_mode_sports_reg_settings_array,
	.scene_sports_reg_settings_size = ARRAY_SIZE(
		scene_mode_sports_reg_settings_array),
	.scene_sunset_reg_settings = scene_mode_sunset_reg_settings_array,
	.scene_sunset_reg_settings_size = ARRAY_SIZE(
		scene_mode_sunset_reg_settings_array),
	.scene_night_reg_settings = scene_mode_night_reg_settings_array,
	.scene_night_reg_settings_size = ARRAY_SIZE(
		scene_mode_night_reg_settings_array),
};

#endif /* #define ISX005_REG_H */

